#include "Keys.h"






UInt32 keyInfo(EventPtr e,Boolean allowRepeat){
	
	WChar	chr;
	UInt16	keyCode;
	UInt16	modifiers;
	UInt32	expectedMask;
	
	if(e->eType!=keyDownEvent){
		
		return false;
		
	}
	
	chr			= e->data.keyDown.chr;
	keyCode		= e->data.keyDown.keyCode;
	modifiers	= e->data.keyDown.modifiers;
	
	expectedMask=commandKeyMask;
		
	if(allowRepeat)
		expectedMask|=autoRepeatKeyMask;
	
	
	/////CLIE
	
	if(((chr & 0xFF00)==0x1700) && ((modifiers&~(0x80 | expectedMask))==0) && ((modifiers&8)!=0)){	//sony oem key code range
		
		
		if(chr==5897){
			
			return KEY_DIR_RIGHT;
		}
		else if(chr==5896){
			
			return KEY_DIR_LEFT;
		}
		else if(chr==5888){
			
			return KEY_DIR_UP;
		}
		else if(chr==5889){
			
			return KEY_DIR_DOWN;
		}
		else if(chr==5894){
			
			return KEY_DIR_CENTER;
		}
		
		return KEY_DIR_UNKNOWN;
	}
	
	
	
	/////OS 5.4+
	
	else if(modifiers & 8){
		
		
		//if(((modifiers & 0x0800) || (chr==1283) && !(chr==1283 && keyCode & 8)) || (modifiers & 0x0040)){
		//	
		//	return KEY_DIR_UNKNOWN;
		//	
		//}
		
		
		if((modifiers & 0x0040) && !allowRepeat){
			
			return KEY_DIR_UNKNOWN;
			
		}
		if((chr==1283) && (modifiers & expectedMask)){	//os5.2
			
			switch(keyCode){
				
				case 1024:
					
					chr=308;
					break;
				
				case 2048:
					
					chr=309;
					break;
				
				case 4096:
					
					chr=317;
					break;
					
				
			}
			
		}
		if((chr==1283) && (modifiers & 64)){	//OS 5.2
			
			switch(keyCode){
				
				case 1:
					
					chr=11;
					break;
				
				case 2:
					
					chr=12;
					break;
				
				case 4:
					
					chr=308;
					break;
				
				case 8:
					
					chr=309;
					break;
				
				case 16:
					
					chr=317;
					break;
				
			}
			
		}
		
		
		if(chr==306)
			chr=11;
		
		if(chr==307)
			chr=12;
		
		
		if(chr==11){
			
			return KEY_DIR_UP;
		}
		else if(chr==12){
			
			return KEY_DIR_DOWN;
		}
		else if(chr==308){
			
			return KEY_DIR_LEFT;
		}
		else if(chr==309){
			
			return KEY_DIR_RIGHT;
		}
		else if(chr==317){
			
			return KEY_DIR_CENTER;
		}
	}
	
	return KEY_DIR_UNKNOWN;
}


