//********************************************************************
//***                        unitsPda                              ***
//***                      April 14, 2007                          ***
//***              Copyright Glenn Hollowell 2007                  ***
//***                     glenn@blepsias.net                       ***
//***  **********************************************************  ***
//***  Software is provided "AS IS," without a warranty of any     ***
//***  kind. ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES,***
//***  INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS  ***
//***  FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY    ***
//***  EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE ***
//***  IS ASSUMED BY THE USER. See the GNU General Public License  ***
//***  at www.gnu.org for further details.                         ***
//***  *********************************************************** ***
//***  The application was written using the SuperWaba toolset     ***
//***  developed by Guilherme Hazan and his staff at               ***
//***  Superwaba, Ltd. Superwaba is a proprietary development      ***
//***  environment based in part on the Waba development           ***
//***  environment developed by WabaSoft, Inc.                     ***                        
//********************************************************************  

import waba.fx.*;
import waba.sys.*;
import waba.util.*;
import waba.ui.*;
import waba.io.*;

public class chooseUnits extends Container{
	convertUnits convertUnits;
	Label lblLabel;
	Button btnWeight, btnVolume, btnArea, btnVelocity, btnLength, btnExit;
	Button btnEnergy, btnPower, btnPressure, btnTemperature, btnSpeed;
	Color brickRed, glacialTill, moreBlue;
	int iWidth, iHeight;
	static String szHeight;
	static String szWidth;		
	private PushButtonGroup pbgChooseButtons;
	String szChooseButtons[] = {"Length","Weight"," Area ","Volume","Thermal","Speed","Energy","Power","Pressure"};   
	private Font bigFont = Font.getFont("HSW",true,72);
	
	public void onStart(){ 		
		szWidth = unitsPda.szWidth;
		szHeight = unitsPda.szHeight;
		iWidth = Convert.toInt(szWidth);
		iHeight = Convert.toInt(szHeight);
		
		glacialTill = unitsPda.glacialTill;
		brickRed = unitsPda.brickRed;
		moreBlue = unitsPda.moreBlue;	
		
		pbgChooseButtons = new PushButtonGroup(szChooseButtons,false,-1,6,6,3,true,PushButtonGroup.BUTTON); 
		add (pbgChooseButtons);
		if(iHeight>161){//bigger buttons
			pbgChooseButtons.setFont(bigFont);
		}else{//uses default teenie tiny buttons
		}
		pbgChooseButtons.setRect(CENTER,TOP+4,iWidth/32*30,iHeight/32*19);  //}
		
		lblLabel = new Label("Please choose a category of | unit conversion to make.");
		add (lblLabel,CENTER,AFTER+2);
		
		btnExit = new Button("Exit");
		btnExit.setBorder(Button.BORDER_3D);
		if(iHeight>161){//bigger buttons
			btnExit.setFont(bigFont);
		}else{//uses default teenie tiny buttons
		}
		//add (btnExit,RIGHT-2,BOTTOM-2);  
		add (btnExit);
		btnExit.setRect(iWidth/32*17,iHeight/32*25,iWidth/32*11,iHeight/32*4);
		
		if (Settings.isColor){			
			pbgChooseButtons.setBackColor(brickRed);			
			btnExit.setBackColor(brickRed);
			lblLabel.setBackColor(glacialTill);
			this.setBackColor(glacialTill);
		}	
	}			
	public void onEvent(Event event){
		int ipbg;		
		Control edAtual;		
		if (event.type == ControlEvent.PRESSED){   
			if ((event.target == pbgChooseButtons &&
					(ipbg = pbgChooseButtons.getSelected()) != -1)){		
				switch (ipbg){
				case -1:break; //no item selected
				case 0:{ // Length button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						unitsPda.szConversionType = "Length";
					}
				}break;	
				case 1:{ // Weight button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						unitsPda.szConversionType = "Weight";
					}
				}break;
				case 2:{ // Area button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						unitsPda.szConversionType = "Area";
					}
				}break;
				case 3:{ // Volume button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						unitsPda.szConversionType = "Volume";
					}
				}break;	
				case 4:{ // Thermal button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						unitsPda.szConversionType = "Temperature";
					}
				}break;
				case 5:{ // Speed button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						unitsPda.szConversionType = "Speed";
					}
				}break;
				case 6:{ // Energy button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						unitsPda.szConversionType = "Energy";
					}
				}break;	
				case 7:{ // Power button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						unitsPda.szConversionType = "Power";
					}
				}break;
				case 8:{ // Pressure button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						unitsPda.szConversionType = "Pressure";
					}
				}break;}
				if(convertUnits == null) convertUnits = new convertUnits();
				MainWindow.getMainWindow().swap(convertUnits);
			}
		}
		if (event.target == btnExit)
			MainWindow.getMainWindow().exit(0); 		
	}
}

