//********************************************************************
//***                        unitsPda                              ***
//***                      April 14, 2007                          ***
//***              Copyright Glenn Hollowell 2007                  ***
//***                     glenn@blepsias.net                       ***
//***  **********************************************************  ***
//***  Software is provided "AS IS," without a warranty of any     ***
//***  kind. ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES,***
//***  INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS  ***
//***  FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY    ***
//***  EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE ***
//***  IS ASSUMED BY THE USER. See the GNU General Public License  ***
//***  at www.gnu.org for further details.                         ***
//***  *********************************************************** ***
//***  The application was written using the SuperWaba toolset     ***
//***  developed by Guilherme Hazan and his staff at               ***
//***  Superwaba, Ltd. Superwaba is a proprietary development      ***
//***  environment based in part on the Waba development           ***
//***  environment developed by WabaSoft, Inc.                     ***                        
//********************************************************************  
import waba.ui.Button;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Edit;
import waba.ui.Event;
import waba.ui.Label;
import waba.ui.MainWindow;
import waba.ui.MessageBox;
import waba.ui.PushButtonGroup;
import waba.ui.Window;
import waba.fx.*;
import waba.sys.*;
import waba.util.*;
import waba.ui.*;

public class keyPad extends Window {
	Button btnEnter, btnBack;
	String szInput = "",s;    
	String szChoice = unitsPda.szConversionType;  
	String szHeight, szWidth, szPlatform;
	String szKeyPadButtons[] = {"1","2","3","4","5","6","7","8","9",".","0","-"};   
	int i,len,iWidth,iHeight,iPopupWidth,iPopupHeight;
	char c;
	Edit edInput;
	private PushButtonGroup pbgKeyPadButtons;
	//depricated//private Font bigFont=new Font("HSW",Font.PLAIN,72);
	private Font bigFont = Font.getFont("HSW",true,72);
	//Depricated//private Font medFont=new Font("MSW",Font.PLAIN,72);
	private Font medFont = Font.getFont("MSW",true,72);
	//Color brickRed, glacialTill, moreBlue;
	
	public keyPad(){
		super ("",ROUND_BORDER);		
		szWidth = unitsPda.szWidth;
		szHeight = unitsPda.szHeight;
		iWidth = Convert.toInt(szWidth);
		iHeight = Convert.toInt(szHeight);
		szPlatform = unitsPda.szPlatform;
		
		//makes specific ints for popup window control mapping layout
		iPopupWidth = iWidth/32*24;
		iPopupHeight = iHeight/32*30;
		setRect(CENTER,iHeight/32*1,iPopupWidth,iPopupHeight);//sets pop up window position and size
		setBackColor(Color.getColor(80,190,80));//color is dark green
		
		pbgKeyPadButtons = new PushButtonGroup(szKeyPadButtons,false,-1,6,6,4,true,PushButtonGroup.BUTTON); 
		add (pbgKeyPadButtons);
		if(iHeight>161){//bigger buttons
			pbgKeyPadButtons.setFont(bigFont);
		}else{//uses default teenie tiny buttons
		}		 
		pbgKeyPadButtons.setBackColor(Color.getColor(150,150,150));//color = grey
		pbgKeyPadButtons.setRect(CENTER,iPopupHeight/32*4,iPopupWidth/32*31,iPopupHeight/32*16);
		
		btnBack = new Button("    <--    ");
		if(iHeight>161){//bigger buttons
			btnBack.setFont(bigFont);
		}else{//med buttons
			btnBack.setFont(medFont);}	
		btnBack.setBorder(Button.BORDER_3D);
		btnBack.setBackColor(Color.getColor(150,150,150));//color = grey
		add(btnBack,CENTER,iPopupHeight/32*20);
		
		edInput = new Edit();
		add(edInput);
		edInput.setValidChars(Edit.numbersSet);
		edInput.setBackColor(Color.getColor(255,255,255));//color = white
		edInput.setRect(CENTER,iPopupHeight/32*24,iWidth/32*22,PREFERRED);
		edInput.setText(szInput);
		
		btnEnter = new Button("  Enter  ");
		if(iHeight>161){//bigger buttons
			btnEnter.setFont(bigFont);
		}else{
		}
		btnEnter.setBackColor(Color.getColor(150,150,150));//color = grey
		btnEnter.setBorder(Button.BORDER_3D);
		add(btnEnter,CENTER,AFTER+4);
	}
	public void onStart() {   	
		setFont(bigFont);
	}
	
	public void onEvent(Event e){	
		int ipbg;		
		Control edAtual;		
		if (e.type == ControlEvent.PRESSED){   
			if ((e.target == pbgKeyPadButtons &&
					(ipbg = pbgKeyPadButtons.getSelected()) != -1)){		
				switch (ipbg){
				case -1:break; //no item selected
				case 0:{ // 1 button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						szInput = szInput + "1";
						edInput.setText(szInput);
					}
				}break;	
				case 1:{ // 2 button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						szInput = szInput + "2";
						edInput.setText(szInput);
					}
				}break;
				case 2:{ // 3 button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						szInput = szInput + "3";
						edInput.setText(szInput);
					}
				}break;
				case 3:{ // 4 button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						szInput = szInput + "4";
						edInput.setText(szInput);
					}
				}break;	
				case 4:{ // 5 button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						szInput = szInput + "5";
						edInput.setText(szInput);
					}
				}break;
				case 5:{ // 6 button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						szInput = szInput + "6";
						edInput.setText(szInput);
					}
				}break;
				case 6:{ // 7 button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						szInput = szInput + "7";
						edInput.setText(szInput);
					}
				}break;	
				case 7:{ // 8
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						szInput = szInput + "8";
						edInput.setText(szInput);
					}
				}break;
				case 8:{ // 9
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						szInput = szInput + "9";
						edInput.setText(szInput);
					}
				}break;
				case 9:{ // . button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						len = szInput.length();
						for (i = (len - 1); i >= 0; i--){
							c = szInput.charAt(i);
							if (c != '.'){
								continue;
							}
							else{
								MessageBox mb = new MessageBox("Conditional Violation", "Please only put |one decimal point | in your entry. |            Ciao!",null);
								mb.setUnpopDelay(1500);
								mb.popupModal();
								return;	
							}
						}
						szInput = szInput + ".";
						edInput.setText(szInput);
					}
				}break;	
				case 10:{ // 0 button
					edAtual = getParentWindow().getFocus();
					if (edAtual != null) {
						szInput = szInput + "0";
						edInput.setText(szInput);
					}
				}break;
				case 11:{ // minus sign
//					below only allows minus sign(-) at start of string,
					//and if szChoice = "Temperature"
					szInput = edInput.getText();
					if((szInput.compareTo("")==0)&&(szChoice.compareTo("Temperature")==0)){
						szInput = "-";
						edInput.setText(szInput);
					}
					else{
						new MessageBox("Attention","Negative sign is |only valid for |thermal values and |then only at the |start of a string.").popupModal();	      			
					}
				}break;}}				
			else if (e.target == btnBack){
				StringBuffer b = new StringBuffer(szInput);        	
				int i = b.length();
				i=i-1;
				b.setLength(i);
				szInput = b.toString();
				edInput.setText(szInput);
			}
			else if (e.target == btnEnter){
				unitsPda.szInput = szInput;
				unpop();
			}				
		}		
	}
}


