//********************************************************************
//***                        unitsPda                              ***
//***                      April 14, 2007                          ***
//***              Copyright Glenn Hollowell 2007                  ***
//***                     glenn@blepsias.net                       ***
//***  **********************************************************  ***
//***  Software is provided "AS IS," without a warranty of any     ***
//***  kind. ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES,***
//***  INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS  ***
//***  FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY    ***
//***  EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE ***
//***  IS ASSUMED BY THE USER. See the GNU General Public License  ***
//***  at www.gnu.org for further details.                         ***
//***  *********************************************************** ***
//***  The application was written using the SuperWaba toolset     ***
//***  developed by Guilherme Hazan and his staff at               ***
//***  Superwaba, Ltd. Superwaba is a proprietary development      ***
//***  environment based in part on the Waba development           ***
//***  environment developed by WabaSoft, Inc.                     ***                        
//********************************************************************            

/*********************************************************************************
 *  The primary purpose of this application was to develop useful components that 
 * could be used when developing technical data manipulation and handling software
 * using the java running on the SuperWaba VM.
 * 
 *  The secondary purpose was to create a useful scientific and units converter for
 * use on a variety of PDAs.
 * 
 * This application can be recompiled using the public version of Superwaba. Feel free to 
 * modify, improve and extend this application as you see fit.
 * 
 * 				                                             Glenn
 * ********************************************************************************************
 * The conversions used are as follows:
 * 
 * Area
 *	1 hectare = 10000 square meter
 *	1 square yard = 0.836127 square meter
 *	1 square yard = 9 square foot
 *	1 rood = 1210 square yard
 *	1 acre = 4840 square yard
 *	1 square meter = 10000 square centimeter
 *	1 square centimeter = 100 square millimeter
 *	1 square kilometer = 100 hectar
 *	1 square foot = 144 square inches
 *	1 square mile = 640 acres
 *
 *  Distance
 *	1 meter = 100 centimeter
 *	1 centimeter = 10 millimeter
 *  1 meter = 0.001 kilometer
 *	1 meter = 39.3700 inches
 *	1 meter = 1.09361 yard
 *  1 inch = 1/12 foot
 *  1 meter = 1/1609.344 mile
 *	1 meter = 1/1853.184 nautical mile (UK)
 *	1 meter = 1/1852 nautical mile (int.)
 *  1 furlong = 220 yard
 *	1 fathom = 2 yard
 
 *	Energy
 *  1 calorie = 4.1868 Joule
 *	1 watt hour = 3600 Joule
 *	1 kwh = 1000 watt
 *  1 britisch thermal unit = 1055.06 Joule
 
 *	Power
 *	1 foot pound-Force/sec = 1.35582 watt
 *	1 horsepower = 745,7 watt
 
 *  Pressure
 *	1 bar = 100000 pascal
 *	1 standard atmosphere = 1.01325 bar
 *	1 bar = 1000 milli bar
 *	1 millibar = 2.0885435 pounds per square inch
 *	1 pound per square inch = 144 pound per square foot
 *	1 millibar = 1 hectopascal
 *	1 kilopascal = 10 hectopascal
 *	1 bar = 750.0616827 mm Hg
 *	1 bar = 29.5299875 inches Hg
 
 *	Speed
 *	1 km/h = 0.277778 m/s
 *	1 km/h = 0.6213712 mph
 *	1 km/h = 0.5555556 knots
 
 *	Temperature
 *	Fahrenheit = 9 / 5 Celsius + 32
 *	Celsius = (Fahrenheit - 32) * 5 / 9
 *	Kelvin = Celsius + 273.15
 
 *	Time
 *	1 minute = 60 seconds
 *	1 hour = 60 minutes
 *	1 day = 24 hour
 *	1 second = 1000 millisecond
 *	1 year = 365.25 days
 *	1 year = 12 month
 *	1 week = 7 days
 
 *	Volume
 *	1 liter = 1/0.473176 pint (lquid)
 *	1 quart (liquid) = 2 pint (liquid)
 *	1 gallon = 4 quart (liquid)
 *	1 barrel (liquid) = 42 gallons
 *	1 liter = 1/0.55061 pint (dry)
 *	1 qart (dry) = 2 pint (dry)
 *	1 peck = 8 quart (dry)
 *	1 bushel = 4 peck
 *	1 liter = 1/0.568261 pint (UK)
 *	1 quart (UK) = 2 pint (UK)
 *	1 gallon (UK) = 4 quart (UK)
 *	1 peck (UK) = 2 gallon (UK)
 *	1 bushel (UK) = 4 peck (UK)
 *	1 liter = 1000 milliliter
 *	1 Teaspoon = 4.929 milliliter
 *	1 Tablespoon = 3 Teaspoons
 *	1 Cup = 16 Tablespoons
 *	1 ounce (fluid) = 0.02957 liter
 *	1 cubic meter = 1000 liter
 *	1 cubic centimeter = 1 milliliter
 *	1 cubic centimeter = 1000 cubic milliliter
 *	1 barrel (dry) = 3.2812195 bushel
 *	1 Tablespoon (metric) = 15 milliliter
 *	1 teaspoon (metric) = 5 milliliter
 
 *	Weight
 *	1 kilogramm = 1000 gram
 *	1 kilogramm = 0.001 ton (metric)
 *	1 gram = 1000 milligram
 *	1 kilogramm = 1/0.0283495 ounce
 *	1 kilogramm = 1/0.45359237 pound
 *	1 kilogramm = 1/14.5939 slug
 *	1 pound = 1/14 stone
 *	1 stone = 1/2 quarter
 *	1 hunderedWeight = 112 pound
 *	1 ton (UK) = 20 hundredWeight
 *	1 short hundredWeight = 100 pound
 *	1 ton (US) = 20 short hundredWeight
 *	1 grain = 1/7000 pound
 *	1 scruple = 20 grain
 *	1 drachm = 3 scruple
 *	1 apothecaries = 0.0311035 kilogramm
 *	1 pennyweight = 24 grain
 *	1 troy ounce = 20 pennyweight
 *	1 troy pound = 12 troy ounce
 *
 *   4 May 2007 fixed sq foot conversion error, added cubic foot, added acre foot
 *   14 November 2007- made control mapping relative to screen dimensions and fixed
 *   depricated components.
 * ******************************************************************************
 */

import waba.fx.*;
import waba.sys.*;
import waba.util.*;
import waba.ui.*;
import waba.ui.MainWindow;

public class unitsPda extends MainWindow{
	public chooseUnits chooseUnits;
	public convertUnits convertUnits;
	private MenuBar menu, mbar;
	
	static String szInput = "";
	static String szConversionType = "";
	static Color glacialTill = Color.getColor(175,184,189);
	static Color brickRed = Color.getColor(203, 12, 79);	
	static Color moreBlue = Color.getColor(125,125,255);	
	
	static String szPlatform = Settings.platform;
	//returned strings are "Java", "PalmOS", "Win32","PalmOS/SDL"
	//"WindowsCE", "PocketPC","Linux"
	static String szWidth = Convert.toString(Settings.screenWidth,1);
	static String szHeight = Convert.toString(Settings.screenHeight,1);
	
	public unitsPda(){
		super ("unitsPda", TAB_ONLY_BORDER);
		setDoubleBuffer(true);
	}
	public void onStart(){  	
		Vm.interceptSystemKeys(Vm.SK_ALL|Vm.SK_LAUNCH);
		Rect r = getClientRect();
		chooseUnits = new chooseUnits();
		chooseUnits.setRect(r);
		convertUnits = new convertUnits();
		convertUnits.setRect(r);
		swap(chooseUnits); 		
		String col0[] = {"Info","About unitsPda 1.1","About SuperWaba VM","DeviceOS, screensize",};
		//old depricated...//	setMenuBar(mbar = new MenuBar(new String[][]{col0}));
		setMenuBar(mbar = new MenuBar(MenuBar.strings2items(new String[][]{col0})));
		
		if (Settings.isColor){
			this.setBackColor(glacialTill);
		} 
	}
	public void onEvent(Event event){
		switch (event.type){
		case ControlEvent.WINDOW_CLOSED:
			String sel = null;
			if (event.target == mbar)
				switch (mbar.getSelectedMenuItem()){
				case  -1: break; // no item selected
				case   1: new MessageBox("About unitsPda","The purpose of this application|is to provide simple and quick|unit conversions.||||         Glenn Hollowell|           28Feb2007|").popupModal(); break;              
				case   2: new MessageBox("About SuperWaba","SuperWaba Virtual Machine 5.7|www.superwaba.com|Copyright (c)2000-2007|Guilherme Campos Hazan| |SuperWaba is an enhanced version|of the Waba Virtual Machine|Copyright (c) 1998,1999 WabaSoft|www.wabasoft.com").popupModal(); break;                  
				case   3: new MessageBox("OS/screensize",unitsPda.szPlatform + " | " +szHeight + "H "+ "x" + szWidth +"W").popupModal(); break;
				}
			break;
		}
	}
}

