/*  OpenChess.h -- OpenChess PalmOS headers (common)
 *
 *  OpenChess version 2.0, is a CHESS game for Palm Pilot, adapted
 *  from GNU Chess 2, for Unix/DOS environments
 *  Copyright (C) 1986, 1987, 1988 Free Software Foundation, Inc.
 *  Copyright (C) 2002, Son Altesse.
 *  Copyright (C) 2005, Olaf Richter.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// defines
#define sysFileCOpenChess     'OpCh'  // Creator ID for OpenChess
#define OpenChessDBName       "OpenChessDB"
#define OpenChessDBType       'Data'
#define OpenChessOLType       'OLib'
#define VERSION_NUM           25
#define VERSION_NUM_20        20

#define MAX_LIB_LIST  5
#define MAX_STATUS    50
#define MAX_MV_STRING 15
#define MEMO_BUFFER   50
#define MEMO_START    100
#define MEMO_PLUS     20

#define DBG_LEVEL_RESOLUTION 1
#define DBG_15MIN_HASH_ON    2
#define DBG_15MIN_HASH_OFF   3
#define DBG_OPENING_BOOK     4
#define MAX_DBG_LEVEL        4   

#define start_ttblsz   131072L
#define min_ttblsz       2048L

// GNUChess defines
#define neutral 2
#define white 0
#define black 1
#define no_piece 0
#define pawn 1
#define knight 2
#define bishop 3
#define rook 4
#define queen 5
#define king 6
#define valueP 100
#define valueN 350
#define valueB 355
#define valueR 550
#define valueQ 1100
#define valueK 1200
#define ctlP 0x4000
#define ctlN 0x2800
#define ctlB 0x1800
#define ctlR 0x0400
#define ctlQ 0x0200
#define ctlK 0x0100
#define ctlBQ 0x1200
#define ctlRQ 0x0600
#define ctlNN 0x2000
#define pxx " PNBRQK"
//#define qxx " pnbrqk"
#define rxx "12345678"
#define cxx "abcdefgh"
#define check 0x0001
#define capture 0x0002
#define end_mask 0x0004
#define promote 0x0008
#define cstlmask 0x0010
#define epmask 0x0020
#define exact 0x0040
#define pwnthrt 0x0080
#define eps_save 0xff00
#define GL_mask 0xff3e
#define truescore 0x0001
#define lowerbound 0x0002
#define upperbound 0x0004
#define maxdepth 35
#define moves_50 100 // 100 plies = 50 moves for each side
#define true 1
#define false 0
#define absv(x) ((x) < 0 ? -(x) : (x))
#define taxicab(a,b) (abs(column[a]-column[b]) + abs(row[a]-row[b]))
#define multi_ambiguous 'R'
#define white_mates  1
#define black_mates  2
#define stalemate    3
#define rule_50_mv   4
#define threefold_rep 5
#define end_engine   8
#define max_moves    9
#define max_mv_plies 240
#define game_flag_edit 0x0001
#define game_edit_start_black 0x0002

#define CRASHIF(condition, msg) \
	do {if (condition) ErrDisplayFileLineMsg(__FILE__, (UInt16) __LINE__, msg);} while(0)

#define BOOK_MOVE(cnt) \
         (((GameList[cnt].flags&promote)&&(GameList[cnt].prom_piece!=queen))? \
           (GameList[cnt].gmove|((unsigned short)(queen-GameList[cnt].prom_piece))<<6): \
	    GameList[cnt].gmove)

struct leaf
  {
    short f,t,score,reply;
    unsigned short flags;
  };
struct GameRec
  {
    unsigned short gmove, 
                   hint,
                   flags; // check,capture,promote,cstlmask,epmask,eps_save
    unsigned char move_piece,
                  capt_piece,
                  prom_piece; 
    char ambiguous;
    short time; 
  };
struct TimeControlRec
  {
    short moves[2];
    long clock[2];
  };
struct BookEntry
  {
    unsigned short *mv;
    Char   *comments;
  };
struct hashval
  {
    unsigned long bd;
    unsigned short key;
  };
struct hashentry
  {
    unsigned long hashbd;
    unsigned short mv,flags;
    short score,depth;
  };

struct TsqSel
{
  Int16   start;
  Int16   end;
};

typedef struct
{
  short computer;
  short opponent;
  short player;
  short reverse;
  short bothsides;
  short force;
  short endgame;
  short TrainerMode;
  short Level;
  short dither;
  short contempt;
  short Game50;
  short castld[2];
  short kingmoved[2];
  short lrookmoved[2];
  short hrookmoved[2];
  short TCflag;
  short OperatorTime;
  struct TimeControlRec  TimeControl;
  short board[64];
  short GameCnt;
  unsigned short hint;
  unsigned short flags; 
  short epsquare;
  struct TsqSel  sqSel;
  Char Name[MAX_NAME+1];
  unsigned short VarCnt;
  unsigned short SrvCnt;
  unsigned short Res;
} TGame;

typedef struct
{
  Boolean      beep;
  Boolean      fullModeMsg;
  UInt16       Langu;
  UInt16       DbGameIndex;
  UInt16       SaveIndex;
  Boolean      fullMode;
  Boolean      editMode;
  Boolean      OnlyTrainer;
  Boolean      NormGames;
  Char         OLibWhite[dmDBNameLength];
  Char         OLibBlack[dmDBNameLength];
/*  Char         Layout[dmDBNameLength];
  RGBColorType rgbL;
  RGBColorType rgbD;
  Char         MyName[?];
  */
} TOpenChessPrefs;

typedef struct 
{
  UInt16 	nNotes;
  UInt16	param123[15][2];
} Tsound;

typedef struct 
{
  short      offBoard;
  short      szSq;		    
  Boolean    IsNewGame;
  UInt16     nLib;
  Char       **LibNames;
  DmOpenRef  BookDB;
  MemHandle  BookHdl;
  UInt16     *BookData;
  UInt16     **BookDataList;
  UInt32     OpenCnt;
  UInt16     BookRecs;
  struct BookEntry *BookPtr;
  struct BookEntry *Book;
  char       *LibText;
  char       *LibRootText;
  DmOpenRef  OpenChessDB;
  Char       *ProgStrings;
  WinHandle  DispWindowH;
  WinHandle  OffscreenWinH;
  Boolean    playingMode;
  Boolean    fullModeOff;
  Boolean    isHiRes;
  char       man_mv[5];
  char       mvstr[5];
  char       last_mv_string[MAX_MV_STRING]; 
  Int16      last_mtr;
  BitmapTypeV3 	*v3bmp; 
  UInt16     HRrefNum;
  UInt16     HRversion;  
  short      density;
  UInt32     WinVersion;
  char       debugLevel;
  long       ttblsz;
} TGlobals;



