/*  OpenChess_res.h -- OpenChess resources header
 *
 *  OpenChess version 2.0, is a CHESS game for Palm Pilot, adapted
 *  from GNU Chess 2, for Unix/DOS environments
 *  Copyright (C) 1986, 1987, 1988 Free Software Foundation, Inc.
 *  Copyright (C) 2002, Son Altesse.
 *  Copyright (C) 2005, Olaf Richter.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//Consts
#define MAX_NAME      20
#define DLG_X     5
#define DLG_X2   45
#define DLG_X2_5 55
#define DLG_X3   70
#define DLG_X4   90
#define DLG_Y    15
#define BTN_Y     5
#define UP_DOWN_XY  140 
#define UP_DOWN_X   13
#define UP_DOWN_Y   8

// Languages
#define resLF          50 
#define resEnglish 	0
#define resGerman 	1
#define resFrench 	2
#define resSpanish 	3
#define resItalian 	4
#define resDutch   	5

// Forms
#define	frmMain	1000
#define	frmAbout	1001
#define	frmEditBrd	1002
//#define	frmNew	1003
#define	frmPrefs	1004
#define	frmOptions	1005
#define	frmPieces	1006
#define	frmDatabase 1007
#define	frmMainFull	1008
#define	frmPiecesTaken 1009
#define	frmMessage 1010

// Alerts
#define	AlertError		1000
#define	AlertErrTrainer	1001
#define	ConfClearBd		1002
#define	AlertConfOverwrite 1003
#define	AlertSelectSq	1004
#define AlertSaveGame   1005
#define AlertPieceMoved 1006
#define AlertGameEnd    1007
#define AlertFullModeMsg 1008
#define AlertEPPawn     1009
#define	OpeningEndOK	1010
#define	OpeningEndWrong	1011
#define AlertExport     1012
#define AlertOnlyNew    1013
#define AlertNoBooks    1014
#define AlertOldOS		1015
#define AlertAbortThinking 1016
#define AlertErrorNoMemory 1017

// Bitmaps
#define	bmpLogo		1000
#define	bmpPiecesSmall	1001
#define bmpPiecesLarge	1002
#define	bmpButtonsPlay	1003
#define	bmpButtonsPlayLarge	(bmpButtonsPlay+1)
#define	bmpButtonsEdit	1005
#define	bmpButtonsEditLarge	(bmpButtonsEdit+1)
#define bmpUp      1007
#define bmpUpLarge      (bmpUp+1)
#define bmpUpOff   1009
#define bmpUpOffLarge   (bmpUpOff+1)
#define bmpDown    1011
#define bmpDownLarge    (bmpDown+1)
#define bmpDownOff 1013
#define bmpDownOffLarge (bmpDownOff+1)

// Menus
#define	mnufrmMain	1000
#define	mnufrmEditBrd	1001

// Menus items
#define	mnuNew	1000
#define	mnuOptions	1001
#define	mnuClose	1002
#define	mnuUndo	1003
#define	mnuAbout	1004
#define	mnuLoad	1007
#define	mnuSave	1008
#define	mnuEdit	1009
#define	mnuPrefs	1010
#define	mnuHelpEdit	1011
#define	mnuHint	1012
#define	mnuReverse	1014
#define	mnuHelp	1016
#define	mnuClear	1017
#define	mnuSwitchColor	1018
#define	mnuAdd	1019
#define	mnuRemove	1020
#define	mnuDelete	1021
#define	mnuSwitchSides	1022
#define mnuToogleSize	1023
#define mnuMissingPieces	1024
#define mnuExport    1025


// Buttons
#define	cmdClose	1000
#define	btnOK		1000
#define	btnCancel	1001

#define	btnWhiteHum	1003
#define	btnWhiteCom	1004
#define	btnBlackCom	1005
#define	btnBlackHum	1006
#define	chkOTraining 1007
#define	trgCompTime	1008
#define	lstCompTime	1009
#define chkSave	1010
#define fldName     1011
#define	trgDither	1014
#define	trgContempt	1015
#define	lstDither	1017
#define	lstContempt	1019

#define	trgLangu	1003
#define	lstLangu	1004
#define chkFullMsg  1005
#define chkOnlyTrainer 1006
#define	trgLibWhite	1007
#define	lstLibWhite	1008
#define	trgLibBlack	1009
#define	lstLibBlack	1010
#define chkNormGames 1011
#define	chkSound	1012

#define	DbGameList	1003

#define fldMessage  1003
#define	btnUp	    1004
#define	btnDown	    1005

#define	btnNew	1000
#define	btnLoad	1002
#define	btnSave	1003
#define	btnEdit	1004
#define	btnUndo	1005
#define	btnHint	1006
#define	btnReverse	1007
#define	btnSwitch	1008
#define	btnOptions	1009
#define	btnMissingPieces	1010
#define	btnFullscreen     1011
#define	btnDelete     1012

#define	btnClear	1013
#define	btnAdd	1014
#define	btnRemove	1015
#define	btnExit	1016

// Strings
#define	HelpString	1000
#define strHelpNew  1001
#define strHelpOptions	1002
#define strHelpLoad 1003
#define	StrHelpEdit	1004
#define strHelpPrefs	1005
#define	HelpLicense	1006
#define strProgStrings 1007

//Misc
#define	OpenBookRes	1000
#define lblSystem   1001

