/*  gnuchess2.h -- OpenChess headers for GNU Chess2
 *
 *  OpenChess version 2.0, is a CHESS game for Palm Pilot, adapted
 *  from GNU Chess 2, for Unix/DOS environments
 *  Copyright (C) 1986, 1987, 1988 Free Software Foundation, Inc.
 *  Copyright (C) 2002, Son Altesse.
 *  Copyright (C) 2005, Olaf Richter.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// GNUchess Globals
extern short Sdepth,Cdepth;
extern short TCmoves,TCminutes;
extern short TrPnt[maxdepth+1],board[64],color[64];
extern struct GameRec GameList[240];
extern short row[64],column[64];
extern struct hashentry *ttable;
extern unsigned char *history;
extern long ResponseTime,ExtraTime,et,et0,time0,ft;
extern long NodeCnt,ETnodes,HashCnt;
extern short timeout;
extern struct leaf Tree[1500],*root;
extern short PieceList[2][16],PieceCnt[2];

// GNUchess prototypes
#define SECTION_ONE  __attribute__ ((section ("section1")))
//#define SECTION_TWO  __attribute__ ((section ("section2")))

extern void InitializeStats(void);
extern void OpenChessMain(void) SECTION_ONE;
extern void NewGame(void) SECTION_ONE;
extern int VerifyMove(char s[], unsigned short *mv); //SECTION_ONE;
extern void algbr(short f,short t); //SECTION_ONE;
extern int distance(short a,short b);
extern int SelectMove(short side,short iop); //SECTION_ONE;
extern int SqAtakd(short sq,short side);
extern int castle(short side,short kf,short kt,short iop); // SECTION_ONE;
extern void MoveList(short side,short ply); // SECTION_ONE;
extern void MakeMove(short side,struct leaf *node,short *tempb,short *tempc,short *tempsf,short *tempst);
extern void UnmakeMove(short side,struct leaf *node,short *tempb,short *tempc,short *tempsf,short *tempst);
extern void EnPassant(short xside,short f,short t,short iop);
extern void repetition(short *cnt);
