#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include "resource.h"
#include "CommonEditMenu.h"

/* prototypes for internal fucntions. */
static FieldPtr GetFocusObjectPtr(void);


Boolean HandleCommonEditMenu(Word menuID)
{
  FieldPtr field = GetFocusObjectPtr();

  if (!field) return false;
  switch (menuID) {

  case menuitemCommonEditUndoID:
    FldUndo(field);
    return true;
    break;

  case menuitemCommonEditCutID:
    FldCut(field);
    return true;
    break;

  case menuitemCommonEditCopyID:
    FldCopy(field);
    return true;
    break;

  case menuitemCommonEditPasteID:
    FldPaste(field);
    return true;
    break;

  case menuitemCommonEditSelAllID:
    FldSetSelection(field, 0, FldGetTextLength(field));
    return true;
    break;

  default:
    return false;
  }
}


static FieldPtr GetFocusObjectPtr(void)
{
  FormPtr form = FrmGetActiveForm();
  Word focus = FrmGetFocus(form);
  FormObjectKind kind;

  if (focus == noFocus) return NULL;
  kind = FrmGetObjectType(form, focus);
  if (kind == frmFieldObj) {
    return (FrmGetObjectPtr(form, focus));
  } else if (kind == frmTableObj) {
    return (TblGetCurrentField(FrmGetObjectPtr(form, focus)));
  }

  return NULL;
}
