
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include "resource.h"
#include "PCalcMain.h"
#include "PrefForm.h"
#include "Misc.h"
#include "ConvDblToStr.h"

/* define globals. */
static PopupListPtrType gPopuplistDispDigit;
static PopupListPtrType gPopuplistFEBound;
static PopupListPtrType gPopuplistInsDigit;


/* define functions. */

Boolean PrefFormHandleEvent(EventPtr event)
{
  Boolean handled = false;
  FormPtr   form = FrmGetActiveForm();

  switch (event->eType) {
  case frmOpenEvent:
    FrmDrawForm(form);

    AssignPopupListPtr(&gPopuplistDispDigit,
		       poptrigPrefDispdigitID, listPrefDispdigitID);
    AssignPopupListPtr(&gPopuplistFEBound,
		       poptrigPrefFEboundID, listPrefFEboundID);
    AssignPopupListPtr(&gPopuplistInsDigit,
		       poptrigPrefInsdigitID, listPrefInsdigitID);

    SetPopupListSelection(&gPopuplistDispDigit, g.DisplayDigit - 4);
    SetPopupListSelection(&gPopuplistFEBound,   g.NotatBound - 3);
    SetPopupListSelection(&gPopuplistInsDigit,  g.InsertDigit - 4);
    CtlSetValue(GetObjectPtr(checkboxPrefSepintID),
		g.DispAddFormat & ADD_SEP_INTP);
    CtlSetValue(GetObjectPtr(checkboxPrefSepfracID),
		g.DispAddFormat & ADD_SEP_FRACP);

    handled = true;
    break;

  case ctlSelectEvent:
    switch(event->data.ctlSelect.controlID) {
    case buttonPrefOkID:
      g.DisplayDigit = GetPopupListSelection(&gPopuplistDispDigit) + 4;
      g.NotatBound   = GetPopupListSelection(&gPopuplistFEBound) + 3;
      g.InsertDigit  = GetPopupListSelection(&gPopuplistInsDigit) + 4;

      if (CtlGetValue(GetObjectPtr(checkboxPrefSepintID)))
	g.DispAddFormat |= ADD_SEP_INTP;
      else
	g.DispAddFormat &= ~ADD_SEP_INTP;

      if (CtlGetValue(GetObjectPtr(checkboxPrefSepfracID)))
	g.DispAddFormat |= ADD_SEP_FRACP; 
      else
	g.DispAddFormat &= ~ADD_SEP_FRACP;

      FrmGotoForm(formMainID);
      handled = true;
      break;

    case buttonPrefCancelID:
      FrmGotoForm(formMainID);
      handled = true;
      break;
    }
    break;

  case nilEvent:
    handled = true;
    break;
  }

  return handled;
}
