/*
 * Decompiled with CFR 0.152.
 */
package waba.fx;

import waba.fx.Color;
import waba.fx.NativeMethods;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.util.IntHashtable;

public final class Palette {
    public static final int[] default16PaletteScr2Dev;
    public static final int[] default16PaletteDev2Scr;
    public static final int[] default4PaletteScr2Dev;
    public static final int[] default4PaletteDev2Scr;
    private Color[] f1;
    private IntHashtable f2;
    private int f3;
    public static final Palette SystemPalette;

    static {
        int[] nArray = new int[16];
        nArray[0] = 0xFFFFFF;
        nArray[1] = 0xEEEEEE;
        nArray[2] = 0xDDDDDD;
        nArray[3] = 0xCCCCCC;
        nArray[4] = 0xBBBBBB;
        nArray[5] = 0xAAAAAA;
        nArray[6] = 0x999999;
        nArray[7] = 0x888888;
        nArray[8] = 0x777777;
        nArray[9] = 0x666666;
        nArray[10] = 0x555555;
        nArray[11] = 0x444444;
        nArray[12] = 0x333333;
        nArray[13] = 0x222222;
        nArray[14] = 0x111111;
        default16PaletteScr2Dev = nArray;
        int[] nArray2 = new int[16];
        nArray2[1] = 0x111111;
        nArray2[2] = 0x222222;
        nArray2[3] = 0x333333;
        nArray2[4] = 0x444444;
        nArray2[5] = 0x555555;
        nArray2[6] = 0x666666;
        nArray2[7] = 0x777777;
        nArray2[8] = 0x888888;
        nArray2[9] = 0x999999;
        nArray2[10] = 0xAAAAAA;
        nArray2[11] = 0xBBBBBB;
        nArray2[12] = 0xCCCCCC;
        nArray2[13] = 0xDDDDDD;
        nArray2[14] = 0xEEEEEE;
        nArray2[15] = 0xFFFFFF;
        default16PaletteDev2Scr = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 0xFFFFFF;
        nArray3[1] = 0xBFBFBF;
        nArray3[2] = 0x7F7F7F;
        default4PaletteScr2Dev = nArray3;
        int[] nArray4 = new int[4];
        nArray4[1] = 0x7F7F7F;
        nArray4[2] = 0xBFBFBF;
        nArray4[3] = 0xFFFFFF;
        default4PaletteDev2Scr = nArray4;
        SystemPalette = new Palette();
    }

    public Palette() {
        this.m1(Settings.maxColors == 16 ? default16PaletteDev2Scr : (Settings.maxColors == 4 ? default4PaletteDev2Scr : NativeMethods.nm.paletteGetCurrentPalette(this)));
        this.f3 = this.f1.length - 1;
    }

    public Palette(int[] nArray) {
        this.m1(nArray);
        this.f3 = this.f1.length - 1;
    }

    public Palette(Color[] colorArray) {
        if (colorArray == null || colorArray.length > 256) {
            this.m1(NativeMethods.nm.paletteGetCurrentPalette(this));
        } else {
            this.f1 = colorArray;
        }
        this.f3 = this.f1.length - 1;
    }

    public int find(Color color) {
        int n = color.rgb;
        int n2 = this.f1.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.f1[n3].rgb == n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int findNearest(Color color) {
        int n = 0;
        int n2 = 16581376;
        int n3 = color.red;
        int n4 = color.green;
        int n5 = color.blue;
        int n6 = this.f1.length;
        int n7 = 0;
        while (n7 < n6) {
            Color color2 = this.f1[n7];
            int n8 = (n3 - color2.red) * (n3 - color2.red) + (n4 - color2.green) * (n4 - color2.green) + (n5 - color2.blue) * (n5 - color2.blue);
            if (n8 < n2) {
                n = n7;
                n2 = n8;
            }
            ++n7;
        }
        return n;
    }

    public Color getColor(int n) {
        return this.f1[n < 0 ? 0 : (n > this.f3 ? this.f3 : n)];
    }

    public int getColorIndex(Color color) {
        int n;
        int n2;
        if (this.f2 == null) {
            this.f2 = new IntHashtable(this.f1.length * 3 >> 1);
        }
        if ((n2 = this.f2.get(n = color.equ)) == IntHashtable.INVALID) {
            if (Settings.isColor) {
                n2 = this.find(color);
                if (n2 == -1) {
                    n2 = this.findNearest(color);
                }
            } else {
                n2 = Settings.maxColors - 1 - color.equ;
            }
            this.f2.put(n, n2);
        }
        return n2;
    }

    public Color[] getColors() {
        Color[] colorArray = new Color[this.f1.length];
        Vm.copyArray(this.f1, 0, colorArray, 0, this.f1.length);
        return colorArray;
    }

    public static int[] getDeviceRGBs() {
        if (Settings.maxColors >= 256) {
            return SystemPalette.toRGBArray(-1, -1);
        }
        if (Settings.maxColors == 16) {
            return default16PaletteScr2Dev;
        }
        return default4PaletteScr2Dev;
    }

    public void setColor(int n, Color color) {
        if (n <= this.f3) {
            this.f1[n] = color;
        }
    }

    private void m1(int[] nArray) {
        this.f1 = new Color[nArray.length];
        int n = this.f1.length;
        int n2 = 0;
        while (n2 < n) {
            this.f1[n2] = new Color(nArray[n2]);
            ++n2;
        }
    }

    public void setColors(Color[] colorArray, int n) {
        Vm.copyArray(colorArray, 0, this.f1, n, colorArray.length);
    }

    public int size() {
        return this.f1.length;
    }

    public int[] toRGBArray(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = this.f3;
        }
        if (n2 < n) {
            return null;
        }
        int[] nArray = new int[n2 - n + 1];
        int n3 = n;
        int n4 = 0;
        while (n3 <= n2) {
            nArray[n4] = this.f1[n3].rgb;
            ++n3;
            ++n4;
        }
        return nArray;
    }
}

