/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.sys.Convert;
import waba.sys.Settings;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.PenEvent;
import waba.ui.ScrollBar;
import waba.util.Vector;

public class ListBox
extends Container {
    protected Vector items = new Vector();
    protected int offset;
    protected int selectedIndex = -1;
    protected int itemCount;
    protected int visibleItems;
    protected int btnX;
    protected ScrollBar sbar;
    protected boolean simpleBorder;
    private Color f1;
    private Color f2;
    private Color f3;
    private Color[] f4 = new Color[4];
    private Graphics f5;
    private Color f6;

    public ListBox() {
        this(null);
    }

    public ListBox(Object[] objectArray) {
        this.sbar = new ScrollBar();
        super.add(this.sbar);
        this.started = true;
        this.sbar.setLiveScrolling(true);
        if (objectArray != null) {
            this.items = new Vector(objectArray);
            this.itemCount = objectArray.length;
        }
        this.sbar.setMaximum(this.itemCount);
    }

    public void add(Object object) {
        this.items.add(object);
        ++this.itemCount;
        this.sbar.setEnabled(this.enabled && this.visibleItems < this.itemCount);
        this.sbar.setMaximum(this.itemCount);
    }

    public void add(Control control) {
    }

    public void add(Object[] objectArray) {
        if (this.itemCount == 0) {
            this.items = new Vector(objectArray);
            this.itemCount = objectArray.length;
        } else {
            this.itemCount += objectArray.length;
            int n = 0;
            while (n < objectArray.length) {
                this.items.add(objectArray[n]);
                ++n;
            }
        }
        this.sbar.setEnabled(this.enabled && this.visibleItems < this.itemCount);
        this.sbar.setMaximum(this.itemCount);
    }

    protected void drawCursor(Graphics graphics, int n, boolean bl) {
        if (this.offset <= n && n < this.visibleItems + this.offset && n < this.itemCount) {
            int n2 = 3;
            int n3 = 4;
            if (Settings.uiStyle == 1) {
                --n3;
            }
            if (this.simpleBorder) {
                --n2;
                --n3;
            }
            graphics.setClip(n2 - 1, (n3 += (n - this.offset) * this.fmH) - 1, this.btnX - n2, Math.min(this.fmH * this.visibleItems, this.height - n3));
            graphics.setForeColor(bl ? this.f2 : this.f3);
            graphics.setBackColor(bl ? this.f3 : this.f2);
            int n4 = Math.min(this.getItemWidth(n), this.btnX - 4);
            if (n4 == 0) {
                n4 = this.btnX - 4;
            }
            graphics.eraseRect(n2 - 1, n3 - 1, n4 + 2, this.fmH + this.fm.getDescent());
        }
    }

    protected void drawItem(Graphics graphics, int n, int n2, int n3) {
        if (n >= 0 && n < this.itemCount) {
            graphics.drawText(this.items.items[n].toString(), n2, n3);
        }
    }

    protected void find(char c) {
        int n = 0;
        while (n < this.itemCount) {
            String string = this.items.items[n].toString();
            if (string.length() > 0 && Convert.toUpperCase(string.charAt(0)) == c && this.selectedIndex != n) {
                this.select(n);
                this.repaint();
                return;
            }
            ++n;
        }
    }

    public Object getItemAt(int n) {
        if (n >= 0 && n < this.itemCount) {
            return this.items.items[n];
        }
        return "";
    }

    protected int getItemWidth(int n) {
        return this.fm.getTextWidth(this.items.items[n].toString());
    }

    public Object[] getItems() {
        return this.items.toObjectArray();
    }

    public int getPreferredHeight() {
        int n = this.itemCount;
        int n2 = Math.max(this.fmH * n, this.sbar.getPreferredHeight()) + (this.simpleBorder ? 4 : 6);
        if (n == 1) {
            return n2 - 1;
        }
        return n2;
    }

    public int getPreferredWidth() {
        int n = 0;
        int n2 = this.itemCount;
        int n3 = 0;
        while (n3 < n2) {
            n = Math.max(this.getItemWidth(n3), n);
            ++n3;
        }
        return n + (this.simpleBorder ? 4 : 6) + this.sbar.getPreferredWidth();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Object getSelectedItem() {
        if (this.selectedIndex >= 0) {
            return this.items.items[this.selectedIndex];
        }
        return "";
    }

    public int indexOf(Object object) {
        return this.items.find(object);
    }

    public void insert(Object object, int n) {
        this.items.insert(n, object);
        ++this.itemCount;
        this.sbar.setEnabled(this.enabled && this.visibleItems < this.itemCount);
        this.sbar.setMaximum(this.itemCount);
    }

    protected void onBoundsChanged() {
        int n = this.sbar.getPreferredWidth();
        int n2 = this.simpleBorder ? 1 : 2;
        this.visibleItems = (this.height - n2 - 2) / this.fmH;
        this.sbar.setMaximum(this.itemCount);
        this.sbar.setVisibleItems(this.visibleItems);
        this.sbar.setEnabled(this.visibleItems < this.itemCount);
        this.btnX = this.width - n2 - n;
        if (Settings.uiStyle == 1) {
            --this.btnX;
            ++n2;
        }
        this.sbar.setRect(this.btnX, n2, n, this.height - (n2 << 1));
    }

    protected void onColorsChanged(boolean bl) {
        if (bl) {
            this.sbar.setBackForeColors(this.backColor, this.foreColor);
        }
        this.f1 = this.getForeColor();
        this.f2 = this.getBackColor().brighter();
        Color color = this.f6 != null ? this.f6 : (this.f3 = this.f2.equ != Color.WHITE.equ ? this.backColor : this.f2.getCursorColor());
        if (this.f1.equ == this.f3.equ) {
            this.f1 = this.foreColor;
        }
        Graphics.compute3dColors(this.enabled, this.backColor, this.foreColor, this.f4);
    }

    public void onEvent(Event event) {
        switch (event.type) {
            case 498: {
                if (this.f5 != null) {
                    this.f5.free();
                }
                this.f5 = this.createGraphics();
                return;
            }
            case 300: {
                int n;
                if (event.target != this.sbar || (n = this.sbar.getValue()) == this.offset) break;
                this.offset = n;
                this.repaint();
                return;
            }
            case 200: 
            case 203: {
                int n;
                if (event.target != this) break;
                PenEvent penEvent = (PenEvent)event;
                if (penEvent.x >= this.btnX) break;
                ListBox listBox = this;
                if (!listBox.contains(listBox.x + penEvent.x, this.y + penEvent.y) || (n = (penEvent.y - (this.simpleBorder ? 3 : 4)) / this.fmH + this.offset) == this.selectedIndex || n >= this.itemCount) break;
                if (this.selectedIndex >= 0) {
                    ListBox listBox2 = this;
                    listBox2.drawCursor(listBox2.f5, this.selectedIndex, false);
                }
                this.selectedIndex = n;
                ListBox listBox3 = this;
                listBox3.drawCursor(listBox3.f5, this.selectedIndex, true);
                return;
            }
            case 100: {
                int n = ((KeyEvent)event).key;
                if (n == 75000 || n == 75001 || n == 75004 || n == 75005 || n == 76030 || n == 76031) {
                    this.sbar.onEvent(event);
                    return;
                }
                this.find(Convert.toUpperCase((char)n));
                return;
            }
            case 202: {
                if (event.target != this) break;
                PenEvent penEvent = (PenEvent)event;
                int n = (penEvent.y - (this.simpleBorder ? 3 : 4)) / this.fmH + this.offset;
                ListBox listBox = this;
                if (!listBox.contains(listBox.x + penEvent.x, this.y + penEvent.y) || penEvent.x >= this.btnX || n >= this.itemCount) break;
                this.postEvent(new ControlEvent(300, this));
            }
        }
    }

    public void onPaint(Graphics graphics) {
        if (this.f5 == null) {
            this.f5 = this.createGraphics();
        }
        graphics.setBackColor(this.f2);
        graphics.fillRect(0, 0, this.btnX, this.height);
        graphics.setForeColor(this.foreColor);
        if (this.simpleBorder && Settings.uiStyle == 0) {
            graphics.drawRect(0, 0, this.width, this.height);
        } else {
            graphics.draw3dRect(0, 0, this.width, this.height, Settings.uiStyle == 1 ? (byte)5 : 4, false, false, this.f4);
        }
        int n = 3;
        int n2 = 3;
        if (Settings.uiStyle == 1) {
            --n2;
        }
        if (this.simpleBorder) {
            --n;
            --n2;
        }
        graphics.setForeColor(this.f1);
        graphics.setClip(n - 1, n2 - 1, this.btnX - n, this.fmH * this.visibleItems + 1);
        int n3 = Math.min(this.itemCount, this.visibleItems + this.offset);
        int n4 = this.offset;
        while (n4 < n3) {
            this.drawItem(graphics, n4, n, n2);
            ++n4;
            n2 += this.fmH;
        }
        if (this.selectedIndex >= 0) {
            this.drawCursor(graphics, this.selectedIndex, true);
        }
    }

    public void qsort() {
        this.items.qsort();
        this.select(-1);
    }

    public void remove(int n) {
        if (n >= 0 && n < this.itemCount) {
            this.items.del(n);
            --this.itemCount;
            this.sbar.setMaximum(this.itemCount);
            this.sbar.setEnabled(this.enabled && this.visibleItems < this.itemCount);
            if (this.selectedIndex == this.itemCount) {
                ListBox listBox = this;
                listBox.select(listBox.selectedIndex - 1);
            }
            if (this.itemCount == 0) {
                this.selectedIndex = -1;
            }
            if (this.itemCount <= this.visibleItems && this.offset != 0) {
                this.offset = 0;
            }
            this.repaint();
        }
    }

    public void remove(Object object) {
        int n;
        if (this.itemCount > 0 && (n = this.items.find(object)) != -1) {
            this.remove(n);
        }
    }

    public void remove(Control control) {
    }

    public void removeAll() {
        this.items.clear();
        this.sbar.setMaximum(0);
        this.itemCount = 0;
        this.offset = 0;
        this.repaint();
    }

    public void select(int n) {
        if (n >= 0 && n < this.itemCount && n != this.selectedIndex && this.height != 0) {
            int n2;
            this.offset = n;
            int n3 = this.sbar.getVisibleItems();
            if (this.offset + n3 > (n2 = this.sbar.getMaximum())) {
                this.offset = Math.max(n2 - n3, 0);
            }
            this.selectedIndex = n;
            this.sbar.setValue(this.offset);
            this.repaint();
            return;
        }
        if (n == -1) {
            this.offset = 0;
            this.sbar.setValue(0);
            this.selectedIndex = -1;
            this.repaint();
        }
    }

    public void setCursorColor(Color color) {
        this.f6 = color;
        this.onColorsChanged(true);
    }

    public void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.onColorsChanged(false);
            this.sbar.setEnabled(bl && this.visibleItems < this.itemCount);
            this.repaint();
        }
    }

    public void setItemAt(int n, Object object) {
        if (n >= 0 && n < this.itemCount) {
            this.items.set(n, object);
            this.repaint();
        }
    }

    public void setSimpleBorder(boolean bl) {
        this.simpleBorder = bl;
    }

    public int size() {
        return this.itemCount;
    }
}

