/*
 * Decompiled with CFR 0.152.
 */
package waba.fx;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.fx.ISurface;
import waba.fx.NativeMethods;
import waba.fx.Palette;
import waba.io.Catalog;
import waba.io.DataStream;
import waba.io.ResizeStream;
import waba.sys.Convert;
import waba.sys.Settings;

public final class Image
implements ISurface {
    protected int width;
    protected int height;
    private Color f1 = Color.WHITE;
    protected int[] palRGBs;
    int[][] pixels;
    Palette savingPal;

    public Image(int n, int n2) {
        this.width = n;
        this.height = n2;
        NativeMethods.nm.imageCreate(this);
    }

    public Image(String string) {
        NativeMethods.nm.imageLoad(this, string);
    }

    public Image(byte[] byArray) {
        NativeMethods.nm.imageParse(this, byArray);
    }

    public void applyPalette() {
        if (this.palRGBs != null) {
            Graphics._applyPalette(this.palRGBs, 0, this.palRGBs.length - 1);
        }
    }

    public void changeColors(Color color, Color color2) {
        NativeMethods.nm.imageChangeColors(this, color.red, color.green, color.blue, color2.red, color2.green, color2.blue);
    }

    public int createBmp(DataStream dataStream) {
        int n = Settings.maxColors >= 256 ? 8 : (Settings.maxColors == 16 ? 4 : 2);
        int n2 = 32 / n;
        int n3 = (this.width + n2 - 1) / n2 * n2;
        int[] nArray = n >= 8 && this.palRGBs != null ? this.palRGBs : Palette.getDeviceRGBs();
        int n4 = nArray.length;
        int n5 = n4 << 2;
        int n6 = n3 / (8 / n) * this.height;
        int n7 = 54 + n5 + n6;
        dataStream.writeByte(66);
        dataStream.writeByte(77);
        dataStream.writeIntLE(n7);
        dataStream.writeIntLE(0);
        dataStream.writeIntLE(54 + n5);
        dataStream.writeIntLE(40);
        dataStream.writeIntLE(this.width);
        dataStream.writeIntLE(this.height);
        dataStream.writeShortLE(1);
        dataStream.writeShortLE(n);
        dataStream.writeIntLE(0);
        dataStream.writeIntLE(n6);
        dataStream.writeIntLE(2835);
        dataStream.writeIntLE(2835);
        dataStream.writeIntLE(nArray.length);
        dataStream.writeIntLE(nArray.length);
        if (!Settings.onDevice) {
            this.savingPal = new Palette(nArray);
        }
        int n8 = 0;
        while (n8 < nArray.length) {
            dataStream.writeIntLE(nArray[n8]);
            ++n8;
        }
        byte[] byArray = new byte[n3];
        n6 = 0;
        switch (n4) {
            case 16: {
                int n9 = this.height - 1;
                while (n9 >= 0) {
                    this.m1(byArray, n9);
                    int n10 = 0;
                    while (n10 < n3) {
                        byArray[n10 >> 1] = (byte)(byArray[n10] << 4 | byArray[n10 + 1]);
                        n10 += 2;
                    }
                    dataStream.writeBytes(byArray, 0, n3 >> 1);
                    --n9;
                }
                break;
            }
            case 4: {
                int n11 = this.height - 1;
                while (n11 >= 0) {
                    this.m1(byArray, n11);
                    int n12 = 0;
                    while (n12 < n3) {
                        byArray[n12 >> 2] = (byte)(byArray[n12] << 6 | byArray[n12 + 1] << 4 | byArray[n12 + 2] << 2 | byArray[n12 + 3]);
                        n12 += 4;
                    }
                    dataStream.writeBytes(byArray, 0, n3 >> 2);
                    --n11;
                }
                break;
            }
            default: {
                int n13 = this.height - 1;
                while (n13 >= 0) {
                    this.m1(byArray, n13);
                    n6 += dataStream.writeBytes(byArray, 0, n3);
                    --n13;
                }
                break block0;
            }
        }
        return n7;
    }

    public void free() {
        NativeMethods.nm.imageFree(this);
    }

    public Graphics getGraphics() {
        return new Graphics(this);
    }

    public int getHeight() {
        return this.height;
    }

    public Palette getPalette() {
        if (this.palRGBs != null) {
            return new Palette(this.palRGBs);
        }
        return null;
    }

    private void m1(byte[] byArray, int n) {
        NativeMethods.nm.imageGetPixelRow(this, byArray, n);
    }

    public Color getTransparentColor() {
        return this.f1;
    }

    public int getWidth() {
        return this.width;
    }

    public int saveTo(Catalog catalog, String string) {
        Object object;
        if (!(string = Convert.toLowerCase(string)).endsWith(".bmp")) {
            string = String.valueOf(string) + ".bmp";
        }
        int n = catalog.getRecordCount();
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            catalog.setRecordPos(n3);
            object = new DataStream(catalog).readString();
            if (((String)object).compareTo(string) >= 0) {
                if (string.equals(object)) {
                    catalog.deleteRecord();
                }
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            n2 = n;
        }
        ResizeStream resizeStream = new ResizeStream(catalog, this.width * this.height + 1200);
        object = new DataStream(resizeStream);
        resizeStream.startRecord(n2);
        ((DataStream)object).writeString(string);
        n = this.createBmp((DataStream)object);
        resizeStream.endRecord();
        return n;
    }

    public void setPalette(Palette palette) {
        this.palRGBs = palette.toRGBArray(-1, -1);
    }

    public void setTransparentColor(Color color) {
        this.f1 = color;
    }
}

