/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import waba.applet.JavaBridge;
import waba.io.ByteArrayStream;
import waba.io.Catalog;
import waba.io.NativeMethods;
import waba.io.NativeMethods4JDK$CatalogBag;
import waba.io.SerialPort;
import waba.io.Socket;
import waba.io.Stream;
import waba.sys.Convert;
import waba.sys.Vm;
import waba.util.Hashtable;
import waba.util.Vector;

public class NativeMethods4JDK
extends NativeMethods {
    private static String f1;
    private static String f2;
    private static String f3;
    private static String f4;
    static Hashtable _dbHash;
    static Class class$java$lang$String;
    static Class array$B;

    static {
        _dbHash = new Hashtable(10);
    }

    int _readWriteBytes(Catalog catalog, byte[] byArray, int n, int n2, boolean bl) {
        byte[] byArray2 = null;
        try {
            NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
            if (nativeMethods4JDK$CatalogBag._recordPos == -1 || n < 0 || n2 < 0 || n + n2 > byArray.length) {
                return -1;
            }
            if (nativeMethods4JDK$CatalogBag._mode == 1 && !bl || nativeMethods4JDK$CatalogBag._mode == 2 && bl) {
                Vm.debug("Invalid operation at catalog for this mode");
                return -1;
            }
            if (nativeMethods4JDK$CatalogBag._recordPos >= nativeMethods4JDK$CatalogBag._records.size()) {
                Vm.debug("Record not correctly added. RecordPos: " + nativeMethods4JDK$CatalogBag._recordPos + " but RecordCount: " + nativeMethods4JDK$CatalogBag._records.size());
                return -1;
            }
            byArray2 = (byte[])nativeMethods4JDK$CatalogBag._records.elementAt(nativeMethods4JDK$CatalogBag._recordPos);
            if (nativeMethods4JDK$CatalogBag._cursor + n2 > byArray2.length) {
                return -1;
            }
            if (bl) {
                System.arraycopy(byArray2, nativeMethods4JDK$CatalogBag._cursor, byArray, n, n2);
            } else {
                System.arraycopy(byArray, n, byArray2, nativeMethods4JDK$CatalogBag._cursor, n2);
                if (nativeMethods4JDK$CatalogBag._attrs != null) {
                    this.catalogSetRecordAttributes(catalog, (byte)(this.catalogGetRecordAttributes(catalog) | 0x40));
                }
                ++nativeMethods4JDK$CatalogBag.modificationNumber;
            }
            nativeMethods4JDK$CatalogBag._cursor += n2;
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception + " in _readWriteBytes: rec.length: " + (byArray2 == null ? "null" : String.valueOf(byArray2.length)) + ", buf.length: " + byArray.length + ", start: " + n + ", count: " + n2 + ", isRead? " + bl);
            n2 = -1;
        }
        return n2;
    }

    int catalogAddRecord(Catalog catalog, int n) {
        NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
        if (!nativeMethods4JDK$CatalogBag._isOpen) {
            return -1;
        }
        nativeMethods4JDK$CatalogBag._recordPos = nativeMethods4JDK$CatalogBag._records.size();
        nativeMethods4JDK$CatalogBag._records.addElement(new byte[n]);
        nativeMethods4JDK$CatalogBag._attrs.addElement(new Byte(64));
        nativeMethods4JDK$CatalogBag._cursor = 0;
        ++nativeMethods4JDK$CatalogBag.modificationNumber;
        return nativeMethods4JDK$CatalogBag._recordPos;
    }

    int catalogAddRecord(Catalog catalog, int n, int n2) {
        NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
        if (!nativeMethods4JDK$CatalogBag._isOpen || n < 0) {
            return -1;
        }
        if (n2 > nativeMethods4JDK$CatalogBag._records.size()) {
            Vm.debug("Trying to add a record at an invalid position (" + n2 + " > db size + 1).");
            n2 = nativeMethods4JDK$CatalogBag._records.size();
        }
        try {
            nativeMethods4JDK$CatalogBag._records.insertElementAt(new byte[n], n2);
            nativeMethods4JDK$CatalogBag._attrs.insertElementAt(new Byte(64), n2);
            ++nativeMethods4JDK$CatalogBag.modificationNumber;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
        nativeMethods4JDK$CatalogBag._recordPos = n2;
        nativeMethods4JDK$CatalogBag._cursor = 0;
        return nativeMethods4JDK$CatalogBag._recordPos;
    }

    boolean catalogClose(Catalog catalog) {
        return this.catalogClose(NativeMethods4JDK.getCB(catalog));
    }

    boolean catalogClose(NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag) {
        boolean bl = true;
        if (!nativeMethods4JDK$CatalogBag._isOpen) {
            return false;
        }
        if (nativeMethods4JDK$CatalogBag.modificationNumber != nativeMethods4JDK$CatalogBag.originalModificationNumber) {
            try {
                ByteArrayStream byteArrayStream = new ByteArrayStream(2048);
                nativeMethods4JDK$CatalogBag.toPDB(byteArrayStream, nativeMethods4JDK$CatalogBag._records, nativeMethods4JDK$CatalogBag._creator, nativeMethods4JDK$CatalogBag._name, nativeMethods4JDK$CatalogBag._type, nativeMethods4JDK$CatalogBag._attrs);
                JavaBridge.writeBytes(NativeMethods4JDK.getFileName(nativeMethods4JDK$CatalogBag), byteArrayStream.getBuffer(), byteArrayStream.count());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
        }
        nativeMethods4JDK$CatalogBag._isOpen = false;
        nativeMethods4JDK$CatalogBag._recordPos = -1;
        return bl;
    }

    void catalogCreate(Catalog catalog) {
        catalog.bag = ((NativeMethods4JDK)NativeMethods.nm).createCB();
        NativeMethods4JDK$CatalogBag.access$0(NativeMethods4JDK.getCB(catalog));
    }

    void catalogCreate(Catalog catalog, String string, int n) {
        block4: {
            block5: {
                byte[] byArray;
                NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag;
                block3: {
                    catalog.bag = ((NativeMethods4JDK)NativeMethods.nm).createCB();
                    nativeMethods4JDK$CatalogBag = (NativeMethods4JDK$CatalogBag)catalog.bag;
                    String[] stringArray = Convert.tokenizeString(string, '.');
                    if (stringArray == null || stringArray.length < 3) {
                        Vm.debug("Invalid catalog name: " + string + ". It must be in the form MyCatalog.CRTR.TYPE (see documentation)");
                        return;
                    }
                    nativeMethods4JDK$CatalogBag._name = stringArray.length == 3 ? stringArray[0] : string.substring(0, string.length() - 10);
                    nativeMethods4JDK$CatalogBag._creator = stringArray[stringArray.length - 2];
                    nativeMethods4JDK$CatalogBag._type = stringArray[stringArray.length - 1];
                    nativeMethods4JDK$CatalogBag._mode = n;
                    byArray = JavaBridge.readBytes(NativeMethods4JDK.getFileName(nativeMethods4JDK$CatalogBag));
                    if (byArray != null) break block3;
                    if (n != 4) break block4;
                    NativeMethods4JDK$CatalogBag.access$0(nativeMethods4JDK$CatalogBag);
                    break block5;
                }
                try {
                    nativeMethods4JDK$CatalogBag._records = nativeMethods4JDK$CatalogBag.fromPDB(byArray, nativeMethods4JDK$CatalogBag._creator, nativeMethods4JDK$CatalogBag._type, nativeMethods4JDK$CatalogBag._attrs);
                }
                catch (Exception exception) {
                    Vm.debug("EXCEPTION OCCURED WITH '" + string + "' DATABASE");
                    exception.printStackTrace();
                    return;
                }
            }
            _dbHash.put(string, catalog);
            nativeMethods4JDK$CatalogBag._isOpen = true;
        }
    }

    boolean catalogDelete(Catalog catalog) {
        NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
        if (!nativeMethods4JDK$CatalogBag._isOpen) {
            return false;
        }
        _dbHash.remove(nativeMethods4JDK$CatalogBag._name);
        nativeMethods4JDK$CatalogBag._records.clear();
        nativeMethods4JDK$CatalogBag._attrs.clear();
        nativeMethods4JDK$CatalogBag._isOpen = false;
        nativeMethods4JDK$CatalogBag._recordPos = -1;
        try {
            Object object;
            try {
                object = (String)JavaBridge.htOpenedAt.get(NativeMethods4JDK.getFileName(nativeMethods4JDK$CatalogBag));
                if (object != null) {
                    File file = new File((String)object, NativeMethods4JDK.getFileName(nativeMethods4JDK$CatalogBag));
                    Vm.debug(file.toString());
                    if (file.delete()) {
                        return true;
                    }
                    Vm.debug("Cannot delete file phisically. Removing logically...");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = new ByteArrayStream(1024);
            nativeMethods4JDK$CatalogBag.toPDB((Stream)object, nativeMethods4JDK$CatalogBag._records, nativeMethods4JDK$CatalogBag._creator, nativeMethods4JDK$CatalogBag._name, nativeMethods4JDK$CatalogBag._type, nativeMethods4JDK$CatalogBag._attrs);
            JavaBridge.writeBytes(NativeMethods4JDK.getFileName(nativeMethods4JDK$CatalogBag), ((ByteArrayStream)object).getBuffer(), ((ByteArrayStream)object).count());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    boolean catalogDeleteRecord(Catalog catalog) {
        NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
        if (nativeMethods4JDK$CatalogBag._recordPos == -1) {
            return false;
        }
        nativeMethods4JDK$CatalogBag._records.removeElementAt(nativeMethods4JDK$CatalogBag._recordPos);
        nativeMethods4JDK$CatalogBag._attrs.removeElementAt(nativeMethods4JDK$CatalogBag._recordPos);
        nativeMethods4JDK$CatalogBag._recordPos = -1;
        ++nativeMethods4JDK$CatalogBag.modificationNumber;
        return true;
    }

    int catalogGetAttributes(Catalog catalog) {
        return NativeMethods4JDK.getCB((Catalog)catalog).attributes;
    }

    byte catalogGetRecordAttributes(Catalog catalog) {
        NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
        if (nativeMethods4JDK$CatalogBag._recordPos == -1 || nativeMethods4JDK$CatalogBag._attrs == null || nativeMethods4JDK$CatalogBag._recordPos >= nativeMethods4JDK$CatalogBag._attrs.size()) {
            return 0;
        }
        return (byte)((Byte)nativeMethods4JDK$CatalogBag._attrs.elementAt(nativeMethods4JDK$CatalogBag._recordPos) | 0x20);
    }

    int catalogGetRecordCount(Catalog catalog) {
        NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
        if (!nativeMethods4JDK$CatalogBag._isOpen) {
            return -1;
        }
        return nativeMethods4JDK$CatalogBag._records.size();
    }

    int catalogGetRecordPos(Catalog catalog) {
        return NativeMethods4JDK.getCB((Catalog)catalog)._recordPos;
    }

    int catalogGetRecordSize(Catalog catalog) {
        NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
        if (nativeMethods4JDK$CatalogBag._recordPos == -1) {
            return -1;
        }
        return ((byte[])nativeMethods4JDK$CatalogBag._records.elementAt(nativeMethods4JDK$CatalogBag._recordPos)).length;
    }

    int catalogInspectRecord(Catalog catalog, byte[] byArray, int n) {
        byte[] byArray2 = (byte[])NativeMethods4JDK.getCB((Catalog)catalog)._records.elementAt(n);
        int n2 = Math.min(byArray.length, byArray2.length);
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        return n2;
    }

    boolean catalogIsOpen(Catalog catalog) {
        return NativeMethods4JDK.getCB((Catalog)catalog)._isOpen;
    }

    String[] catalogListCatalogs(int n, int n2) {
        int n3;
        Object[] objectArray;
        Vector vector = new Vector(_dbHash.getKeys().toObjectArray());
        if (n != 0 || n2 != 0) {
            int n4 = vector.size() - 1;
            while (n4 >= 0) {
                byte[] byArray = vector.items[n4].toString().getBytes();
                objectArray = byArray;
                int n5 = byArray.length;
                n3 = this.m3((byte)objectArray[n5 - 9], (byte)objectArray[n5 - 8], (byte)objectArray[n5 - 7], (byte)objectArray[n5 - 6]);
                int n6 = this.m3((byte)objectArray[n5 - 4], (byte)objectArray[n5 - 3], (byte)objectArray[n5 - 2], (byte)objectArray[n5 - 1]);
                if (n != 0 && n != n3 || n2 != 0 && n2 != n6) {
                    vector.removeElementAt(n4);
                }
                --n4;
            }
        }
        objectArray = new File(".").list();
        byte[] byArray = new byte[68];
        n3 = 0;
        while (n3 < objectArray.length) {
            if (vector.find(objectArray[n3]) == -1 && (objectArray[n3].toLowerCase().endsWith("prc") || objectArray[n3].toLowerCase().endsWith("pdb"))) {
                try {
                    new FileInputStream(new File(".", objectArray[n3])).read(byArray);
                    int n7 = this.m3(byArray[60], byArray[61], byArray[62], byArray[63]);
                    int n8 = this.m3(byArray[64], byArray[65], byArray[66], byArray[67]);
                    if (!(n != 0 && n != n8 || n2 != 0 && n2 != n7)) {
                        String string = "" + (char)byArray[60] + (char)byArray[61] + (char)byArray[62] + (char)byArray[63];
                        String string2 = "" + (char)byArray[64] + (char)byArray[65] + (char)byArray[66] + (char)byArray[67];
                        String string3 = String.valueOf(objectArray[n3].substring(0, objectArray[n3].indexOf(46))) + '.' + string2 + '.' + string;
                        if (vector.find(string3) == -1) {
                            vector.add(string3);
                        }
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Error in Catalog.listCatalogs while reading " + objectArray[n3]);
                    iOException.printStackTrace();
                }
            }
            ++n3;
        }
        return (String[])vector.toObjectArray();
    }

    int catalogReadBytes(Catalog catalog, byte[] byArray, int n, int n2) {
        return this._readWriteBytes(catalog, byArray, n, n2, true);
    }

    boolean catalogRename(Catalog catalog, String string) {
        NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
        if (!nativeMethods4JDK$CatalogBag._isOpen) {
            return false;
        }
        String[] stringArray = Convert.tokenizeString(string, '.');
        if (stringArray == null || stringArray.length != 3) {
            Vm.debug("Invalid catalog name: " + string + ". It must be in the form MyCatalog.CRTR.TYPE (see documentation)");
            return false;
        }
        String string2 = (String)JavaBridge.htOpenedAt.get(NativeMethods4JDK.getFileName(nativeMethods4JDK$CatalogBag));
        if (string2 != null) {
            try {
                if (!new File(string2, NativeMethods4JDK.getFileName(nativeMethods4JDK$CatalogBag)).delete()) {
                    Vm.debug("Cannot delete file phisically on Rename. The file will simply be copied with the new given name.");
                }
            }
            catch (Exception exception) {}
        }
        nativeMethods4JDK$CatalogBag._name = stringArray[0];
        nativeMethods4JDK$CatalogBag._creator = stringArray[1];
        nativeMethods4JDK$CatalogBag._type = stringArray[2];
        if (string2 != null) {
            JavaBridge.htOpenedAt.put(NativeMethods4JDK.getFileName(nativeMethods4JDK$CatalogBag), string2);
        }
        return true;
    }

    boolean catalogResizeRecord(Catalog catalog, int n) {
        byte[] byArray;
        NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
        if (nativeMethods4JDK$CatalogBag._recordPos == -1) {
            return false;
        }
        byte[] byArray2 = (byte[])nativeMethods4JDK$CatalogBag._records.elementAt(nativeMethods4JDK$CatalogBag._recordPos);
        int n2 = byArray2.length < (byArray = new byte[n]).length ? byArray2.length : byArray.length;
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        nativeMethods4JDK$CatalogBag._records.setElementAt(byArray, nativeMethods4JDK$CatalogBag._recordPos);
        ++nativeMethods4JDK$CatalogBag.modificationNumber;
        return true;
    }

    void catalogSetAttributes(Catalog catalog, int n) {
        NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
        NativeMethods4JDK.getCB(catalog).attributes = (short)n;
        ++nativeMethods4JDK$CatalogBag.modificationNumber;
    }

    void catalogSetRecordAttributes(Catalog catalog, byte by) {
        NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
        if (nativeMethods4JDK$CatalogBag._recordPos == -1 || nativeMethods4JDK$CatalogBag._attrs == null || nativeMethods4JDK$CatalogBag._recordPos >= nativeMethods4JDK$CatalogBag._attrs.size()) {
            Vm.debug("could not change record attributes");
            return;
        }
        nativeMethods4JDK$CatalogBag._attrs.setElementAt(new Byte(by), nativeMethods4JDK$CatalogBag._recordPos);
        ++nativeMethods4JDK$CatalogBag.modificationNumber;
    }

    boolean catalogSetRecordPos(Catalog catalog, int n) {
        NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
        if (n < 0 || n >= nativeMethods4JDK$CatalogBag._records.size()) {
            nativeMethods4JDK$CatalogBag._recordPos = -1;
            return false;
        }
        if (nativeMethods4JDK$CatalogBag._attrs != null && ((Byte)nativeMethods4JDK$CatalogBag._attrs.elementAt(n) & 0xFFFFFF80) != 0) {
            Vm.debug("You cannot setRecordPos in a deleted record");
            return false;
        }
        nativeMethods4JDK$CatalogBag._recordPos = n;
        nativeMethods4JDK$CatalogBag._cursor = 0;
        return true;
    }

    int catalogSkipBytes(Catalog catalog, int n) {
        NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag = NativeMethods4JDK.getCB(catalog);
        if (nativeMethods4JDK$CatalogBag._recordPos == -1) {
            return -1;
        }
        byte[] byArray = (byte[])nativeMethods4JDK$CatalogBag._records.elementAt(nativeMethods4JDK$CatalogBag._recordPos);
        int n2 = nativeMethods4JDK$CatalogBag._cursor + n;
        if (n2 < 0 || n2 > byArray.length) {
            return -1;
        }
        nativeMethods4JDK$CatalogBag._cursor += n;
        return n;
    }

    int catalogWriteBytes(Catalog catalog, byte[] byArray, int n, int n2) {
        return this._readWriteBytes(catalog, byArray, n, n2, false);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    NativeMethods4JDK$CatalogBag createCB() {
        return new NativeMethods4JDK$CatalogBag(this);
    }

    static final NativeMethods4JDK$CatalogBag getCB(Catalog catalog) {
        return (NativeMethods4JDK$CatalogBag)catalog.bag;
    }

    static String getFileName(NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag) {
        return String.valueOf(nativeMethods4JDK$CatalogBag._name) + ".pdb";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String m1(int n) {
        if (f1 == null) {
            NativeMethods4JDK.m2();
        }
        switch (n) {
            case 0: {
                return f1;
            }
            case 4096: {
                return f2;
            }
            case 4097: {
                return f3;
            }
            case 4098: {
                return f4;
            }
        }
        try {
            Object e;
            String string;
            Enumeration enumeration = (Enumeration)Class.forName("javax.comm.CommPortIdentifier").getMethod("getPortIdentifiers", null).invoke(null, null);
            if (n == 0) {
                if (!enumeration.hasMoreElements()) return null;
                Object e2 = enumeration.nextElement();
                return (String)e2.getClass().getMethod("getName", null).invoke(e2, null);
            }
            do {
                if (enumeration.hasMoreElements()) continue;
                return null;
            } while ((string = (String)(e = enumeration.nextElement()).getClass().getMethod("getName", null).invoke(e, null)).indexOf(n + 48) == -1);
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static void m2() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("swserial");
            f1 = resourceBundle.getString("DEFAULT");
            f2 = resourceBundle.getString("IRCOMM");
            f3 = resourceBundle.getString("SIR");
            f4 = resourceBundle.getString("USB");
            return;
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal Error: missing resource bundle: " + missingResourceException.getClassName());
        }
    }

    private int m3(byte by, byte by2, byte by3, byte by4) {
        return by << 24 | by2 << 16 | by3 << 8 | by4;
    }

    boolean serialPortClose(SerialPort serialPort) {
        try {
            serialPort.thisSerialPort.getClass().getSuperclass().getMethod("close", null).invoke(serialPort.thisSerialPort, null);
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            serialPort.lastError = 65525;
            return false;
        }
    }

    void serialPortCreate(SerialPort serialPort, int n, int n2, int n3, boolean bl, int n4) {
        try {
            Class<?> clazz = Class.forName("javax.comm.CommPortIdentifier");
            String string = this.m1(n);
            System.out.println("Port found: " + string);
            Object object = clazz.getMethod("getPortIdentifier", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = NativeMethods4JDK.class$("java.lang.String"))).invoke(null, string);
            Object object2 = object.getClass().getMethod("open", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = NativeMethods4JDK.class$("java.lang.String")), Integer.TYPE).invoke(object, "SuperWaba", new Integer(1000));
            Class<?> clazz2 = object2.getClass().getSuperclass();
            Method method = clazz2.getMethod("setSerialPortParams", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Field field = clazz2.getField(bl ? "PARITY_EVEN" : "PARITY_NONE");
            method.invoke(object2, new Integer(n2), new Integer(n3), new Integer(n4), new Integer(field.getInt(object2)));
            clazz2.getMethod("enableReceiveTimeout", Integer.TYPE).invoke(object2, new Integer(100));
            Method method2 = clazz2.getMethod("getInputStream", null);
            serialPort.thisInputStream = method2.invoke(object2, null);
            Method method3 = clazz2.getMethod("getOutputStream", null);
            serialPort.thisOutputStream = method3.invoke(object2, null);
            serialPort.thisSerialPort = object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            invocationTargetException.printStackTrace();
            System.out.println("Exception thrown when creating SerialPort: " + invocationTargetException2.getMessage());
            System.out.println("The probable cause of this message is that the port is in use (You must kill HotSync)\nor that the win32com.dll is not accessible in your path. Please add '<swroot>superwaba/apps/xplat/commapi' to your path or add '-Djava.library.path=<swroot>superwaba/apps/xplat/commapi' to your java.exe command (note: <swroot> is the location where SuperWaba SDK is installed)");
            serialPort.thisSerialPort = null;
            serialPort.lastError = 65525;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println("Cannot find javax.comm.CommPortIdentifier. You must add the <swroot>superwaba/apps/xplat/commapi/comm.jar file to your classpath. If you're not using Windows, then you must download the respective Comm api at http://java.sun.com/products/javacomm/");
            serialPort.thisSerialPort = null;
            serialPort.lastError = 65525;
        }
        catch (Throwable throwable) {
            System.out.println("Exception occured when creating serial port: " + throwable.toString());
            throwable.printStackTrace();
            serialPort.thisSerialPort = null;
            serialPort.lastError = 771;
        }
        if (serialPort.thisSerialPort == null) {
            System.exit(0);
        }
    }

    boolean serialPortIsOpen(SerialPort serialPort) {
        return serialPort.thisSerialPort != null;
    }

    int serialPortReadBytes(SerialPort serialPort, byte[] byArray, int n, int n2) {
        try {
            int n3;
            Method method = serialPort.thisInputStream.getClass().getSuperclass().getMethod("read", array$B != null ? array$B : (array$B = NativeMethods4JDK.class$("[B")), Integer.TYPE, Integer.TYPE);
            int n4 = n2;
            do {
                n3 = (Integer)method.invoke(serialPort.thisInputStream, byArray, new Integer(n), new Integer(n2));
                n += n3;
            } while ((n2 -= n3) > 0);
            return n4;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            serialPort.lastError = 778;
            return -1;
        }
    }

    int serialPortReadCheck(SerialPort serialPort) {
        try {
            return (Integer)serialPort.thisInputStream.getClass().getSuperclass().getMethod("available", null).invoke(serialPort.thisInputStream, null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return -1;
        }
    }

    boolean serialPortSetFlowControl(SerialPort serialPort, boolean bl) {
        try {
            Field field = serialPort.thisSerialPort.getClass().getSuperclass().getField("FLOWCONTROL_RTSCTS_IN");
            Field field2 = serialPort.thisSerialPort.getClass().getSuperclass().getField("FLOWCONTROL_RTSCTS_OUT");
            Field field3 = serialPort.thisSerialPort.getClass().getSuperclass().getField("FLOWCONTROL_NONE");
            serialPort.thisSerialPort.getClass().getSuperclass().getMethod("setFlowControlMode", Integer.TYPE).invoke(serialPort.thisSerialPort, bl ? new Integer(field.getInt(serialPort.thisSerialPort) | field2.getInt(serialPort.thisSerialPort)) : new Integer(field3.getInt(serialPort.thisSerialPort)));
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            serialPort.lastError = 778;
            return false;
        }
    }

    boolean serialPortSetReadTimeout(SerialPort serialPort, int n) {
        try {
            serialPort.thisSerialPort.getClass().getSuperclass().getMethod("enableReceiveTimeout", Integer.TYPE).invoke(serialPort.thisSerialPort, new Integer(n));
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            serialPort.lastError = 778;
            return false;
        }
    }

    int serialPortWriteBytes(SerialPort serialPort, byte[] byArray, int n, int n2) {
        try {
            serialPort.thisOutputStream.getClass().getSuperclass().getMethod("write", array$B != null ? array$B : (array$B = NativeMethods4JDK.class$("[B")), Integer.TYPE, Integer.TYPE).invoke(serialPort.thisOutputStream, byArray, new Integer(n), new Integer(n2));
            return n2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return -1;
        }
    }

    boolean socketClose(Socket socket) {
        if (!socket._isOpen) {
            return false;
        }
        socket._isOpen = false;
        boolean bl = true;
        try {
            ((java.net.Socket)socket._socket).close();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    void socketCreate(Socket socket, String string, int n, int n2, boolean bl) {
        socket._isOpen = false;
        try {
            socket._socket = new java.net.Socket(string, n);
            ((java.net.Socket)socket._socket).setSoTimeout(n2);
            socket._in = ((java.net.Socket)socket._socket).getInputStream();
            socket._out = ((java.net.Socket)socket._socket).getOutputStream();
            socket._isOpen = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!socket._isOpen && socket._socket != null) {
            try {
                ((java.net.Socket)socket._socket).close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    boolean socketDisconnect() {
        System.out.println("Not implemented in this platform");
        return true;
    }

    boolean socketIsOpen(Socket socket) {
        return socket._isOpen;
    }

    int socketReadBytes(Socket socket, byte[] byArray, int n, int n2) {
        if (!socket._isOpen) {
            return -1;
        }
        int n3 = -1;
        try {
            n3 = ((InputStream)socket._in).read(byArray, n, n2);
        }
        catch (InterruptedIOException interruptedIOException) {
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n3;
    }

    boolean socketSetReadTimeout(Socket socket, int n) {
        if (n < 0) {
            return false;
        }
        if (n == 0) {
            n = 1;
        }
        try {
            ((java.net.Socket)socket._socket).setSoTimeout(n);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    int socketWriteBytes(Socket socket, byte[] byArray, int n, int n2) {
        if (!socket._isOpen) {
            return -1;
        }
        int n3 = -1;
        try {
            ((OutputStream)socket._out).write(byArray, n, n2);
            n3 = n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n3;
    }
}

