/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.FontMetrics;
import waba.fx.Graphics;
import waba.fx.Rect;
import waba.fx.Sound;
import waba.sys.Settings;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.Label;
import waba.ui.PenEvent;
import waba.ui.PushButtonGroup;
import waba.ui.Timer;
import waba.ui.Window;

public class MessageBox
extends Window {
    private Label f1;
    private PushButtonGroup f2;
    private int f3 = -1;
    private boolean f4 = false;
    private int f5;
    private int f6;
    private int f7 = 14;
    private int f8 = 6;
    private Timer f9;

    public MessageBox(String string, String string2) {
        this(string, string2, new String[]{"Ok"});
    }

    public MessageBox(String string, String string2, String[] stringArray) {
        super(string, (byte)2);
        this.highResPrepared = true;
        this.setDoubleBuffer(true);
        if (stringArray != null) {
            this.f2 = new PushButtonGroup(stringArray, false, -1, 4, 6, 1, false, 1);
        }
        this.f1 = new Label(string2, 120000);
        int n = this.f2 == null ? 0 : this.f2.getPreferredWidth();
        int n2 = this.f2 == null ? 0 : this.f2.getPreferredHeight();
        int n3 = Math.min(this.f1.getPreferredWidth() + 1, Settings.screenWidth - 6);
        int n4 = this.f1.getPreferredHeight();
        MessageBox messageBox = this;
        FontMetrics fontMetrics = messageBox.getFontMetrics(messageBox.titleFont);
        int n5 = fontMetrics.getHeight() + 8;
        if (n5 + n2 + n4 > Settings.screenHeight) {
            if (n2 == 0) {
                n2 = this.f8;
            }
            n4 = Settings.screenHeight - n5 - n2 - this.f8;
            this.f4 = true;
        }
        int n6 = n5 + n2 + n4;
        int n7 = Math.min(Math.max(Math.max(n, n3), fontMetrics.getTextWidth(string)) + 6, Settings.screenWidth);
        this.setRect(120000, 120000, n7, n6);
        MessageBox messageBox2 = this;
        messageBox2.add(messageBox2.f1);
        if (this.f2 != null) {
            MessageBox messageBox3 = this;
            messageBox3.add(messageBox3.f2);
        }
        this.f1.setRect(4, n5 - 6, n3, n4);
        if (this.f2 != null) {
            this.f2.setRect(120000, n5 - 4 + n4, n, n2);
        }
        Rect rect = this.f1.getRect();
        this.f5 = rect.x + rect.width - (this.f7 << 1);
        this.f6 = rect.y + rect.height + 3;
        if (Settings.isColor) {
            this.setBackForeColors(new Color(0xFF0000), new Color(0xFFFFFF));
        }
    }

    public int getPressedButtonIndex() {
        return this.f3;
    }

    protected void onColorsChanged(boolean bl) {
        if (bl) {
            this.f1.setBackForeColors(this.backColor, this.foreColor);
            if (this.f2 != null) {
                if (this.backColor.getAlpha() < this.foreColor.getAlpha()) {
                    this.f2.setBackForeColors(this.foreColor, this.backColor);
                    return;
                }
                this.f2.setBackForeColors(this.backColor, this.foreColor);
            }
        }
    }

    public void onEvent(Event event) {
        switch (event.type) {
            case 303: {
                if (event.target != this) break;
                MessageBox messageBox = this;
                messageBox.removeTimer(messageBox.f9);
                this.unpop();
                return;
            }
            case 200: {
                if (!this.f4) break;
                int n = ((PenEvent)event).x;
                int n2 = ((PenEvent)event).y;
                if (this.f6 > n2 || n2 > this.f6 + this.f8 || this.f5 > n || n >= this.f5 + (this.f7 << 1) || !this.f1.scroll((n - this.f5) / this.f7 != 0)) break;
                this.repaint();
                Sound.beep();
                return;
            }
            case 100: {
                int n = ((KeyEvent)event).key;
                if (n == 75000 || n == 75004 || n == 76030) {
                    this.f1.scroll(false);
                    this.repaint();
                    return;
                }
                if (n != 75001 && n != 75005 && n != 76031) break;
                this.f1.scroll(true);
                this.repaint();
                return;
            }
            case 300: {
                if (event.target != this.f2 || (this.f3 = this.f2.getSelected()) == -1) break;
                this.f2.setSelected(-1);
                this.unpop();
            }
        }
    }

    public void onPaint(Graphics graphics) {
        if (this.f4) {
            graphics.drawArrow(this.f5, this.f6, this.f8, (byte)1, false, this.f1.canScroll(false), this.foreColor);
            graphics.drawArrow(this.f5 + this.f7, this.f6, this.f8, (byte)2, false, this.f1.canScroll(true), this.foreColor);
        }
    }

    public void setTextAlignment(int n) {
        this.f1.align = n;
    }

    public void setUnpopDelay(int n) {
        if (n > 0) {
            this.f9 = this.addTimer(n);
        }
    }
}

