/*
 * Decompiled with CFR 0.152.
 */
package waba.util;

import waba.io.DataStream;
import waba.sys.Vm;

public final class IntVector {
    public static final int INVALID = Integer.MIN_VALUE;
    public int[] items;
    private int f1;

    public IntVector() {
        this(20);
    }

    public IntVector(int n) {
        this.items = new int[n];
    }

    public IntVector(DataStream dataStream) {
        this.f1 = dataStream.readShort();
        this.items = new int[this.f1 + 5];
        int n = 0;
        while (n < this.f1) {
            this.items[n] = dataStream.readInt();
            ++n;
        }
    }

    public void add(int n) {
        if (this.f1 < this.items.length) {
            this.items[this.f1++] = n;
            return;
        }
        IntVector intVector = this;
        intVector.insert(intVector.f1, n);
    }

    public void addElement(int n) {
        this.add(n);
    }

    public void clear() {
        int n = 0;
        while (n < this.f1) {
            this.items[n] = 0;
            ++n;
        }
        this.f1 = 0;
    }

    public void del(int n) {
        if (n != this.f1 - 1) {
            Vm.copyArray(this.items, n + 1, this.items, n, this.f1 - n - 1);
        }
        this.items[this.f1 - 1] = 0;
        --this.f1;
    }

    public int elementAt(int n) {
        return this.items[n];
    }

    public void ensureBit(short s) {
        int n = (s >> 5) + 1;
        if (n >= this.items.length) {
            if (this.f1 == 0) {
                this.items = new int[n];
            } else {
                int[] nArray = new int[n];
                Vm.copyArray(this.items, 0, nArray, 0, this.f1);
                this.items = nArray;
            }
        }
        this.f1 = n;
    }

    public int find(int n) {
        return this.find(n, 0);
    }

    public int find(int n, int n2) {
        int n3 = n2;
        while (n3 < this.f1) {
            if (this.items[n3] == n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int getCount() {
        return this.f1;
    }

    public int indexOf(int n) {
        return this.find(n, 0);
    }

    public int indexOf(int n, int n2) {
        return this.find(n, n2);
    }

    public void insert(int n, int n2) {
        if (n < 0 || n > this.f1) {
            n = this.f1;
        }
        if (this.f1 == this.items.length) {
            int[] nArray = new int[this.items.length * 12 / 10 + 1];
            Vm.copyArray(this.items, 0, nArray, 0, this.f1);
            this.items = nArray;
        }
        if (n != this.f1) {
            Vm.copyArray(this.items, n, this.items, n + 1, this.f1 - n);
        }
        this.items[n] = n2;
        ++this.f1;
    }

    public void insertElementAt(int n, int n2) {
        this.insert(n2, n);
    }

    public boolean isBitSet(short s) {
        return (this.items[s >> 5] & 1 << (s & 0x1F)) != 0;
    }

    public int peek() {
        if (this.f1 > 0) {
            return this.items[this.f1 - 1];
        }
        return Integer.MIN_VALUE;
    }

    public int pop() {
        int n = Integer.MIN_VALUE;
        if (this.f1 > 0) {
            n = this.items[--this.f1];
        }
        return n;
    }

    public void push(int n) {
        this.add(n);
    }

    public void qsort() {
        this.m1(0, this.f1 - 1);
    }

    private void m1(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n < n2) {
            int n5 = this.items[n + n2 >> 1];
            while (true) {
                if (this.items[n3] < n5) {
                    ++n3;
                    continue;
                }
                while (this.items[n4] > n5) {
                    --n4;
                }
                if (n3 <= n4) {
                    int n6 = this.items[n3];
                    this.items[n3++] = this.items[n4];
                    this.items[n4--] = n6;
                }
                if (n3 > n4) break;
            }
            this.m1(n, n4);
            this.m1(n3, n2);
        }
    }

    void removeAllElements() {
        this.clear();
    }

    public void removeElement(int n) {
        this.del(n);
    }

    public void removeElementAt(int n) {
        this.del(n);
    }

    public void setBit(short s, boolean bl) {
        if (bl) {
            int n = s >> 5;
            this.items[n] = this.items[n] | 1 << (s & 0x1F);
            return;
        }
        int n = s >> 5;
        this.items[n] = this.items[n] & ~(1 << (s & 0x1F));
    }

    public void setElementAt(int n, int n2) {
        this.items[n2] = n;
    }

    public int size() {
        return this.f1;
    }

    public void writeTo(DataStream dataStream) {
        dataStream.writeShort(this.f1);
        int n = 0;
        while (n < this.f1) {
            dataStream.writeInt(this.items[n]);
            ++n;
        }
    }
}

