/*
 * Decompiled with CFR 0.152.
 */
public class Entry
implements Comparable {
    private static char SEPARATOR = (char)47;
    protected int entryId;
    protected String title;
    protected int category;
    protected byte[] encrypted;
    protected byte[] iv;
    protected int attribute;
    protected int uniqueId;
    protected int recordLength;
    private Crypto crypto;

    public Entry(int n, String string, int n2, byte[] byArray, Crypto crypto, int n3, int n4, int n5, byte[] byArray2) {
        this.entryId = n;
        this.title = string;
        this.category = n2;
        this.encrypted = byArray;
        this.crypto = crypto;
        this.attribute = n3;
        this.uniqueId = n4;
        this.recordLength = n5;
        this.iv = byArray2;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public void setTitleSeparator(char c) {
        SEPARATOR = c;
    }

    public int getEntryId() {
        return this.entryId;
    }

    public String getTitle() {
        return this.title;
    }

    public int getCategory() {
        return this.category;
    }

    public String getAccount() {
        String string = (String)this.crypto.decrypt(this.encrypted, "account", this.iv);
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getPassword() {
        String string = (String)this.crypto.decrypt(this.encrypted, "password", this.iv);
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getNotes() {
        String string = (String)this.crypto.decrypt(this.encrypted, "notes", this.iv);
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getDate() {
        int n;
        int n2;
        int n3;
        byte[] byArray = (byte[])this.crypto.decrypt(this.encrypted, "datetype", this.iv);
        try {
            n3 = ((byArray[0] & 0xFE) >> 1) + 1904;
            n2 = ((byArray[0] & 1) << 3) + ((byArray[1] & 0xE0) >> 5);
            n = byArray[1] & 0x1F;
        }
        catch (Exception exception) {
            return "11.11.2004";
        }
        return n + "." + n2 + "." + n3;
    }

    public byte[] getAll() {
        byte[] byArray = (byte[])this.crypto.decrypt(this.encrypted, "", this.iv);
        return byArray;
    }

    public String getInfo() {
        return "EntryId: " + this.entryId + " = " + this.title + " + " + this.getAccount() + " + " + this.getPassword() + " (" + this.recordLength + ", " + this.getDate() + ", " + this.getCategory() + ")";
    }

    public String toString() {
        int n = this.title.lastIndexOf(SEPARATOR);
        if (n != -1) {
            return this.title.substring(n + 1, this.title.length());
        }
        return this.title;
    }

    public int compareTo(Object object) {
        return this.title.toLowerCase().compareTo(((Entry)object).getTitle().toLowerCase());
    }
}

