/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Vector;

public class KeePass2KeyRing {
    private static boolean DEBUG = false;
    private static int MAX_CATEGORIES = 16;
    private static int MAX_CATEGORY_LENGTH = 16;
    private static String BACKUP = "Backup";
    private static String UNFILED = "Unfiled";
    private static String DATABASE = "Database";
    private static String UUID = "UUID:";
    private static String GRPN = "GRPN:";
    private static String TITLE = "S: Title =";
    private static String USER_NAME = "S: UserName =";
    private static String PASSWORD = "S: Password =";
    private static String NOTES = "S: Notes =";
    private static String GRPU = "GRPU:";
    private static String URL = "S: URL =";
    private Model model = new Model();
    private Vector categories = new Vector();

    public KeePass2KeyRing() {
        this.categories.add(UNFILED);
    }

    private void trace(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    private boolean readPasswords(BufferedReader bufferedReader) {
        try {
            CurrentEntry currentEntry = null;
            while (true) {
                String string;
                if ((string = bufferedReader.readLine()) == null) {
                    if (null != currentEntry) {
                        this.trace("Adding final entry with: " + currentEntry.title + "," + currentEntry.category + "," + currentEntry.userName + "," + currentEntry.password + "," + currentEntry.getNotesData());
                        this.addEntry(currentEntry.title, currentEntry.category, currentEntry.userName, currentEntry.password, currentEntry.getNotesData());
                    }
                    break;
                }
                if (string.startsWith(UUID)) {
                    if (null != currentEntry && !BACKUP.equals(currentEntry.categoryName)) {
                        this.trace("Adding new entry with: " + currentEntry.title + "," + currentEntry.category + "," + currentEntry.userName + "," + currentEntry.password + "," + currentEntry.getNotesData());
                        this.addEntry(currentEntry.title, currentEntry.category, currentEntry.userName, currentEntry.password, currentEntry.getNotesData());
                    }
                    currentEntry = new CurrentEntry();
                    continue;
                }
                if (string.startsWith(GRPN)) {
                    currentEntry.inComment = false;
                    currentEntry.categoryName = this.extractData(string, GRPN);
                    if (currentEntry.categoryName.length() > MAX_CATEGORY_LENGTH) {
                        currentEntry.categoryName = currentEntry.categoryName.substring(0, MAX_CATEGORY_LENGTH);
                    }
                    if (BACKUP.equals(currentEntry.categoryName)) {
                        this.trace("An entry in the Backup group is being ignored");
                        continue;
                    }
                    if (DATABASE.equals(currentEntry.categoryName)) {
                        this.trace("An entry from the Database group is being placed into Unfiled");
                        currentEntry.categoryName = UNFILED;
                    }
                    if (!this.categories.contains(currentEntry.categoryName)) {
                        if (this.categories.size() < MAX_CATEGORIES) {
                            this.categories.add(currentEntry.categoryName);
                        } else {
                            this.trace("More than 16 categories are in use, an entry is being placed into Unfiled");
                            currentEntry.categoryName = UNFILED;
                        }
                        currentEntry.category = this.categories.indexOf(currentEntry.categoryName);
                        this.trace("Added category: " + currentEntry.categoryName + " at #" + currentEntry.category);
                        continue;
                    }
                    currentEntry.category = this.categories.indexOf(currentEntry.categoryName);
                    this.trace("Using existing category: " + currentEntry.categoryName + " at #" + currentEntry.category);
                    continue;
                }
                if (string.startsWith(TITLE)) {
                    currentEntry.inComment = false;
                    currentEntry.title = this.extractData(string, TITLE);
                    this.trace("Added title: " + currentEntry.title);
                    continue;
                }
                if (string.startsWith(USER_NAME)) {
                    currentEntry.inComment = false;
                    currentEntry.userName = this.extractData(string, USER_NAME);
                    this.trace("Added user name: " + currentEntry.userName);
                    continue;
                }
                if (string.startsWith(PASSWORD)) {
                    currentEntry.inComment = false;
                    currentEntry.password = this.extractData(string, PASSWORD);
                    this.trace("Added password: " + currentEntry.password);
                    continue;
                }
                if (string.startsWith(NOTES)) {
                    currentEntry.notes = this.extractData(string, NOTES);
                    this.trace("Starting note with: " + currentEntry.notes);
                    currentEntry.inComment = true;
                    continue;
                }
                if (string.startsWith(GRPU)) {
                    currentEntry.inComment = false;
                    continue;
                }
                if (string.startsWith(URL)) {
                    currentEntry.inComment = false;
                    currentEntry.url = this.extractData(string, URL);
                    this.trace("Added url: " + currentEntry.url);
                    continue;
                }
                if (null == currentEntry || !currentEntry.inComment) continue;
                currentEntry.notes = currentEntry.notes + "\n" + string;
                this.trace("Continue note with: " + string);
            }
        }
        catch (Exception exception) {
            this.trace("Exception: " + exception.toString());
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private String extractData(String string, String string2) {
        if (!string.startsWith(string2)) {
            throw new RuntimeException("Data does not begin with the expected key");
        }
        if (string.length() <= string2.length()) {
            return "";
        }
        return string.substring(string2.length() + 1);
    }

    private void addEntry(String string, int n, String string2, String string3, String string4) throws Exception {
        byte[] byArray = null;
        int n2 = this.model.getEntriesSize() + 1;
        int n3 = this.model.getNewUniqueId();
        byte[] byArray2 = Model.toRecordFormat4(string2 + "\u0000" + string3 + "\u0000" + string4 + "\u0000");
        try {
            byArray = this.model.crypto.encrypt(byArray2);
        }
        catch (Exception exception) {
            System.err.println("Error encrypting entry.");
            throw exception;
        }
        int n4 = string.length() + byArray.length - 16 + 1;
        Entry entry = new Entry(n2, string, n, Model.sliceBytes(byArray, 16, byArray.length - 16), this.model.crypto, n | 0x40, n3, n4, null);
        this.model.addEntry(entry);
    }

    public static void main(String[] stringArray) {
        int n;
        Object object;
        Object object2;
        boolean bl = false;
        BufferedReader bufferedReader = null;
        if (stringArray.length < 2 || stringArray.length > 3) {
            KeePass2KeyRing.displayUsage();
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = null;
        if (stringArray.length == 3) {
            string3 = stringArray[2];
        }
        if ("-stdin".equals(string)) {
            if (null == string3) {
                KeePass2KeyRing.displayUsage();
            }
            bl = true;
            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        } else if (string3 == null) {
            object2 = new BufferedReader(new InputStreamReader(System.in));
            try {
                System.out.print("Enter your KeyRing password: ");
                string3 = ((BufferedReader)object2).readLine();
            }
            catch (Exception exception) {
                System.err.println("You need to enter a password!");
                System.exit(1);
            }
        }
        object2 = new KeePass2KeyRing();
        ((KeePass2KeyRing)object2).model = new Model();
        try {
            ((KeePass2KeyRing)object2).model.loadData(string2);
            object = new char[string3.length()];
            string3.getChars(0, string3.length(), (char[])object, 0);
            ((KeePass2KeyRing)object2).model.crypto.setPassword((char[])object);
        }
        catch (Exception exception) {
            System.err.println("Error generating database:");
            exception.printStackTrace();
            System.exit(1);
        }
        object = ((KeePass2KeyRing)object2).model.getEntries();
        Object[] objectArray = ((Vector)object).toArray();
        for (n = 0; n < objectArray.length; ++n) {
            ((KeePass2KeyRing)object2).model.removeEntry(objectArray[n]);
        }
        if (!bl) {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(string);
            }
            catch (Exception exception) {
                System.err.println("Error opening password file: " + exception.getMessage());
                System.exit(1);
            }
            bufferedReader = new BufferedReader(fileReader);
        }
        if (!super.readPasswords(bufferedReader)) {
            System.err.println("Error processing password file");
            System.exit(1);
        }
        super.trace("Categories are:");
        for (n = 0; n < ((KeePass2KeyRing)object2).categories.size(); ++n) {
            super.trace((String)((KeePass2KeyRing)object2).categories.elementAt(n) + " at #" + n);
        }
        ((KeePass2KeyRing)object2).model.setCategories(((KeePass2KeyRing)object2).categories);
        try {
            ((KeePass2KeyRing)object2).model.saveData(string2);
        }
        catch (Exception exception) {
            System.err.println("Error writing database:");
            exception.printStackTrace();
            System.exit(4);
        }
        System.exit(0);
    }

    private static void displayUsage() {
        System.err.println("\nUsage: java KeePass2KeyRing (<source>|<-stdin>) <target> [password]\n");
        System.err.println("  where: <source> is the path/name of the input file created by a");
        System.err.println("                KPScript.exe -c:ListEntries command.\n");
        System.err.println("    and: <-stdin> means that the input file should be read from the standard");
        System.err.println("                input as via a pipe. Password is REQUIRED here.\n");
        System.err.println("    and: <target> is the path/name of the output file which typically is");
        System.err.println("                named Keys-Gtkr.PDB. This file MUST already exist and be");
        System.err.println("                a valid Keyring database file.\n");
        System.err.println("    and: [password] is that used to decrypt the output file. This argument");
        System.err.println("                is REQUIRED if -stdin is specified.\n");
        System.exit(1);
    }

    class CurrentEntry {
        int category = 0;
        boolean inComment = false;
        String title = "";
        String userName = "";
        String password = "";
        String notes = "";
        String categoryName = "";
        String url = "";

        CurrentEntry() {
        }

        String getNotesData() {
            String string = this.notes == null || "".equals(this.notes) ? "" : this.notes;
            string = string + (this.url == null || "".equals(this.url) ? "" : "\n" + this.url);
            return string;
        }
    }
}

