INCLUDE form.ppc
INCLUDE edit.ppc
INCLUDE palmdb.ppc
INCLUDE screen.ppc
INCLUDE ScrollBar.ppc
INCLUDE Table.ppc
INCLUDE System.ppc
INCLUDE Panel.ppc
INCLUDE list.ppc
INCLUDE infrared.ppc

Function Application_Terminate
void Application_Terminate() {
	EventType	newEvent;
	MemSet(&newEvent, sizeof(EventType), 0);
   	newEvent.eType = appStopEvent;
   	EvtAddEventToQueue(&newEvent);
}

Function Application_ProcessMessages
Boolean Application_EventHandler(EventPtr event);
void Application_ProcessMessages(int ticks)
{
     EventType event;
     UInt32 until=TimGetTicks()+ticks;
     UInt16 error;
     do {
	     EvtGetEvent(&event, 3);
	     if(event.eType == appStopEvent) {
		     StopEvent=1;
		     break;
	     }
	     if (! SysHandleEvent(&event))
	         if (! MenuHandleEvent(0, &event, &error))
	             if (! Application_EventHandler(&event))
	                FrmDispatchEvent(&event);
     } while(TimGetTicks()<until);
}

Function Assign_Visible
void Assign_Visible(Int16 ID,FormPtr PARENTFORM,Int16 RVALUE) {
     if (RVALUE)
        FrmShowObject(PARENTFORM,FrmGetObjectIndex(PARENTFORM,ID));
     else
        FrmHideObject(PARENTFORM,FrmGetObjectIndex(PARENTFORM,ID));
}

function EncodeDate
UInt32 EncodeDate(Int16 d,Int16 m,Int16 y)
{
   DateType a;
   if (y==0) {
      * ((Int16 *) &a) = noTime;
      return DateToInt(a);
   }
   a.year=y-1904;
   a.month=m;
   a.day=d;
   return DateToInt(a);
}

Function DecodeDate
void DecodeDate(TablePtr THIS,Int16 row,Int16 col,Int16 *d,Int16 *m,Int16 *y)
{
   UInt16 val=TblGetItemInt(THIS,col,row);
   *y=(val >> 9)+1904;
   *m=(val >> 5) & 15;
   *d=(val & 31);
}

Function Screen_DrawBitmap
void Screen_DrawBitmap(Int16 bmpID,Int16 x,Int16 y,Int8 PaintMode)
{
   void* h;
   BitmapPtr p;
   h = DmGet1Resource('Tbmp', bmpID);
   if (h != NULL)
   {
	  Int8 old;  
      p = (BitmapPtr ) MemHandleLock(h);
      if (PaintMode!=-1)
          old=WinSetDrawMode(PaintMode);
      WinPaintBitmap(p,x,y);
      if (PaintMode!=-1) WinSetDrawMode(old);
      MemHandleUnlock(h);
      DmReleaseResource(h);
   }
}


//******************************************************************************************
// Class definitions
//******************************************************************************************


class TApplication=id {
	void Terminate() $$##$$Application_Terminate()
	void ProcessMessages() $$##$$Application_ProcessMessages(0)
	void NoBlockDelay(PAR1) $$##$$Application_ProcessMessages(PAR1)
}

class TButton=ControlPtr {
      Char* Caption() return CtlGetLabel(THIS)
      Int16 Width() return THIS_width;
      Int16 Top() return THIS_top;
      Int16 Left() return THIS_left;
      Int16 Height() return THIS_height;
      Char Enabled() return CtlEnabled(THIS)
      Char Checked() return CtlGetValue(THIS)
      void MoveTo(PAR1,PAR2) FrmSetObjectPosition(PARENTFORM,FrmGetObjectIndex(PARENTFORM,_THIS),PAR1,PAR2);
lvalues:
      Caption CtlSetLabel(THIS,RVALUE);
      Checked CtlSetValue(THIS,RVALUE);
      Enabled CtlSetEnabled(THIS,RVALUE);
      Visible $$##$$Assign_Visible(_THIS,PARENTFORM,RVALUE);
}

class TMenu=id {
}

class TGraffitiIndicator=id {
      void MoveTo(PAR1,PAR2) FrmSetObjectPosition(PARENTFORM,FrmGetObjectIndex(PARENTFORM,THIS),PAR1,PAR2);
lvalues:
      Visible $$##$$Assign_Visible(_THIS,PARENTFORM,RVALUE);
}

class TBitmap=id {
      Int16 Width() return THIS_width;
      Int16 Top() return THIS_top;
      Int16 Left() return THIS_left;
      Int16 Height() return THIS_height;
      void MoveTo(PAR1,PAR2) FrmSetObjectPosition(PARENTFORM,FrmGetObjectIndex(PARENTFORM,THIS),PAR1,PAR2);
      void Draw(PAR1,PAR2) $$##$$Screen_DrawBitmap(THIS,PAR1,PAR2,-1);
      void Draw(PAR1,PAR2,PAR3) $$##$$Screen_DrawBitmap(THIS,PAR1,PAR2,PAR3);
      void Erase() $$##$$Screen_EraseRect(THIS_left,THIS_top,THIS_left+THIS_width,THIS_top+THIS_height)
lvalues:
      Visible $$##$$Assign_Visible(THIS,PARENTFORM,RVALUE);
}

class TGadget=id {
      void* Data() return ((THIS_PrivData *)FrmGetGadgetData(PARENTFORM,FrmGetObjectIndex(PARENTFORM,THIS)))
      void Erase() $$##$$Screen_EraseRect(THIS_left,THIS_top,THIS_left+THIS_width,THIS_top+THIS_height)
      void Paint() THIS_OnPaint(THIS,THIS_left,THIS_top,THIS_width,THIS_height);
      void MoveTo(PAR1,PAR2) FrmSetObjectPosition(PARENTFORM,FrmGetObjectIndex(PARENTFORM,THIS),PAR1,PAR2);
lvalues:
      Visible $$##$$Assign_Visible(_THIS,PARENTFORM,RVALUE);
}

class TAlert=id {
      Int16 Show() return FrmAlert(THIS);
      Int16 Show(PAR1) return FrmCustomAlert(THIS,PAR1," "," ");
      Int16 Show(PAR1,PAR2) return FrmCustomAlert(THIS,PAR1,PAR2," ");
      Int16 Show(PAR1,PAR2,PAR3) return FrmCustomAlert(THIS,PAR1,PAR2,PAR3);
}

class TCheckBox=ControlPtr {
      Int16 Width() return THIS_width;
      Int16 Top() return THIS_top;
      Int16 Left() return THIS_left;
      Int16 Height() return THIS_height;
      void MoveTo(PAR1,PAR2) FrmSetObjectPosition(PARENTFORM,FrmGetObjectIndex(PARENTFORM,_THIS),PAR1,PAR2);
      Char Enabled() return CtlEnabled(THIS);
      Char Checked() return CtlGetValue(THIS);
lvalues:
      Checked CtlSetValue(THIS,RVALUE);
      Enabled CtlSetEnabled(THIS,RVALUE);
      Visible $$##$$Assign_Visible(_THIS,PARENTFORM,RVALUE);
}

class TFont=id {
      void Init() FntDefineFont(THIS_FontId, MemHandleLock(DmGetResource('NFNT', THIS)));
      void Release() MemHandleUnlock(DmGetResource('NFNT', THIS));
}

class TLabel=id {
      Int16 Top() return THIS_top;
      Int16 Left() return THIS_left;
      void MoveTo(PAR1,PAR2) FrmSetObjectPosition(PARENTFORM,FrmGetObjectIndex(PARENTFORM,THIS),PAR1,PAR2);
lvalues:
      Visible $$##$$Assign_Visible(THIS,PARENTFORM,RVALUE);
      Caption $$##$$Change_Caption(THIS,&PARENTFORM,RVALUE);
}


Function Change_Caption
void Change_Caption(int Id,FormPtr *form,char *newCapt)
{
	int idx;
	RectangleType bounds;
	idx=FrmGetObjectIndex(*form,Id);
	FrmGetObjectBounds(*form,idx,&bounds);
	FrmRemoveObject(form,idx);
	FrmNewLabel(form,Id,newCapt,bounds.topLeft.x,bounds.topLeft.y,FntGetFont());
    FrmShowObject(*form,FrmGetObjectIndex(*form,Id));
}

class TMemBlock=void* {
    ULong Size() return MemHandleSize(THIS);
    void New(PAR1) THIS=MemHandleNew(PAR1);
    void* Get() return MemHandleLock(THIS);
    void Release() MemHandleUnlock(THIS);
    void Free() MemHandleFree(THIS);
lvalues:
    Size MemHandleResize(THIS,RVALUE);
}


