/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.plaf.mac.MacInternalFrameTitlePane;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class MacInternalFrameUI
extends BasicInternalFrameUI {
    private MacInternalFrameTitlePane titlePane;
    private PropertyChangeListener contentPaneListener;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    protected static String IS_PALETTE = "JInternalFrame.isPalette";

    public MacInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected LayoutManager createLayoutManager() {
        return new MacInternalFrameLayout();
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new MacInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MacInternalFrameUI((JInternalFrame)jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.frame = (JInternalFrame)jComponent;
        this.contentPaneListener = new ContentPaneListener();
        jComponent.addPropertyChangeListener(this.contentPaneListener);
        super.installUI(jComponent);
        Container container = this.frame.getContentPane();
        this.stripContentBorder(container);
        jComponent.setOpaque(false);
    }

    private void stripContentBorder(Object object) {
        JComponent jComponent;
        Border border;
        if (object instanceof JComponent && ((border = (jComponent = (JComponent)object).getBorder()) == null || border instanceof UIResource)) {
            jComponent.setBorder(handyEmptyBorder);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        JComponent jComponent2;
        jComponent.removePropertyChangeListener(this.contentPaneListener);
        Container container = ((JInternalFrame)jComponent).getContentPane();
        if (container instanceof JComponent && (jComponent2 = (JComponent)container).getBorder() == handyEmptyBorder) {
            jComponent2.setBorder(null);
        }
        super.uninstallUI(jComponent);
    }

    class ContentPaneListener
    implements PropertyChangeListener {
        ContentPaneListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("contentPane")) {
                MacInternalFrameUI.this.stripContentBorder(propertyChangeEvent.getNewValue());
            }
        }
    }

    class MacInternalFrameLayout
    extends BasicInternalFrameUI.InternalFrameLayout {
        MacInternalFrameLayout() {
        }

        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            JComponent jComponent = MacInternalFrameUI.this.getNorthPane();
            jComponent.setBounds(jComponent.getX() - 1, jComponent.getY(), jComponent.getWidth() + 2, jComponent.getHeight());
        }
    }
}

