/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicTableHeaderUI
extends TableHeaderUI {
    protected JTableHeader header;
    protected CellRendererPane rendererPane;
    protected MouseInputListener mouseInputListener;

    private Dimension createHeaderSize(long l) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if ((l += (long)(tableColumnModel.getColumnMargin() * tableColumnModel.getColumnCount())) > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, this.getHeaderHeight());
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableHeaderUI();
    }

    private int getHeaderHeight() {
        int n = 0;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n2 = 0;
        while (n2 < tableColumnModel.getColumnCount()) {
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n2);
            n = Math.max(n, component.getPreferredSize().height);
            ++n2;
        }
        return n;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getMaxWidth();
        }
        return this.createHeaderSize(l);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createHeaderSize(l);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createHeaderSize(l);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
    }

    public void installUI(JComponent jComponent) {
        this.header = (JTableHeader)jComponent;
        this.rendererPane = new CellRendererPane();
        this.header.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        TableColumn tableColumn;
        Rectangle rectangle = graphics.getClipBounds();
        if (this.header.getColumnModel() == null) {
            return;
        }
        int n = 0;
        boolean bl = false;
        int n2 = -1;
        Rectangle rectangle2 = null;
        Dimension dimension = this.header.getSize();
        Rectangle rectangle3 = new Rectangle(0, 0, dimension.width, dimension.height);
        Enumeration enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            tableColumn = (TableColumn)enumeration.nextElement();
            int n3 = this.header.getColumnModel().getColumnMargin();
            rectangle3.width = tableColumn.getWidth() + n3;
            if (rectangle3.intersects(rectangle)) {
                bl = true;
                if (tableColumn != this.header.getDraggedColumn()) {
                    this.paintCell(graphics, rectangle3, n);
                } else {
                    graphics.setColor(this.header.getParent().getBackground());
                    graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    rectangle2 = new Rectangle(rectangle3);
                    n2 = n;
                }
            } else if (bl) break;
            rectangle3.x += rectangle3.width;
            ++n;
        }
        tableColumn = this.header.getDraggedColumn();
        if (tableColumn != null && rectangle2 != null) {
            rectangle2.x += this.header.getDraggedDistance();
            this.paintCell(graphics, rectangle2, n2);
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.header.remove(this.rendererPane);
        this.rendererPane = null;
        this.header = null;
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private boolean phantomMousePressed = false;
        private int lastEffectiveMouseX;

        private int getResizingColumn(Point point) {
            int n = 0;
            Rectangle rectangle = new Rectangle(-3, 0, 6, BasicTableHeaderUI.this.header.getSize().height);
            int n2 = BasicTableHeaderUI.this.header.getColumnModel().getColumnMargin();
            Enumeration enumeration = BasicTableHeaderUI.this.header.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = (TableColumn)enumeration.nextElement();
                rectangle.x += tableColumn.getWidth() + n2;
                if (rectangle.x > point.x) break;
                if (rectangle.contains(point)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = n - this.lastEffectiveMouseX;
            if (n2 == 0) {
                return;
            }
            TableColumn tableColumn = BasicTableHeaderUI.this.header.getResizingColumn();
            TableColumn tableColumn2 = BasicTableHeaderUI.this.header.getDraggedColumn();
            if (tableColumn != null) {
                int n3 = tableColumn.getWidth();
                int n4 = n3 + n2;
                tableColumn.setWidth(n4);
                int n5 = this.viewIndexForColumn(tableColumn);
                BasicTableHeaderUI.this.header.getTable().sizeColumnsToFit(n5);
                int n6 = tableColumn.getWidth() - n3;
                this.lastEffectiveMouseX += n6;
                BasicTableHeaderUI.this.header.revalidate();
                BasicTableHeaderUI.this.header.repaint();
                if (BasicTableHeaderUI.this.header.getUpdateTableInRealTime()) {
                    JTable jTable = BasicTableHeaderUI.this.header.getTable();
                    jTable.revalidate();
                    jTable.repaint();
                }
            } else if (tableColumn2 != null) {
                this.move(mouseEvent, n2);
                this.lastEffectiveMouseX = n;
            } else {
                this.lastEffectiveMouseX = n;
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.getResizingColumn(mouseEvent.getPoint()) != -1) {
                Cursor cursor = Cursor.getPredefinedCursor(11);
                if (BasicTableHeaderUI.this.header.getCursor() != cursor) {
                    BasicTableHeaderUI.this.header.setCursor(cursor);
                }
            } else {
                Cursor cursor = Cursor.getPredefinedCursor(0);
                if (BasicTableHeaderUI.this.header.getCursor() != cursor) {
                    BasicTableHeaderUI.this.header.setCursor(cursor);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.phantomMousePressed = true;
            BasicTableHeaderUI.this.header.setDraggedColumn(null);
            BasicTableHeaderUI.this.header.setResizingColumn(null);
            BasicTableHeaderUI.this.header.setDraggedDistance(0);
            Point point = mouseEvent.getPoint();
            this.lastEffectiveMouseX = point.x;
            TableColumnModel tableColumnModel = BasicTableHeaderUI.this.header.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(point.x);
            if (n != -1) {
                int n2 = this.getResizingColumn(point);
                if (BasicTableHeaderUI.this.header.getResizingAllowed() && n2 != -1) {
                    TableColumn tableColumn = tableColumnModel.getColumn(n2);
                    BasicTableHeaderUI.this.header.setResizingColumn(tableColumn);
                } else if (BasicTableHeaderUI.this.header.getReorderingAllowed()) {
                    TableColumn tableColumn = tableColumnModel.getColumn(n);
                    BasicTableHeaderUI.this.header.setDraggedColumn(tableColumn);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.phantomMousePressed = false;
            BasicTableHeaderUI.this.header.setResizingColumn(null);
            BasicTableHeaderUI.this.header.setDraggedColumn(null);
            BasicTableHeaderUI.this.header.setDraggedDistance(0);
            BasicTableHeaderUI.this.header.repaint();
            JTable jTable = BasicTableHeaderUI.this.header.getTable();
            if (jTable != null) {
                jTable.repaint();
            }
        }

        private void move(MouseEvent mouseEvent, int n) {
            JTable jTable;
            int n2;
            TableColumnModel tableColumnModel = BasicTableHeaderUI.this.header.getColumnModel();
            int n3 = tableColumnModel.getColumnCount() - 1;
            TableColumn tableColumn = BasicTableHeaderUI.this.header.getDraggedColumn();
            int n4 = BasicTableHeaderUI.this.header.getDraggedDistance() + n;
            int n5 = this.viewIndexForColumn(tableColumn);
            if (n4 < 0 && n5 != 0) {
                n2 = tableColumnModel.getColumnMargin() + tableColumnModel.getColumn(n5 - 1).getWidth();
                if (-n4 > n2 / 2) {
                    tableColumnModel.moveColumn(n5, n5 - 1);
                    n4 = n2 + n4;
                    --n5;
                }
            } else if (n4 > 0 && n5 != n3 && n4 > (n2 = tableColumnModel.getColumnMargin() + tableColumnModel.getColumn(n5 + 1).getWidth()) / 2) {
                tableColumnModel.moveColumn(n5, n5 + 1);
                n4 = -(n2 - n4);
                ++n5;
            }
            Rectangle rectangle = BasicTableHeaderUI.this.header.getHeaderRect(n5);
            rectangle.x += BasicTableHeaderUI.this.header.getDraggedDistance();
            Rectangle rectangle2 = BasicTableHeaderUI.this.header.getHeaderRect(n5);
            rectangle2.x += n4;
            rectangle = rectangle.union(rectangle2);
            BasicTableHeaderUI.this.header.repaint(rectangle.x, 0, rectangle.width, rectangle.height);
            if (BasicTableHeaderUI.this.header.getUpdateTableInRealTime() && (jTable = BasicTableHeaderUI.this.header.getTable()) != null) {
                jTable.repaint(rectangle.x, 0, rectangle.width, (jTable.getRowHeight() + jTable.getIntercellSpacing().height) * jTable.getRowCount());
            }
            BasicTableHeaderUI.this.header.setDraggedColumn(tableColumnModel.getColumn(n5));
            BasicTableHeaderUI.this.header.setDraggedDistance(n4);
        }

        private int viewIndexForColumn(TableColumn tableColumn) {
            TableColumnModel tableColumnModel = BasicTableHeaderUI.this.header.getColumnModel();
            int n = 0;
            while (n < tableColumnModel.getColumnCount()) {
                if (tableColumnModel.getColumn(n) == tableColumn) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
    }
}

