/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import pw.palmpatch.PreferencesChangedListener;
import pw.palmpatch.util.Log;
import pw.palmpatch.util.WarningMessage;

public class Preferences
extends Properties {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String startupActionsEnabled = "startupActionsEnabled";
    public static final String loadFileOnStartup = "loadFileOnStartup";
    public static final String scanDirectoryOnStartup = "scanDirectoryOnStartup";
    public static final String fileToLoadOnStartup = "fileToLoadOnStartup";
    public static final String directoryToScanOnStartup = "directoryToScanOnStartup";
    public static final String lastDirectoryOpenedToLoadTargetList = "lastDirectoryOpenedToLoadTargetList";
    public static final String lastDirectoryOpenedToSaveTargetList = "lastDirectoryOpenedToSaveTargetList";
    public static final String lastDirectoryOpenedToChooseTarget = "lastDirectoryOpenedToChooseTarget";
    public static final String lastDirectoryOpenedToLoadTarget = "lastDirectoryOpenedToLoadTarget";
    public static final String lastDirectoryOpenedContainingOriginalFiles = "lastDirectoryOpenedContainingOriginalFiles";
    public static final String lastDirectoryOpenedContainingCrackedFiles = "lastDirectoryOpenedContainingCrackedFiles";
    public static final String lastDirectoryOpenedToDetachAttachment = "lastDirectoryOpenedToDetachAttachment";
    public static final String lastDirectoryOpenedToAddAttachment = "lastDirectoryOpenedToAddAttachment";
    public static final String lastDirectoryOpenedToExportTargetInfos = "lastDirectoryOpenedToExportTargetInfos";
    public static final String lastDirectoryOpenedToImportTargetInfos = "lastDirectoryOpenedToImportTargetInfos";
    public static final String lookAndFeel = "lookAndFeel";
    public static final String confirmExit = "confirmExit";
    public static final String confirmDelete = "confirmDelete";
    public static final String useBuiltInDTD = "useBuiltInDTD";
    public static final String sortOnImport = "sortOnImport";
    public static final String checkForDuplicates = "checkForDuplicates";
    public static final String sortOnImportMethod = "sortOnImportMethod";
    public static final String sortByNameAscending = "sortByNameAscending";
    public static final String sortByNameDescending = "sortByNameDescending";
    public static final String sortByCreditsAscending = "sortByCreditsAscending";
    public static final String sortByCreditsDescending = "sortByCreditsDescending";
    public static final String encodingUsedForSave = "encodingUsedForSave";
    public static final String encodingUsedForExport = "encodingUsedForExport";
    public static final String encodingUTF8 = "UTF-8";
    public static final String encodingASCII = "ASCII";
    public static final String defaultCredits = "defaultCredits";
    public static final String font = "font";
    public static final String showDetachWarning = "showDetachWarning";
    public static final String trace = "trace";
    public static final String traceLevel = "traceLevel";
    public static final String traceDestination = "traceDestination";
    public static final String traceDestinationFile = "destinationFile";
    public static final String traceDestinationConsole = "destinationFile";
    public static final String SAXParserFactoryImpl = "SAXParserFactoryImpl";
    public static final String palmpassDownloadURL = "palmpassDownloadURL";
    public static final String directoryToDownloadTo = "directoryToDownloadTo";
    public static final String askToOverwriteFileToDownload = "askToOverwriteFileToDownload";
    public static final String onlyDownloadFileIfNewerThanLocalFile = "onlyDownloadFileIfNewerThanLocalFile";
    public static final String loadFileAfterDownload = "loadFileAfterDownload";
    protected List listeners = new ArrayList();
    protected File file;

    public Preferences(String string) {
        File file = new File(System.getProperty("user.home"));
        File file2 = new File(file, ".pwcpp");
        if (!file2.exists()) {
            file2.mkdir();
        }
        this.file = new File(file2, string);
        this.initializeDefaults();
    }

    public void addPreferencesChangedListener(PreferencesChangedListener preferencesChangedListener) {
        this.listeners.add((Object)preferencesChangedListener);
    }

    protected void firePreferencesChanged(String string) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((PreferencesChangedListener)iterator.next()).preferencesChanged(string, this);
        }
    }

    public boolean getBool(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return false;
        }
        return string2.equals(TRUE);
    }

    public Dimension getDimension(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return new Dimension(0, 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(string3);
            n2 = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {}
        return new Dimension(n, n2);
    }

    public Font getFont(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return new Font("Default", 0, 12);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        int n = 0;
        int n2 = 12;
        try {
            n = Integer.parseInt(string4);
            n2 = Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {}
        return new Font(string3, n, n2);
    }

    public int getInt(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return 0;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public int getInteger(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return 0;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public Point getPoint(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return new Point(0, 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(string3);
            n2 = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {}
        return new Point(n, n2);
    }

    public Rectangle getRectangle(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return new Rectangle();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            n = Integer.parseInt(string3);
            n2 = Integer.parseInt(string4);
            n3 = Integer.parseInt(string5);
            n4 = Integer.parseInt(string6);
        }
        catch (NumberFormatException numberFormatException) {}
        return new Rectangle(n, n2, n3, n4);
    }

    public String getString(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public String[] getStringArray(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = new String(stringTokenizer.nextToken());
            ++n;
        }
        return stringArray;
    }

    protected void initializeDefaults() {
        this.setValue(directoryToScanOnStartup, "");
        this.setValue(fileToLoadOnStartup, "");
        this.setValue(loadFileOnStartup, true);
        this.setValue(scanDirectoryOnStartup, false);
        this.setValue(startupActionsEnabled, false);
        this.setValue(lastDirectoryOpenedToLoadTargetList, "");
        this.setValue(lastDirectoryOpenedToSaveTargetList, "");
        this.setValue(lastDirectoryOpenedContainingOriginalFiles, "");
        this.setValue(lastDirectoryOpenedContainingCrackedFiles, "");
        this.setValue(lastDirectoryOpenedToLoadTarget, "");
        this.setValue(lastDirectoryOpenedToChooseTarget, "");
        this.setValue(lastDirectoryOpenedToDetachAttachment, "");
        this.setValue(lastDirectoryOpenedToAddAttachment, "");
        this.setValue(lastDirectoryOpenedToExportTargetInfos, "");
        this.setValue(lastDirectoryOpenedToImportTargetInfos, "");
        this.setValue(lookAndFeel, "");
        this.setValue(confirmExit, true);
        this.setValue(confirmDelete, true);
        this.setValue(useBuiltInDTD, true);
        this.setValue(sortOnImport, false);
        this.setValue(sortOnImportMethod, sortByNameAscending);
        this.setValue(checkForDuplicates, false);
        this.setValue(encodingUsedForExport, encodingASCII);
        this.setValue(encodingUsedForSave, encodingASCII);
        this.setValue(defaultCredits, "");
        this.setValue(font, "Default,0,11");
        this.setValue(showDetachWarning, true);
        this.setValue(trace, false);
        this.setValue(traceLevel, 0);
        this.setValue(traceDestination, "destinationFile");
        this.setValue(palmpassDownloadURL, "http://www.pilotwarez.com/filez/palmpass.zip");
        this.setValue(directoryToDownloadTo, System.getProperty("user.home"));
        this.setValue(askToOverwriteFileToDownload, true);
        this.setValue(onlyDownloadFileIfNewerThanLocalFile, true);
        this.setValue(loadFileAfterDownload, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load() {
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
                this.load(bufferedInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.singleton().logNewMessage(new WarningMessage("The preferences file " + this.file.getAbsolutePath() + " could not be found!"));
            }
            catch (IOException iOException) {
                Log.singleton().logNewMessage(new WarningMessage("There was a problem reading the preferences file " + this.file.getAbsolutePath()));
            }
            Object var3_2 = null;
            if (bufferedInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bufferedInputStream == null) throw throwable;
            try {
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Log.singleton().logNewMessage(new WarningMessage("There was a problem closing the preferences file " + this.file.getAbsolutePath()));
            }
            throw throwable;
        }
        try {
            bufferedInputStream.close();
            return;
        }
        catch (IOException iOException) {
            Log.singleton().logNewMessage(new WarningMessage("There was a problem closing the preferences file " + this.file.getAbsolutePath()));
        }
    }

    public Object put(Object object, Object object2) {
        Object object3 = super.put(object, object2);
        this.firePreferencesChanged(null);
        return object3;
    }

    public void removePreferencesChangedListener(PreferencesChangedListener preferencesChangedListener) {
        this.listeners.remove((Object)preferencesChangedListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save() {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.file));
                this.save(bufferedOutputStream, null);
            }
            catch (IOException iOException) {
                Log.singleton().logNewMessage(new WarningMessage("There was a problem saving the preferences file " + this.file.getAbsolutePath()));
            }
            Object var3_2 = null;
            if (bufferedOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bufferedOutputStream == null) throw throwable;
            try {
                bufferedOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void setValue(String string, int n) {
        this.put(string, Integer.toString(n));
    }

    public void setValue(String string, Dimension dimension) {
        String string2 = String.valueOf(dimension.width) + " " + dimension.height;
        this.put(string, string2);
    }

    public void setValue(String string, Font font) {
        String string2 = String.valueOf(font.getName()) + "," + font.getStyle() + "," + font.getSize();
        this.put(string, string2);
    }

    public void setValue(String string, Point point) {
        String string2 = String.valueOf(point.x) + " " + point.y;
        this.put(string, string2);
    }

    public void setValue(String string, Rectangle rectangle) {
        String string2 = String.valueOf(rectangle.x) + " " + rectangle.y + " " + rectangle.width + " " + rectangle.height;
        this.put(string, string2);
    }

    public void setValue(String string, String string2) {
        this.put(string, string2);
    }

    public void setValue(String string, boolean bl) {
        this.put(string, !bl ? FALSE : TRUE);
    }

    public void setValue(String string, String[] stringArray) {
        String string2 = stringArray[0];
        int n = 1;
        while (n < stringArray.length) {
            string2 = String.valueOf(string2) + " " + stringArray[n];
            ++n;
        }
        this.put(string, string2);
    }
}

