/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.controller;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.List;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import pw.palmpatch.controller.PWAction;
import pw.palmpatch.controller.SubController;
import pw.palmpatch.ui.views.MessagesView;
import pw.palmpatch.util.ImageCache;

public class MessagesController
extends SubController {
    protected Action clearMessagesAction;
    protected Action copyToClipboardAction;

    public MessagesController() {
        this.initialize();
    }

    public List getActions() {
        ArrayList arrayList = new ArrayList();
        arrayList.add((Object)this.getClearMessagesAction());
        arrayList.add((Object)this.getCopyToClipboardAction());
        return arrayList;
    }

    protected Action getClearMessagesAction() {
        return this.clearMessagesAction;
    }

    protected Action getCopyToClipboardAction() {
        return this.copyToClipboardAction;
    }

    protected void initialize() {
        this.clearMessagesAction = new ClearMessagesAction();
        this.copyToClipboardAction = new CopyToClipboardAction();
    }

    protected void performClearMessagesAction() {
        ((MessagesView)this.getView()).clearLog();
    }

    protected void performCopyToClipboardAction() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(((MessagesView)this.getView()).getText());
        clipboard.setContents(stringSelection, null);
    }

    private class ClearMessagesAction
    extends PWAction {
        ClearMessagesAction() {
            super(3, "Messages");
            this.putValue("Name", "Clear Messages");
            this.putValue("ShortDescription", "Clear Messages");
            this.putValue("LongDescription", "Clear the displayed messages");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/clearMessages.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            MessagesController.this.performClearMessagesAction();
        }
    }

    private class CopyToClipboardAction
    extends PWAction {
        CopyToClipboardAction() {
            super(3, "Messages");
            this.putValue("Name", "Copy");
            this.putValue("ShortDescription", "Copy to Clipboard");
            this.putValue("LongDescription", "Copy to display messages to the system clipboard");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/copy.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            MessagesController.this.performCopyToClipboardAction();
        }
    }
}

