/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.controller;

import com.sun.java.util.collections.List;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import pw.palmpatch.PreferenceNode;
import pw.palmpatch.controller.PWAction;
import pw.palmpatch.controller.SubController;
import pw.palmpatch.models.PreferencesControllerModel;
import pw.palmpatch.ui.views.PreferenceNodeBasedPreferencesView;

public class PreferenceNodeBasedPreferencesController
extends SubController {
    protected void buildNodeClient(PreferenceNode preferenceNode) {
        if (preferenceNode.getClient() == null) {
            JComponent jComponent = preferenceNode.buildClient();
            preferenceNode.setClient(jComponent);
            preferenceNode.display(((PreferencesControllerModel)this.getModel()).getPreferences());
        }
    }

    public List getActions() {
        return null;
    }

    public void performApplyAction() {
        PreferenceNode preferenceNode = ((PreferenceNodeBasedPreferencesView)this.getView()).getSelectedPreferenceNode();
        preferenceNode.save(((PreferencesControllerModel)this.getModel()).getPreferences());
    }

    public void performApplyAllAction() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((PreferencesControllerModel)this.getModel()).getModelForPreferenceNodeTree().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            ((PreferenceNode)defaultMutableTreeNode.getUserObject()).save(((PreferencesControllerModel)this.getModel()).getPreferences());
        }
    }

    public void performCancelAction() {
    }

    public void performOkAction() {
        this.performApplyAllAction();
    }

    public void performResetAction() {
        PreferenceNode preferenceNode = ((PreferenceNodeBasedPreferencesView)this.getView()).getSelectedPreferenceNode();
        preferenceNode.display(((PreferencesControllerModel)this.getModel()).getPreferences());
    }

    public void preferenceNodeWasSelected(PreferenceNode preferenceNode) {
        this.buildNodeClient(preferenceNode);
        ((PreferenceNodeBasedPreferencesView)this.getView()).setPreferenceNodeClient(preferenceNode.getClient());
    }

    private class CancelAction
    extends PWAction {
        CancelAction() {
            super(3, "");
            this.putValue("Name", "Cancel");
            this.putValue("ShortDescription", "Cancel");
            this.putValue("LongDescription", "Cancel all settings made");
        }

        public void perform(ActionEvent actionEvent) {
            PreferenceNodeBasedPreferencesController.this.performCancelAction();
        }
    }

    private class ResetAction
    extends PWAction {
        ResetAction() {
            super(3, "");
            this.putValue("Name", "Reset");
            this.putValue("ShortDescription", "Reset");
            this.putValue("LongDescription", "Reset all settings made");
        }

        public void perform(ActionEvent actionEvent) {
            PreferenceNodeBasedPreferencesController.this.performResetAction();
        }
    }

    private class ApplyAction
    extends PWAction {
        ApplyAction() {
            super(3, "");
            this.putValue("Name", "Apply");
            this.putValue("ShortDescription", "Apply");
            this.putValue("LongDescription", "Apply settings made on the current node");
        }

        public void perform(ActionEvent actionEvent) {
            PreferenceNodeBasedPreferencesController.this.performApplyAction();
        }
    }

    private class ApplyAllAction
    extends PWAction {
        ApplyAllAction() {
            super(3, "");
            this.putValue("Name", "Apply all");
            this.putValue("ShortDescription", "Apply all");
            this.putValue("LongDescription", "Apply all settings made");
        }

        public void perform(ActionEvent actionEvent) {
            PreferenceNodeBasedPreferencesController.this.performApplyAllAction();
        }
    }

    private class OkAction
    extends PWAction {
        OkAction() {
            super(3, "");
            this.putValue("Name", "Ok");
            this.putValue("ShortDescription", "Ok");
            this.putValue("LongDescription", "Apply all settings made and close");
        }

        public void perform(ActionEvent actionEvent) {
            PreferenceNodeBasedPreferencesController.this.performOkAction();
        }
    }
}

