/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.controller;

import com.sun.java.util.collections.List;
import pw.palmpatch.controller.SubController;
import pw.palmpatch.events.ControllerEvent;
import pw.palmpatch.events.ControllerListener;
import pw.palmpatch.events.PatcherControllerEvent;
import pw.palmpatch.models.PatcherMainModel;
import pw.palmpatch.models.RankingsTableModelAdapter;
import pw.palmpatch.models.StatisticsModel;
import pw.palmpatch.models.TargetInfosToStatisticsTableModelAdapter;
import pw.palmpatch.ui.views.StatisticsView;

public class StatisticsController
extends SubController
implements ControllerListener {
    public StatisticsController() {
        this.initialize();
    }

    public void controllerEventOccurred(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof PatcherControllerEvent) {
            switch (((PatcherControllerEvent)controllerEvent).getKind()) {
                case 3: {
                    PatcherMainModel patcherMainModel = ((PatcherControllerEvent)controllerEvent).getNewModel();
                    ((StatisticsModel)this.getModel()).setModelToBaseStatisticsOn(patcherMainModel.getTargetInfos(), ((StatisticsView)this.getView()).getNumberOfTopPositionsToShow());
                    break;
                }
                case 1: {
                    PatcherMainModel patcherMainModel = ((PatcherControllerEvent)controllerEvent).getNewModel();
                    ((StatisticsModel)this.getModel()).setModelToBaseStatisticsOn(patcherMainModel.getTargetInfos(), ((StatisticsView)this.getView()).getNumberOfTopPositionsToShow());
                    break;
                }
            }
        }
    }

    public List getActions() {
        return null;
    }

    public RankingsTableModelAdapter getRankingsTableModelAdapter() {
        return ((StatisticsModel)this.getModel()).getRankingsTableModelAdapter();
    }

    public TargetInfosToStatisticsTableModelAdapter getTargetInfosToStatisticsTableModelAdapter() {
        return ((StatisticsModel)this.getModel()).getTargetInfosToStatisticsTableModelAdapter();
    }

    protected void initialize() {
    }

    public void triggerUpdate() {
        if (this.getParentController().getModel() != null) {
            ((StatisticsModel)this.getModel()).triggerUpdate();
        }
    }

    public void updateRankings(int n) {
        if (this.getParentController().getModel() != null) {
            ((StatisticsModel)this.getModel()).recalculateTopRankings(n);
            ((StatisticsModel)this.getModel()).getRankingsTableModelAdapter().fireTableDataChanged();
        }
    }
}

