/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.controller.preferences;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pw.palmpatch.Application;
import pw.palmpatch.PreferenceNode;
import pw.palmpatch.Preferences;
import pw.palmpatch.ui.views.PWFileChooser;
import pw.palmpatch.util.ImageCache;

public class DownloadPreferenceNode
extends PreferenceNode {
    private PWFileChooser fileChooser = PWFileChooser.createFileChooserForTargetLists();
    private Preferences preferences;

    public DownloadPreferenceNode() {
        this.fileChooser.setPreferredSize(new Dimension(this.fileChooser.getPreferredSize().width, 350));
        this.setDescription("Download Preferences");
        this.setTitle("Download");
        this.setIcon(ImageCache.singleton().getIcon("icons/download.gif"));
        this.setOpenIcon(this.getIcon());
        this.setSystemNode(false);
    }

    public JComponent buildClient() {
        class Pw_palmpatch_controller_preferences_DownloadPreferenceNode$2 {
            /* synthetic */ Pw_palmpatch_controller_preferences_DownloadPreferenceNode$2() {
            }
        }
        return new DownloadPreferenceNodeClient();
    }

    public void display(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("preferences must not be null");
        }
        this.preferences = preferences;
        ((DownloadPreferenceNodeClient)this.getClient()).urlToDownloadFromTextField.setText(preferences.getString("palmpassDownloadURL"));
        String string = preferences.getString("directoryToDownloadTo");
        if (string.equals("")) {
            string = preferences.getString("fileToLoadOnStartup");
        }
        ((DownloadPreferenceNodeClient)this.getClient()).directoryToDownloadToTextField.setText(string);
        ((DownloadPreferenceNodeClient)this.getClient()).askToOverwriteFileCheckBox.setSelected(preferences.getBool("askToOverwriteFileToDownload"));
        ((DownloadPreferenceNodeClient)this.getClient()).downloadOnlyIfNewerThanLocalFileCheckBox.setSelected(preferences.getBool("onlyDownloadFileIfNewerThanLocalFile"));
        ((DownloadPreferenceNodeClient)this.getClient()).loadFileAfterDownloadCheckBox.setSelected(preferences.getBool("loadFileAfterDownload"));
    }

    public void save(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("preferences must not be null");
        }
        if (this.getClient() != null) {
            preferences.setValue("palmpassDownloadURL", ((DownloadPreferenceNodeClient)this.getClient()).urlToDownloadFromTextField.getText());
            preferences.setValue("directoryToDownloadTo", ((DownloadPreferenceNodeClient)this.getClient()).directoryToDownloadToTextField.getText());
            preferences.setValue("askToOverwriteFileToDownload", ((DownloadPreferenceNodeClient)this.getClient()).askToOverwriteFileCheckBox.isSelected());
            preferences.setValue("onlyDownloadFileIfNewerThanLocalFile", ((DownloadPreferenceNodeClient)this.getClient()).downloadOnlyIfNewerThanLocalFileCheckBox.isSelected());
            preferences.setValue("loadFileAfterDownload", ((DownloadPreferenceNodeClient)this.getClient()).loadFileAfterDownloadCheckBox.isSelected());
        }
    }

    private class DownloadPreferenceNodeClient
    extends JPanel {
        private JLabel urlToDownloadFromLabel = new JLabel("URL for download");
        private JTextField urlToDownloadFromTextField = new JTextField();
        private JLabel directoryToDownloadToLabel = new JLabel("Download to directory");
        private JTextField directoryToDownloadToTextField = new JTextField();
        private JButton directoryToDownloadToButton = new JButton("Choose");
        private JCheckBox askToOverwriteFileCheckBox;
        private JCheckBox downloadOnlyIfNewerThanLocalFileCheckBox;
        private JCheckBox loadFileAfterDownloadCheckBox;

        private DownloadPreferenceNodeClient() {
            this.directoryToDownloadToButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ DownloadPreferenceNodeClient this$1;
                {
                    this.this$1 = downloadPreferenceNodeClient;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.performChooseDownloadFileAction();
                }
            });
            this.askToOverwriteFileCheckBox = new JCheckBox("Ask to overwrite file");
            this.downloadOnlyIfNewerThanLocalFileCheckBox = new JCheckBox("Download only if newer than local file");
            this.loadFileAfterDownloadCheckBox = new JCheckBox("Load file after download has completed");
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(this.urlToDownloadFromLabel, gridBagConstraints);
            this.add(this.urlToDownloadFromLabel);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagLayout.setConstraints(this.urlToDownloadFromTextField, gridBagConstraints);
            this.add(this.urlToDownloadFromTextField);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.directoryToDownloadToLabel, gridBagConstraints);
            this.add(this.directoryToDownloadToLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.directoryToDownloadToButton, gridBagConstraints);
            this.add(this.directoryToDownloadToButton);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.directoryToDownloadToTextField, gridBagConstraints);
            this.add(this.directoryToDownloadToTextField);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 2;
            gridBagLayout.setConstraints(this.askToOverwriteFileCheckBox, gridBagConstraints);
            this.add(this.askToOverwriteFileCheckBox);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagLayout.setConstraints(this.downloadOnlyIfNewerThanLocalFileCheckBox, gridBagConstraints);
            this.add(this.downloadOnlyIfNewerThanLocalFileCheckBox);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagLayout.setConstraints(this.loadFileAfterDownloadCheckBox, gridBagConstraints);
            this.add(this.loadFileAfterDownloadCheckBox);
        }

        public void performChooseDownloadFileAction() {
            File file;
            String string;
            DownloadPreferenceNode.this.fileChooser.setDialogTitle("Choose the directory to download to");
            DownloadPreferenceNode.this.fileChooser.setApproveButtonText("Choose");
            DownloadPreferenceNode.this.fileChooser.setFileSelectionMode(1);
            File file2 = new File(DownloadPreferenceNode.this.preferences.getString("lastDirectoryOpenedToLoadTargetList"));
            file2 = file2.exists() && file2.isDirectory() ? ((string = file2.getParent()) != null ? new File(string) : new File(System.getProperty("user.home"))) : new File(System.getProperty("user.home"));
            DownloadPreferenceNode.this.fileChooser.setCurrentDirectory(file2);
            int n = DownloadPreferenceNode.this.fileChooser.showOpenDialog(Application.singleton().getApplicationFrame());
            if (n == 0 && (file = DownloadPreferenceNode.this.fileChooser.getSelectedFile()) != null) {
                this.directoryToDownloadToTextField.setText(file.getAbsolutePath());
            }
        }
    }
}

