/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.controller.preferences;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import pw.palmpatch.Application;
import pw.palmpatch.PreferenceNode;
import pw.palmpatch.Preferences;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.ImageCache;
import pw.palmpatch.util.Log;

public class FontSelectorPreferenceNode
extends PreferenceNode {
    public FontSelectorPreferenceNode() {
        this.setDescription("Font Preferences");
        this.setTitle("Fonts");
        this.setIcon(ImageCache.singleton().getIcon("icons/fonts.gif"));
        this.setOpenIcon(this.getIcon());
        this.setSystemNode(false);
    }

    public JComponent buildClient() {
        return new FontSelectorPreferenceNodeClient();
    }

    public void display(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("preferences must not be null");
        }
        ((FontSelectorPreferenceNodeClient)this.getClient()).setFontToConfigure(preferences.getFont("font"));
    }

    public void save(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("preferences must not be null");
        }
        if (this.getClient() != null) {
            Font font = ((FontSelectorPreferenceNodeClient)this.getClient()).getConfiguredFont();
            preferences.setValue("font", font);
            UIManager.put("Tree.font", new FontUIResource(font));
            UIManager.put("EditorPane.font", new FontUIResource(font));
            UIManager.put("TextPane.font", new FontUIResource(font));
            UIManager.put("TextArea.font", new FontUIResource(font));
            UIManager.put("TextField.font", new FontUIResource(font));
            UIManager.put("List.font", new FontUIResource(font));
            UIManager.put("Table.font", new FontUIResource(font));
            UIManager.put("TabbedPane.font", new FontUIResource(font));
            UIManager.put("MenuBar.font", new FontUIResource(font));
            UIManager.put("Menu.font", new FontUIResource(font));
            UIManager.put("MenuItem.font", new FontUIResource(font));
            UIManager.put("Label.font", new FontUIResource(font));
            UIManager.put("Table.font", new FontUIResource(font));
            UIManager.put("TableHeader.font", new FontUIResource(font));
            UIManager.put("Button.font", new FontUIResource(font));
            UIManager.put("RadioButton.font", new FontUIResource(font));
            UIManager.put("ComboBox.font", new FontUIResource(font));
            UIManager.put("CheckBox.font", new FontUIResource(font));
            try {
                UIManager.setLookAndFeel(UIManager.getLookAndFeel().getClass().getName());
            }
            catch (Throwable throwable) {
                Log.singleton().logNewMessage(new ErrorMessage("The Look & Feel could not be changed." + System.getProperty("line.separator") + throwable));
            }
            SwingUtilities.updateComponentTreeUI(SwingUtilities.getRoot(Application.singleton().getApplicationFrame()));
        }
    }

    private class FontSelectorPreferenceNodeClient
    extends JPanel
    implements ItemListener,
    ActionListener,
    ChangeListener {
        private JComboBox availableFonts;
        private JComboBox availableFontSizes;
        private JCheckBox boldCB;
        private JCheckBox italicCB;
        private JTextField testTextField;
        private FontDisplay fontDisplay;
        private Integer[] fontSizes;
        private String[] fontNames;
        private Font configuredFont;

        public FontSelectorPreferenceNodeClient() {
            this(null, null);
        }

        private FontSelectorPreferenceNodeClient(String[] stringArray, int[] nArray) {
            if (nArray != null) {
                this.fontSizes = new Integer[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    this.fontSizes[n] = new Integer(nArray[n]);
                    ++n;
                }
            } else {
                Integer[] integerArray = new Integer[]{new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(14), new Integer(16), new Integer(18), new Integer(20), new Integer(22), new Integer(24), new Integer(26)};
                this.fontSizes = integerArray;
            }
            this.fontNames = stringArray != null ? stringArray : this.getAvailableFontFamilyNames();
            this.setLayout(new BoxLayout(this, 1));
            this.availableFonts = new JComboBox<String>(this.fontNames);
            this.availableFonts.setSize(new Dimension(30, this.availableFonts.getPreferredSize().height));
            this.availableFonts.addItemListener(this);
            this.availableFontSizes = new JComboBox<Integer>(this.fontSizes);
            this.availableFontSizes.setSize(new Dimension(30, this.availableFontSizes.getPreferredSize().height));
            this.availableFontSizes.addItemListener(this);
            this.boldCB = new JCheckBox("bold");
            this.boldCB.addChangeListener(this);
            Font font = this.boldCB.getFont();
            this.boldCB.setFont(new Font(font.getName(), 1, font.getSize()));
            this.italicCB = new JCheckBox("italic");
            this.italicCB.addChangeListener(this);
            font = this.italicCB.getFont();
            this.italicCB.setFont(new Font(font.getName(), 2, font.getSize()));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add(this.boldCB);
            jPanel.add(this.italicCB);
            this.testTextField = new JTextField("The Quick Brown Fox Jumps Over The Lazy Dog");
            this.testTextField.addActionListener(this);
            this.fontDisplay = new FontDisplay(this.testTextField.getText());
            TitledBorder titledBorder = BorderFactory.createTitledBorder("Test");
            titledBorder.setTitleFont(new Font("Dialog", 0, 10));
            this.fontDisplay.setBorder(titledBorder);
            this.add(this.availableFonts);
            this.add(Box.createVerticalStrut(5));
            this.add(this.availableFontSizes);
            this.add(Box.createVerticalStrut(2));
            this.add(jPanel);
            this.add(Box.createVerticalStrut(2));
            this.add(this.testTextField);
            this.add(Box.createVerticalStrut(5));
            this.add(this.fontDisplay);
            this.configuredFont = new Font("Dialog", 0, 12);
            this.setFontToConfigure(this.configuredFont);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fontDisplay.setText(actionEvent.getActionCommand());
        }

        protected void changeFont() {
            if (this.availableFonts.getSelectedItem() == null) {
                return;
            }
            String string = this.availableFonts.getSelectedItem().toString();
            int n = 0;
            if (this.boldCB.isSelected()) {
                n = 1;
            }
            if (this.italicCB.isSelected()) {
                n = 2;
            }
            if (this.boldCB.isSelected() && this.italicCB.isSelected()) {
                n = 3;
            }
            if (this.availableFontSizes.getSelectedItem() == null) {
                return;
            }
            String string2 = this.availableFontSizes.getSelectedItem().toString();
            int n2 = new Integer(string2);
            this.configuredFont = new Font(string, n, n2);
            this.updateFontDisplay();
        }

        public String[] getAvailableFontFamilyNames() {
            String[] stringArray = null;
            try {
                try {
                    stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    stringArray = Toolkit.getDefaultToolkit().getFontList();
                }
            }
            catch (Throwable throwable) {}
            return stringArray;
        }

        public Font getConfiguredFont() {
            return this.configuredFont;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this.changeFont();
            }
        }

        public void setFontToConfigure(Font font) {
            this.availableFonts.setSelectedItem(font.getName());
            this.availableFontSizes.setSelectedItem(new Integer(font.getSize()));
            int n = font.getStyle();
            switch (n) {
                case 1: {
                    this.boldCB.setSelected(true);
                    break;
                }
                case 2: {
                    this.italicCB.setSelected(true);
                    break;
                }
                case 3: {
                    this.boldCB.setSelected(true);
                    this.italicCB.setSelected(true);
                    break;
                }
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.changeFont();
        }

        protected void updateFontDisplay() {
            this.fontDisplay.setFont(this.configuredFont);
        }

        private class FontDisplay
        extends JComponent {
            private JLabel jLabel;
            private int width = 140;
            private int height = 40;

            public FontDisplay(String string) {
                this.jLabel = new JLabel(string);
                this.setLayout(new BorderLayout());
                this.add("Center", this.jLabel);
            }

            public Dimension getMinimumSize() {
                return new Dimension(this.width, this.height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.width, this.height);
            }

            public void setFont(Font font) {
                this.jLabel.setFont(font);
            }

            public void setText(String string) {
                this.jLabel.setText(string);
            }
        }
    }
}

