/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.controller.preferences;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import pw.palmpatch.PreferenceNode;
import pw.palmpatch.Preferences;
import pw.palmpatch.util.ImageCache;

public class ImportExportPreferenceNode
extends PreferenceNode {
    ImportExportPreferenceNode() {
        this.setDescription("Encodings for Import and Export");
        this.setTitle("Encodings");
        this.setIcon(ImageCache.singleton().getIcon("icons/importExport.gif"));
        this.setOpenIcon(this.getIcon());
        this.setSystemNode(false);
    }

    public JComponent buildClient() {
        return new ImportExportPreferenceNodeClient();
    }

    public void display(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("preferences must not be null");
        }
        if ("ASCII".equals(preferences.getString("encodingUsedForSave"))) {
            ((ImportExportPreferenceNodeClient)this.getClient()).saveASCIIEncodedRadioButton.setSelected(true);
        } else if ("UTF-8".equals(preferences.getString("encodingUsedForSave"))) {
            ((ImportExportPreferenceNodeClient)this.getClient()).saveUTF8EncodedRadioButton.setSelected(true);
        }
        if ("ASCII".equals(preferences.getString("encodingUsedForExport"))) {
            ((ImportExportPreferenceNodeClient)this.getClient()).exportASCIIEncodedRadioButton.setSelected(true);
        } else if ("UTF-8".equals(preferences.getString("encodingUsedForExport"))) {
            ((ImportExportPreferenceNodeClient)this.getClient()).exportUTF8EncodedRadioButton.setSelected(true);
        }
    }

    public void save(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("preferences must not be null");
        }
        if (this.getClient() != null) {
            if (((ImportExportPreferenceNodeClient)this.getClient()).saveASCIIEncodedRadioButton.isSelected()) {
                preferences.setValue("encodingUsedForSave", "ASCII");
            } else if (((ImportExportPreferenceNodeClient)this.getClient()).saveUTF8EncodedRadioButton.isSelected()) {
                preferences.setValue("encodingUsedForSave", "UTF-8");
            }
            if (((ImportExportPreferenceNodeClient)this.getClient()).exportASCIIEncodedRadioButton.isSelected()) {
                preferences.setValue("encodingUsedForExport", "ASCII");
            } else if (((ImportExportPreferenceNodeClient)this.getClient()).exportUTF8EncodedRadioButton.isSelected()) {
                preferences.setValue("encodingUsedForExport", "UTF-8");
            }
        }
    }

    private class ImportExportPreferenceNodeClient
    extends JPanel {
        protected JRadioButton saveUTF8EncodedRadioButton = new JRadioButton("Save as UTF-8");
        protected JRadioButton saveASCIIEncodedRadioButton = new JRadioButton("Save as ASCII");
        protected ButtonGroup saveButtonGroup = new ButtonGroup();
        protected JRadioButton exportUTF8EncodedRadioButton;
        protected JRadioButton exportASCIIEncodedRadioButton;
        protected ButtonGroup exportButtonGroup;

        ImportExportPreferenceNodeClient() {
            this.saveButtonGroup.add(this.saveUTF8EncodedRadioButton);
            this.saveButtonGroup.add(this.saveASCIIEncodedRadioButton);
            this.exportUTF8EncodedRadioButton = new JRadioButton("Export as UTF-8");
            this.exportASCIIEncodedRadioButton = new JRadioButton("Export as ASCII");
            this.exportButtonGroup = new ButtonGroup();
            this.exportButtonGroup.add(this.exportUTF8EncodedRadioButton);
            this.exportButtonGroup.add(this.exportASCIIEncodedRadioButton);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(this.saveUTF8EncodedRadioButton, gridBagConstraints);
            this.add(this.saveUTF8EncodedRadioButton);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(this.saveASCIIEncodedRadioButton, gridBagConstraints);
            this.add(this.saveASCIIEncodedRadioButton);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.exportUTF8EncodedRadioButton, gridBagConstraints);
            this.add(this.exportUTF8EncodedRadioButton);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.exportASCIIEncodedRadioButton, gridBagConstraints);
            this.add(this.exportASCIIEncodedRadioButton);
        }
    }
}

