/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.controller.preferences;

import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import pw.palmpatch.Application;
import pw.palmpatch.PreferenceNode;
import pw.palmpatch.Preferences;
import pw.palmpatch.controller.preferences.FontSelectorPreferenceNode;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.ImageCache;
import pw.palmpatch.util.Log;

public class UIPreferenceNode
extends PreferenceNode {
    public UIPreferenceNode() {
        this.setDescription("UI Preferences");
        this.setTitle("User Interface");
        this.setIcon(ImageCache.singleton().getIcon("icons/uiPreferenceIcon.gif"));
        this.setOpenIcon(this.getIcon());
        this.setSystemNode(false);
        this.addChild(new FontSelectorPreferenceNode());
    }

    public JComponent buildClient() {
        return new UIPreferenceNodeClient();
    }

    public void display(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("preferences must not be null");
        }
        String string = preferences.getString("lookAndFeel");
        ComboBoxModel comboBoxModel = ((UIPreferenceNodeClient)this.getClient()).lookAndFeelComboBox.getModel();
        boolean bl = false;
        int n = 0;
        while (n < comboBoxModel.getSize()) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)comboBoxModel.getElementAt(n);
            if (string.equals(lookAndFeelInfo.getClassName())) {
                ((UIPreferenceNodeClient)this.getClient()).lookAndFeelComboBox.setSelectedIndex(n);
                bl = true;
                break;
            }
            ++n;
        }
    }

    public void performLookAndFeelSwitch(String string) {
        if (UIManager.getLookAndFeel().getClass().getName().equals(string)) {
            return;
        }
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(SwingUtilities.getRoot(Application.singleton().getApplicationFrame()));
        }
        catch (Throwable throwable) {
            Log.singleton().logNewMessage(new ErrorMessage("The Look & Feel could not be changed." + System.getProperty("line.separator") + throwable));
        }
    }

    public void save(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("preferences must not be null");
        }
        if (this.getClient() != null) {
            preferences.setValue("lookAndFeel", ((UIManager.LookAndFeelInfo)((UIPreferenceNodeClient)this.getClient()).lookAndFeelComboBox.getSelectedItem()).getClassName());
        }
        this.performLookAndFeelSwitch(preferences.getString("lookAndFeel"));
    }

    private class UIPreferenceNodeClient
    extends JPanel {
        protected JPanel uiSettingsPanel;
        protected JLabel lookAndFeelLabel;
        protected JComboBox lookAndFeelComboBox;

        UIPreferenceNodeClient() {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(20);
            flowLayout.setVgap(20);
            this.setLayout(flowLayout);
            this.lookAndFeelLabel = new JLabel("Look & Feel");
            this.lookAndFeelComboBox = new JComboBox<UIManager.LookAndFeelInfo>(UIManager.getInstalledLookAndFeels());
            this.lookAndFeelComboBox.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    if (bl) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(jList.getBackground());
                        this.setForeground(jList.getForeground());
                    }
                    if (object instanceof UIManager.LookAndFeelInfo) {
                        this.setText(((UIManager.LookAndFeelInfo)object).getName());
                    } else {
                        this.setText(object == null ? "" : object.toString());
                    }
                    this.setEnabled(jList.isEnabled());
                    this.setFont(jList.getFont());
                    this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : DefaultListCellRenderer.noFocusBorder);
                    return this;
                }
            });
            this.add(this.lookAndFeelLabel);
            this.add(this.lookAndFeelComboBox);
        }
    }
}

