/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import pw.palmpatch.patchengine.CRC16Support;

public class GenericFile
extends File {
    private CRC16Support crc16Support;
    private String cachedCRC16;

    public GenericFile(File file) {
        super(file.getAbsolutePath());
    }

    public GenericFile(File file, String string) {
        super(file, string);
    }

    public GenericFile(String string) {
        super(string);
    }

    public GenericFile(String string, String string2) {
        super(string, string2);
    }

    public static String[] chopOffFileExtension(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("fileName must not be null or an empty string");
        }
        String string2 = null;
        String string3 = null;
        int n = string.lastIndexOf(File.separator);
        int n2 = string.lastIndexOf(".");
        if (n != -1) {
            if (n < n2) {
                string2 = string.substring(0, n2);
                if (n2 != string.length() - 1) {
                    string3 = string.substring(n2 + 1);
                } else {
                    string = "";
                }
            } else {
                string2 = string;
            }
        } else {
            if (n2 != string.length() - 1) {
                string3 = string.substring(n2 + 1);
            }
            string2 = string.substring(0, n2);
        }
        String[] stringArray = new String[]{string2, string3};
        return stringArray;
    }

    public void copy(File file) throws IOException {
        if (file.exists()) {
            throw new IOException("Cannot copy " + this.getAbsolutePath() + " to " + file.getAbsolutePath() + " because it allready exists");
        }
        int n = 2048;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this), n);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), n);
        try {
            int n2 = bufferedInputStream.read();
            while (n2 != -1) {
                bufferedOutputStream.write(n2);
                n2 = bufferedInputStream.read();
            }
        }
        finally {
            Object var7_6 = null;
            bufferedInputStream.close();
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
    }

    public String getCRC16() {
        return this.getCRC16(false);
    }

    public String getCRC16(boolean bl) {
        if (!bl && this.cachedCRC16 != null) {
            return this.cachedCRC16;
        }
        try {
            this.cachedCRC16 = Integer.toString(this.getCRC16Support().calculateCRC16For(this), 10).toUpperCase();
            return this.cachedCRC16;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return fileNotFoundException.toString();
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
    }

    private CRC16Support getCRC16Support() {
        if (this.crc16Support == null) {
            this.crc16Support = new CRC16Support();
        }
        return this.crc16Support;
    }
}

