/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import pw.palmpatch.ui.widgets.ProgressIndicator;

public class ProgressIndicatorInputStream
extends FilterInputStream {
    private ProgressIndicator aProgressIndicator;
    private int nread = 0;
    private int size = 0;

    public ProgressIndicatorInputStream(InputStream inputStream, ProgressIndicator progressIndicator) {
        super(inputStream);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException("aProgressIndicator must not be null");
        }
        this.aProgressIndicator = progressIndicator;
    }

    public void close() throws IOException {
        this.aProgressIndicator.cancel();
        this.aProgressIndicator.reset();
        this.in.close();
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n >= 0) {
            this.aProgressIndicator.setProgress(++this.nread);
        }
        if (this.aProgressIndicator.hasBeenCanceled()) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("progress");
            interruptedIOException.bytesTransferred = this.nread;
            throw interruptedIOException;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n > 0) {
            this.aProgressIndicator.setProgress(this.nread += n);
        }
        if (this.aProgressIndicator.hasBeenCanceled()) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("progress");
            interruptedIOException.bytesTransferred = this.nread;
            throw interruptedIOException;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            this.aProgressIndicator.setProgress(this.nread += n3);
        }
        if (this.aProgressIndicator.hasBeenCanceled()) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("progress");
            interruptedIOException.bytesTransferred = this.nread;
            throw interruptedIOException;
        }
        return n3;
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - this.in.available();
        this.aProgressIndicator.setProgress(this.nread);
    }

    public long skip(long l) throws IOException {
        long l2 = this.in.skip(l);
        if (l2 > 0L) {
            this.nread = (int)((long)this.nread + l2);
            this.aProgressIndicator.setProgress(this.nread);
        }
        return l2;
    }
}

