/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.io.palmfiles;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DataBuffer {
    private static int DEFAULT_CAPACITY = 16;
    private byte[] value;
    private int count;

    public DataBuffer() {
        this(0);
    }

    public DataBuffer(int n) {
        this.value = n > 0 ? new byte[n] : null;
        this.count = 0;
    }

    public synchronized DataBuffer append(byte by) {
        this.ensureCapacity(this.count + 1);
        this.value[this.count++] = by;
        return this;
    }

    public synchronized DataBuffer append(byte by, int n) {
        int n2 = 0;
        while (n2 < n) {
            this.append(by);
            ++n2;
        }
        return this;
    }

    public synchronized DataBuffer append(int n) {
        return this.append(n, 4);
    }

    public synchronized DataBuffer append(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.append((byte)(n >> (n2 - n3 - 1) * 8));
            ++n3;
        }
        return this;
    }

    public synchronized DataBuffer append(DataBuffer dataBuffer) {
        return this.append(dataBuffer, 0, dataBuffer.length());
    }

    public synchronized DataBuffer append(DataBuffer dataBuffer, int n, int n2) {
        return this.append(dataBuffer.peekValue(), n, n2);
    }

    public synchronized DataBuffer append(short s) {
        return this.append(s, 2);
    }

    public synchronized DataBuffer append(byte[] byArray) {
        return this.append(byArray, 0, byArray.length);
    }

    public synchronized DataBuffer append(byte[] byArray, int n, int n2) {
        if (n2 > 0) {
            this.ensureCapacity(this.count + n2);
            System.arraycopy(byArray, n, this.value, this.count, n2);
            this.count += n2;
        }
        return this;
    }

    public int capacity() {
        return this.value == null ? 0 : this.value.length;
    }

    public synchronized void clear() {
        this.count = 0;
    }

    public synchronized void ensureCapacity(int n) {
        int n2 = this.capacity();
        if (n > n2) {
            int n3 = (n2 + 1) * 2;
            if (n3 < DEFAULT_CAPACITY) {
                n3 = DEFAULT_CAPACITY;
            }
            if (n3 < n) {
                n3 = n;
            }
            byte[] byArray = new byte[n3];
            if (this.value != null) {
                System.arraycopy(this.value, 0, byArray, 0, this.count);
            }
            this.value = byArray;
        }
    }

    public byte getByteAt(int n) {
        if (n < 0 || n >= this.length()) {
            throw new IllegalArgumentException("Bad offset " + n + " (length = " + this.length() + ").");
        }
        return this.value[n];
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.length()];
        if (this.value != null) {
            System.arraycopy(this.value, 0, byArray, 0, this.length());
        }
        return byArray;
    }

    public byte[] getBytes(int n) {
        if (n > this.length()) {
            throw new IllegalArgumentException("start is too big!");
        }
        byte[] byArray = new byte[this.length() - n];
        if (this.value != null) {
            System.arraycopy(this.value, n, byArray, 0, this.length() - n);
        }
        return byArray;
    }

    public byte[] getBytes(int n, int n2) {
        if (n > this.length()) {
            throw new IllegalArgumentException("start is too big!");
        }
        if (n2 > this.length()) {
            throw new IllegalArgumentException("length is too big!");
        }
        byte[] byArray = new byte[n2];
        if (this.value != null) {
            System.arraycopy(this.value, 0, byArray, 0, n2);
        }
        return byArray;
    }

    public int getIntAt(int n) {
        return this.getIntegerAt(n, 4);
    }

    public int getIntegerAt(int n, int n2) {
        int n3 = this.getByteAt(n);
        int n4 = 1;
        while (n4 < n2) {
            n3 = (n3 << 8) + (this.getByteAt(n + n4) & 0xFF);
            ++n4;
        }
        return n3;
    }

    public short getShortAt(int n) {
        return (short)this.getIntegerAt(n, 2);
    }

    public String getStringAt(int n) {
        int n2 = this.length() - n;
        return this.getStringAt(n, n2);
    }

    public String getStringAt(int n, int n2) {
        int n3 = 0;
        while (n3 < n2 && this.getByteAt(n + n3) != 0) {
            ++n3;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.value, n, byArray, 0, n3);
        return new String(byArray);
    }

    public int length() {
        return this.count;
    }

    public byte[] peekValue() {
        return this.value;
    }

    public synchronized int read(InputStream inputStream, int n) throws IOException {
        this.ensureCapacity(this.count + n);
        int n2 = inputStream.read(this.value, this.count, n);
        if (n2 > 0) {
            this.count += n2;
        }
        return n2;
    }

    public synchronized void setByteAt(int n, byte by) {
        if (n < 0 || n >= this.length()) {
            throw new IllegalArgumentException("Bad offset " + n + " (length = " + this.length() + ").");
        }
        this.value[n] = by;
    }

    public synchronized void write(OutputStream outputStream) throws IOException {
        if (this.length() > 0) {
            outputStream.write(this.value, 0, this.length());
        }
    }
}

