/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.io.palmfiles;

import java.util.Date;
import pw.palmpatch.io.palmfiles.DataBuffer;

public class DatabaseHeader {
    protected String name;
    protected int attributes;
    protected int version;
    protected Date creationDate;
    protected Date modificationDate;
    protected Date lastBackupDate;
    protected int modificationNumber;
    protected int appInfoID;
    protected int sortInfoID;
    protected int type;
    protected String typeString;
    protected int creator;
    protected String creatorString;
    protected int uniqueIDSeed;
    protected static int NAME_OFFSET = 0;
    protected static int ATTRIBUTES_OFFSET = 32;
    protected static int VERSION_OFFSET = 34;
    protected static int CREATION_DATE_OFFSET = 36;
    protected static int MODIFICATION_DATE_OFFSET = 40;
    protected static int LAST_BACKUP_DATE_OFFSET = 44;
    protected static int MODIFICATION_NUMBER_OFFSET = 48;
    protected static int APP_INFO_ID_OFFSET = 52;
    protected static int SORT_INFO_ID_OFFSET = 56;
    protected static int TYPE_OFFSET = 60;
    protected static int CREATOR_OFFSET = 64;
    protected static int UNIQUE_ID_SEED_OFFSET = 68;

    public DatabaseHeader(DataBuffer dataBuffer) {
        this.name = dataBuffer.getStringAt(NAME_OFFSET, 32);
        this.attributes = dataBuffer.getIntegerAt(ATTRIBUTES_OFFSET, 2);
        this.version = dataBuffer.getIntegerAt(VERSION_OFFSET, 2);
        this.creationDate = new Date((long)dataBuffer.getIntegerAt(CREATION_DATE_OFFSET, 4) & 0xFFFFFFFFL);
        this.modificationDate = new Date((long)dataBuffer.getIntegerAt(MODIFICATION_DATE_OFFSET, 4) & 0xFFFFFFFFL);
        this.lastBackupDate = new Date((long)dataBuffer.getIntegerAt(LAST_BACKUP_DATE_OFFSET, 4) & 0xFFFFFFFFL);
        this.modificationNumber = dataBuffer.getIntegerAt(MODIFICATION_NUMBER_OFFSET, 4);
        this.appInfoID = dataBuffer.getIntegerAt(APP_INFO_ID_OFFSET, 4);
        this.sortInfoID = dataBuffer.getIntegerAt(SORT_INFO_ID_OFFSET, 4);
        this.type = dataBuffer.getIntegerAt(TYPE_OFFSET, 4);
        this.typeString = dataBuffer.getStringAt(TYPE_OFFSET, 4);
        this.creator = dataBuffer.getIntegerAt(CREATOR_OFFSET, 4);
        this.creatorString = dataBuffer.getStringAt(CREATOR_OFFSET, 4);
        this.uniqueIDSeed = dataBuffer.getIntegerAt(UNIQUE_ID_SEED_OFFSET, 4);
    }

    public int getAppInfoID() {
        return this.appInfoID;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public int getCreator() {
        return this.creator;
    }

    public String getCreatorAsString() {
        return this.creatorString;
    }

    public Date getLastBackupDate() {
        return this.lastBackupDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public int getModificationNumber() {
        return this.modificationNumber;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return 76;
    }

    public int getSortInfoID() {
        return this.sortInfoID;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return this.typeString;
    }

    public int getUniqueIDSeed() {
        return this.uniqueIDSeed;
    }

    public int getVersion() {
        return this.version;
    }
}

