/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.io.palmfiles;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.IOException;
import pw.palmpatch.io.palmfiles.ApplicationIconNameRessource;
import pw.palmpatch.io.palmfiles.DataBuffer;
import pw.palmpatch.io.palmfiles.PRCRecordList;
import pw.palmpatch.io.palmfiles.PalmDatabase;
import pw.palmpatch.io.palmfiles.RecordList;
import pw.palmpatch.io.palmfiles.RessourceEntry;
import pw.palmpatch.io.palmfiles.RessourceFactory;
import pw.palmpatch.io.palmfiles.RessourceType;
import pw.palmpatch.io.palmfiles.VersionRessource;

public class PRCDatabase
extends PalmDatabase {
    public PRCDatabase(File file) {
        super(file);
    }

    public PRCDatabase(File file, String string) {
        super(file, string);
    }

    public PRCDatabase(String string) {
        super(string);
    }

    public PRCDatabase(String string, String string2) {
        super(string, string2);
    }

    protected List constructRessources(Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("ressourceEntries must not be null");
        }
        ArrayList arrayList = new ArrayList();
        RessourceEntry ressourceEntry = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ressourceEntry = (RessourceEntry)iterator.next();
            arrayList.add((Object)RessourceFactory.getSingleton().createRessource(ressourceEntry, this.getRawContents()));
        }
        return arrayList;
    }

    public List getAllRecords() {
        PRCRecordList pRCRecordList = (PRCRecordList)this.getRecordList();
        Collection collection = pRCRecordList.getAllRecordEntries();
        if (collection == null) {
            return null;
        }
        return this.constructRessources(collection);
    }

    public String getApplicationIconName() {
        List list = this.getRessources(RessourceType.APPLICATION_ICON_NAME_RESSOURCE);
        if (list.size() == 0) {
            return null;
        }
        Iterator iterator = list.iterator();
        ApplicationIconNameRessource applicationIconNameRessource = (ApplicationIconNameRessource)iterator.next();
        return applicationIconNameRessource.getString();
    }

    public List getRessources(RessourceType ressourceType) {
        PRCRecordList pRCRecordList = (PRCRecordList)this.getRecordList();
        Set set = pRCRecordList.getRessourceEntries(ressourceType);
        if (set == null) {
            return null;
        }
        return this.constructRessources((Collection)set);
    }

    public String getVersion() {
        List list = this.getRessources(RessourceType.VERSION_RESSOURCE);
        if (list.size() == 0) {
            return null;
        }
        Iterator iterator = list.iterator();
        VersionRessource versionRessource = (VersionRessource)iterator.next();
        return versionRessource.getString();
    }

    protected RecordList readRecordList(DataBuffer dataBuffer) throws IOException {
        PRCRecordList pRCRecordList = new PRCRecordList();
        pRCRecordList.read(dataBuffer.peekValue());
        return pRCRecordList;
    }
}

