/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.io.palmfiles;

import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.List;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import pw.palmpatch.io.GenericFile;
import pw.palmpatch.io.palmfiles.DataBuffer;
import pw.palmpatch.io.palmfiles.DatabaseHeader;
import pw.palmpatch.io.palmfiles.RecordList;

public abstract class PalmDatabase
extends GenericFile {
    private DataBuffer rawContents;
    private DatabaseHeader databaseHeader;
    private RecordList recordList;
    private boolean readComplete;

    public PalmDatabase(File file) {
        super(file);
    }

    public PalmDatabase(File file, String string) {
        super(file, string);
    }

    public PalmDatabase(String string) {
        super(string);
    }

    public PalmDatabase(String string, String string2) {
        super(string, string2);
    }

    public Collection getAllRecordEntries() {
        if (!this.readComplete) {
            throw new IllegalStateException("readComplete has not been called (successfully= yet.");
        }
        return this.recordList.getAllRecordEntries();
    }

    public abstract List getAllRecords();

    public int getAttributes() {
        if (!this.readComplete) {
            throw new IllegalStateException("readComplete has not been called (successfully= yet.");
        }
        return this.databaseHeader.getAttributes();
    }

    public Date getCreationDate() {
        if (!this.readComplete) {
            throw new IllegalStateException("readComplete has not been called (successfully= yet.");
        }
        return this.databaseHeader.getCreationDate();
    }

    public int getCreator() {
        if (!this.readComplete) {
            throw new IllegalStateException("readComplete has not been called (successfully= yet.");
        }
        return this.databaseHeader.getCreator();
    }

    public String getCreatorAsString() {
        if (!this.readComplete) {
            throw new IllegalStateException("readComplete has not been called (successfully= yet.");
        }
        return this.databaseHeader.getCreatorAsString();
    }

    public String getDatabaseName() {
        if (!this.readComplete) {
            throw new IllegalStateException("readComplete has not been called (successfully= yet.");
        }
        return this.databaseHeader.getName();
    }

    public Date getLastBackupDate() {
        if (!this.readComplete) {
            throw new IllegalStateException("readComplete has not been called (successfully= yet.");
        }
        return this.databaseHeader.getLastBackupDate();
    }

    public Date getModificationDate() {
        if (!this.readComplete) {
            throw new IllegalStateException("readComplete has not been called (successfully= yet.");
        }
        return this.databaseHeader.getModificationDate();
    }

    public int getModificationNumber() {
        if (!this.readComplete) {
            throw new IllegalStateException("readComplete has not been called (successfully= yet.");
        }
        return this.databaseHeader.getModificationNumber();
    }

    public int getNumberOfRecords() {
        if (!this.readComplete) {
            throw new IllegalStateException("readComplete has not been called (successfully= yet.");
        }
        return this.recordList.getNumberOfRecords();
    }

    protected DataBuffer getRawContents() {
        return this.rawContents;
    }

    protected RecordList getRecordList() {
        return this.recordList;
    }

    public int getType() {
        if (!this.readComplete) {
            throw new IllegalStateException("readComplete has not been called (successfully= yet.");
        }
        return this.databaseHeader.getType();
    }

    public String getTypeAsString() {
        if (!this.readComplete) {
            throw new IllegalStateException("readComplete has not been called (successfully= yet.");
        }
        return this.databaseHeader.getTypeAsString();
    }

    public void readComplete() throws FileNotFoundException, IOException {
        BufferedInputStream bufferedInputStream = null;
        if (this.length() > Integer.MAX_VALUE) {
            throw new RuntimeException("File too big");
        }
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(this));
            this.rawContents = new DataBuffer((int)this.length());
            int n = this.rawContents.read(bufferedInputStream, (int)this.length());
            this.databaseHeader = new DatabaseHeader(this.rawContents);
            this.recordList = this.readRecordList(this.rawContents);
            this.readComplete = true;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        Object var3_3 = null;
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected abstract RecordList readRecordList(DataBuffer var1) throws IOException;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("PALM DATABASE");
        stringBuffer.append(string);
        stringBuffer.append("Name: ");
        stringBuffer.append(this.getDatabaseName());
        stringBuffer.append(string);
        stringBuffer.append("Creator: ");
        stringBuffer.append(this.getCreatorAsString());
        stringBuffer.append(string);
        stringBuffer.append("Type: ");
        stringBuffer.append(this.getCreatorAsString());
        stringBuffer.append(string);
        stringBuffer.append("Attributes: ");
        stringBuffer.append(this.getAttributes());
        stringBuffer.append(string);
        stringBuffer.append("Creation Date: ");
        stringBuffer.append(this.getCreationDate());
        stringBuffer.append(string);
        stringBuffer.append("Modification Date: ");
        stringBuffer.append(this.getModificationDate());
        stringBuffer.append(string);
        stringBuffer.append("Last Backup Date: ");
        stringBuffer.append(this.getLastBackupDate());
        stringBuffer.append(string);
        stringBuffer.append("Number of records: ");
        stringBuffer.append(this.getNumberOfRecords());
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

