/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.io.palmfiles;

import pw.palmpatch.io.palmfiles.AlertRessource;
import pw.palmpatch.io.palmfiles.ApplicationIconNameRessource;
import pw.palmpatch.io.palmfiles.DataBuffer;
import pw.palmpatch.io.palmfiles.Ressource;
import pw.palmpatch.io.palmfiles.RessourceEntry;
import pw.palmpatch.io.palmfiles.RessourceType;
import pw.palmpatch.io.palmfiles.StringRessource;
import pw.palmpatch.io.palmfiles.UnknownRessource;
import pw.palmpatch.io.palmfiles.VersionRessource;

public class RessourceFactory {
    protected static RessourceFactory singleton;
    static /* synthetic */ Class class$pw$palmpatch$io$palmfiles$RessourceFactory;

    private RessourceFactory() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Ressource createRessource(RessourceEntry ressourceEntry, DataBuffer dataBuffer) {
        Ressource ressource = null;
        if (ressourceEntry.getType() == RessourceType.STRING_RESSOURCE) {
            ressource = new StringRessource(ressourceEntry, dataBuffer.getStringAt(ressourceEntry.getLocalChunkID()));
        } else if (ressourceEntry.getType() == RessourceType.VERSION_RESSOURCE) {
            ressource = new VersionRessource(ressourceEntry, dataBuffer.getStringAt(ressourceEntry.getLocalChunkID()));
        } else if (ressourceEntry.getType() == RessourceType.APPLICATION_ICON_NAME_RESSOURCE) {
            ressource = new ApplicationIconNameRessource(ressourceEntry, dataBuffer.getStringAt(ressourceEntry.getLocalChunkID()));
        } else if (ressourceEntry.getType() == RessourceType.ALERT_RESSOURCE) {
            AlertRessource alertRessource = new AlertRessource(ressourceEntry);
            int n = ressourceEntry.getLocalChunkID();
            alertRessource.setAlertType(dataBuffer.getShortAt(n));
            alertRessource.setHelpRessourceID(dataBuffer.getShortAt(n + 2));
            alertRessource.setNumberOfButtons(dataBuffer.getShortAt(n + 4));
            alertRessource.setDefaultButton(dataBuffer.getShortAt(n + 6));
            String string = dataBuffer.getStringAt(n + 8);
            String string2 = dataBuffer.getStringAt(n + 8 + 1 + string.length());
            alertRessource.setTitle(string);
            alertRessource.setMessage(string2);
            ressource = alertRessource;
        } else {
            ressource = ressourceEntry.getType() == RessourceType.UNKNOWN_RESSOURCE ? new UnknownRessource(ressourceEntry) : new UnknownRessource(ressourceEntry);
        }
        return ressource;
    }

    public static RessourceFactory getSingleton() {
        Class clazz = class$pw$palmpatch$io$palmfiles$RessourceFactory != null ? class$pw$palmpatch$io$palmfiles$RessourceFactory : (class$pw$palmpatch$io$palmfiles$RessourceFactory = RessourceFactory.class$("pw.palmpatch.io.palmfiles.RessourceFactory"));
        synchronized (clazz) {
            if (singleton == null) {
                Class clazz2 = class$pw$palmpatch$io$palmfiles$RessourceFactory != null ? class$pw$palmpatch$io$palmfiles$RessourceFactory : (class$pw$palmpatch$io$palmfiles$RessourceFactory = RessourceFactory.class$("pw.palmpatch.io.palmfiles.RessourceFactory"));
                synchronized (clazz2) {
                    singleton = new RessourceFactory();
                }
            }
        }
        return singleton;
    }
}

