/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.models;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import pw.palmpatch.util.UUDecoder1;

public class Attachment
implements Cloneable {
    protected String encodedBytesAsString;
    protected String longName;
    protected String name;
    protected String sizeAsString;
    protected String CRC16;
    protected String infoText;

    public String getCRC16() {
        return this.CRC16;
    }

    public String getEncodedBytesAsString() {
        return this.encodedBytesAsString;
    }

    public String getInfoText() {
        return this.infoText;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getName() {
        return this.name;
    }

    public String getSizeAsString() {
        return this.sizeAsString;
    }

    public Attachment makeCopy() {
        try {
            return (Attachment)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setCRC16(String string) {
        this.CRC16 = string;
    }

    public void setEncodedBytesAsString(String string) {
        this.encodedBytesAsString = string;
    }

    public void setInfoText(String string) {
        this.infoText = string;
    }

    public void setLongName(String string) {
        this.longName = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSizeAsString(String string) {
        this.sizeAsString = string;
    }

    public String toString() {
        return "Attachment containing: " + this.name;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("anOutputStream must not be null");
        }
        StringReader stringReader = new StringReader(this.encodedBytesAsString);
        UUDecoder1.singleton().decode(stringReader, outputStream);
        try {
            ((Reader)stringReader).close();
        }
        catch (IOException iOException) {}
    }
}

