/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.models;

import java.util.StringTokenizer;
import pw.palmpatch.exceptions.InvalidChangeInfoFormatException;

public class ChangeInfo
implements Cloneable {
    protected long offsetInFile;
    protected int[] oldValues;
    protected int[] newValues;
    protected int crcCount;
    protected int crc;
    protected int startOfCrc;
    protected boolean hasError = false;
    protected String errorText;
    protected String changeInfoAsReadFromFile;

    public ChangeInfo() {
        this.crcCount = -1;
        this.crc = -1;
        this.startOfCrc = 0;
    }

    public ChangeInfo(long l, int[] nArray, int[] nArray2) {
        this.offsetInFile = l;
        this.oldValues = nArray;
        this.newValues = nArray2;
        this.crcCount = -1;
        this.crc = -1;
        this.startOfCrc = 0;
    }

    public ChangeInfo(long l, int[] nArray, int[] nArray2, int n, int n2) {
        this.offsetInFile = l;
        this.oldValues = nArray;
        this.newValues = nArray2;
        this.crcCount = n;
        this.crc = n2;
        this.startOfCrc = 0;
    }

    public ChangeInfo(long l, int[] nArray, int[] nArray2, int n, int n2, int n3) {
        this.offsetInFile = l;
        this.oldValues = nArray;
        this.newValues = nArray2;
        this.crcCount = n;
        this.crc = n2;
        this.startOfCrc = n3;
    }

    public String getChangeInfoAsReadFromFile() {
        return this.changeInfoAsReadFromFile;
    }

    public int getCrc() {
        return this.crc;
    }

    public int getCrcCount() {
        return this.crcCount;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public int[] getNewValues() {
        return this.newValues;
    }

    public long getOffsetInFile() {
        return this.offsetInFile;
    }

    public int[] getOldValues() {
        return this.oldValues;
    }

    public int getStartOfCrc() {
        return this.startOfCrc;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public ChangeInfo makeCopy() {
        try {
            return (ChangeInfo)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clonable but CloneNotSupportedException");
        }
    }

    public static ChangeInfo parse(String string) throws InvalidChangeInfoFormatException {
        return ChangeInfo.parse(string, new ChangeInfo());
    }

    public static ChangeInfo parse(String string, ChangeInfo changeInfo) throws InvalidChangeInfoFormatException {
        int n;
        if (string == null) {
            throw new IllegalArgumentException("changeInfoString must not be null");
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        string = string.trim();
        n2 = string.indexOf(" ") + 1;
        n3 = string.indexOf(" ", n2) + 1;
        if (n2 == 0) {
            throw new InvalidChangeInfoFormatException("No old bytes specified in:" + string);
        }
        if (n3 == 0) {
            throw new InvalidChangeInfoFormatException("No new bytes specified in:" + string);
        }
        String string2 = string.substring(n2, n3 - 1).trim();
        String string3 = string.substring(n3).trim();
        if (string2.length() != string3.length() && string2.length() != 1 && string3.length() != 1) {
            throw new InvalidChangeInfoFormatException("Number of old and new bytes does not match in: " + string);
        }
        try {
            n = Integer.parseInt(string.substring(0, n2 - 1), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidChangeInfoFormatException("Invalid offset in: " + string);
        }
        if (n < 0) {
            throw new InvalidChangeInfoFormatException("Invalid offset in: " + string);
        }
        n4 = string2.length() == 1 ? 1 : string2.length() / 2;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            try {
                nArray[n6] = string2.length() == 1 ? Integer.parseInt(string2.substring(n5, n5 + 1), 16) : Integer.parseInt(string2.substring(n5, n5 + 2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidChangeInfoFormatException("Invalid byte in old bytes in: " + string);
            }
            try {
                nArray2[n6] = string3.length() == 1 ? Integer.parseInt(string3.substring(n5, n5 + 1), 16) : Integer.parseInt(string3.substring(n5, n5 + 2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidChangeInfoFormatException("Invalid byte in new bytes in: " + string);
            }
            n5 += 2;
            ++n6;
        }
        changeInfo.setOffsetInFile(n++);
        changeInfo.setOldValues(nArray);
        changeInfo.setNewValues(nArray2);
        return changeInfo;
    }

    public static ChangeInfo parseComplete(String string) throws InvalidChangeInfoFormatException {
        if (string == null) {
            throw new IllegalArgumentException("completeChangeInfoString must not be null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        ChangeInfo changeInfo = new ChangeInfo();
        if (n == 3) {
            ChangeInfo.parse(string, changeInfo);
        } else if (n == 5) {
            int n2;
            int n3 = string.indexOf(" ") + 1;
            int n4 = string.indexOf(" ", n3);
            String string2 = string.substring(0, n3 - 1).trim();
            String string3 = string.substring(n3, n4).trim();
            try {
                n2 = Integer.parseInt(string2);
                if (n2 < 0) {
                    throw new InvalidChangeInfoFormatException("crc is not allowed to be negative in: " + string);
                }
                changeInfo.setCrc(n2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidChangeInfoFormatException("crc is not a valid number in: " + string);
            }
            try {
                n2 = Integer.parseInt(string3);
                if (n2 < 1) {
                    throw new InvalidChangeInfoFormatException("crcCount must be greater than 0 in: " + string);
                }
                changeInfo.setCrcCount(n2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidChangeInfoFormatException("crcCount is not a valid number in: " + string);
            }
            ChangeInfo.parse(string.substring(n4 + 1), changeInfo);
        } else if (n == 6) {
            int n5;
            int n6 = string.indexOf(" ") + 1;
            int n7 = string.indexOf(" ", n6);
            int n8 = string.indexOf(" ", n6);
            int n9 = string.indexOf(" ", n8);
            String string4 = string.substring(0, n6 - 1).trim();
            String string5 = string.substring(n6, n7).trim();
            String string6 = string.substring(n8, n9).trim();
            try {
                n5 = Integer.parseInt(string4);
                if (n5 < 0) {
                    throw new InvalidChangeInfoFormatException("crc is not allowed to be negative in: " + string);
                }
                changeInfo.setCrc(n5);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidChangeInfoFormatException("crc is not a valid number in: " + string);
            }
            try {
                n5 = Integer.parseInt(string5);
                if (n5 < 1) {
                    throw new InvalidChangeInfoFormatException("crcCount must be greater than 0 in: " + string);
                }
                changeInfo.setCrcCount(n5);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidChangeInfoFormatException("crcCount is not a valid number in: " + string);
            }
            try {
                n5 = Integer.parseInt(string6);
                if (n5 == 0) {
                    throw new InvalidChangeInfoFormatException("crcStart must not be 0 in: " + string);
                }
                changeInfo.setStartOfCrc(n5);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidChangeInfoFormatException("crcStart is not a valid number in: " + string);
            }
            ChangeInfo.parse(string.substring(n7 + 1), changeInfo);
        } else {
            throw new InvalidChangeInfoFormatException("ChangeInfo must either contain 3 or 5 elements instead of " + n + " as in: " + string);
        }
        return changeInfo;
    }

    public void setChangeInfoAsReadFromFile(String string) {
        this.changeInfoAsReadFromFile = string;
    }

    public void setCrc(int n) {
        this.crc = n;
    }

    public void setCrcCount(int n) {
        this.crcCount = n;
    }

    public void setErrorText(String string) {
        this.errorText = string;
    }

    public void setHasError(boolean bl) {
        this.hasError = bl;
    }

    public void setNewValues(int[] nArray) {
        this.newValues = nArray;
    }

    public void setOffsetInFile(long l) {
        this.offsetInFile = l;
    }

    public void setOldValues(int[] nArray) {
        this.oldValues = nArray;
    }

    public void setStartOfCrc(int n) {
        this.startOfCrc = n;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.crc != -1 && this.crcCount != -1) {
            stringBuffer.append(this.crc);
            stringBuffer.append(" ");
            stringBuffer.append(this.crcCount);
            stringBuffer.append(" ");
        }
        if (this.startOfCrc != 0) {
            stringBuffer.append(this.startOfCrc);
            stringBuffer.append(" ");
        }
        stringBuffer.append(Long.toHexString(this.offsetInFile).toUpperCase());
        stringBuffer.append(" ");
        String string = null;
        if (this.oldValues == null) {
            stringBuffer.append("NA");
        } else {
            n = 0;
            while (n < this.oldValues.length) {
                string = Integer.toHexString(this.oldValues[n]).toUpperCase();
                if (string.length() == 1) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string);
                ++n;
            }
        }
        stringBuffer.append(" ");
        if (this.newValues == null) {
            stringBuffer.append("NA");
        } else {
            n = 0;
            while (n < this.newValues.length) {
                string = Integer.toHexString(this.newValues[n]).toUpperCase();
                if (string.length() == 1) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string);
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

