/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.models;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import pw.palmpatch.controller.TargetViewAndEditController;
import pw.palmpatch.io.GenericFile;
import pw.palmpatch.io.palmfiles.PRCDatabase;
import pw.palmpatch.io.palmfiles.PalmDatabase;
import pw.palmpatch.models.ChangeInfo;

public class FileInfo
implements Cloneable {
    protected String longName;
    protected String name;
    protected String size;
    protected String id;
    protected String version;
    protected String crc16;
    protected String infoText;
    protected List changes;
    protected boolean hasError = false;
    protected File associatedTargetFile;
    protected File sourceFile;
    protected int patchStatus = 0;
    protected PropertyChangeSupport propertyChange;
    protected int possibleWayToPatch;
    public static final int TARGET_FILE_HAS_NOT_BEEN_PATCHED_YET = 0;
    public static final int TARGET_FILE_HAS_NOT_BEEN_PATCHED_SUCCESSFULL = 1;
    public static final int TARGET_FILE_HAS_BEEN_PATCHED_SUCCESSFULL = 2;

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChange().addPropertyChangeListener(propertyChangeListener);
    }

    public boolean doesCRC16Match() {
        if (this.associatedTargetFile != null && this.associatedTargetFile instanceof GenericFile) {
            String string = ((GenericFile)this.associatedTargetFile).getCRC16();
            return string != null ? string.equalsIgnoreCase(this.crc16) : false;
        }
        return false;
    }

    public boolean doesIDMatch() {
        if (this.associatedTargetFile != null && this.associatedTargetFile instanceof PalmDatabase) {
            String string = ((PalmDatabase)this.associatedTargetFile).getDatabaseName();
            return string != null ? string.equalsIgnoreCase(this.id) : false;
        }
        return false;
    }

    public boolean doesNameMatch() {
        if (this.associatedTargetFile != null) {
            String string = this.associatedTargetFile.getName();
            return string != null ? string.equalsIgnoreCase(this.name) : false;
        }
        return false;
    }

    public boolean doesSizeMatch() {
        if (this.associatedTargetFile != null) {
            long l = this.associatedTargetFile.length();
            return String.valueOf(l).equalsIgnoreCase(this.size);
        }
        return false;
    }

    public boolean doesVersionMatch() {
        if (this.associatedTargetFile != null && this.associatedTargetFile instanceof PRCDatabase) {
            String string = ((PRCDatabase)this.associatedTargetFile).getVersion();
            return string != null ? string.equalsIgnoreCase(this.version) : false;
        }
        return false;
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChange().firePropertyChange(string, object, object2);
    }

    public File getAssociatedTargetFile() {
        return this.associatedTargetFile;
    }

    public String getCRC16() {
        return this.crc16;
    }

    public List getChanges() {
        return this.changes;
    }

    public String getId() {
        return this.id;
    }

    public String getInfoText() {
        return this.infoText;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getName() {
        return this.name;
    }

    public int getPatchStatus() {
        return this.patchStatus;
    }

    public int getPossibleWayToPatch() {
        return this.possibleWayToPatch;
    }

    protected PropertyChangeSupport getPropertyChange() {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        return this.propertyChange;
    }

    public String getSize() {
        return this.size;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public boolean isPatchingPossible() {
        return this.possibleWayToPatch != TargetViewAndEditController.PATCHING_IMPOSSIBLE;
    }

    public FileInfo makeCopy() {
        try {
            FileInfo fileInfo = (FileInfo)this.clone();
            if (this.changes != null) {
                Iterator iterator = this.getChanges().iterator();
                ArrayList arrayList = new ArrayList(this.getChanges().size());
                while (iterator.hasNext()) {
                    arrayList.add((Object)((ChangeInfo)iterator.next()).makeCopy());
                }
                fileInfo.setChanges((List)arrayList);
            }
            return fileInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Cloneable but CloneNotSupportedException is thrown");
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChange().removePropertyChangeListener(propertyChangeListener);
    }

    public void setAssociatedTargetFile(File file) {
        this.associatedTargetFile = file;
        this.setPatchStatus(0);
    }

    public void setCRC16(String string) {
        this.crc16 = string;
    }

    public void setChanges(List list) {
        this.changes = list;
    }

    public void setHasError(boolean bl) {
        this.hasError = bl;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setInfoText(String string) {
        this.infoText = string;
    }

    public void setLongName(String string) {
        this.longName = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPatchStatus(int n) {
        if (n != 2 && n != 1 && n != 0) {
            throw new IllegalArgumentException(String.valueOf(n) + " is not a valid value for newPatchStatus.");
        }
        int n2 = this.patchStatus;
        this.patchStatus = n;
        this.firePropertyChange("patchStatus", new Integer(n2), new Integer(this.patchStatus));
    }

    public void setPossibleWayToPatch(int n) {
        int n2 = this.possibleWayToPatch;
        this.possibleWayToPatch = n;
        this.firePropertyChange("possibleWayToPatch", new Integer(n2), new Integer(this.possibleWayToPatch));
    }

    public void setSize(String string) {
        this.size = string;
    }

    public void setSourceFile(File file) {
        this.sourceFile = file;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String toString() {
        return "FileInfo for file: " + this.name;
    }
}

