/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.models;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.text.Collator;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import pw.palmpatch.Application;
import pw.palmpatch.events.ModelEvent;
import pw.palmpatch.io.ProgressIndicatorInputStream;
import pw.palmpatch.models.Attachment;
import pw.palmpatch.models.ChangeInfo;
import pw.palmpatch.models.FileInfo;
import pw.palmpatch.models.Model;
import pw.palmpatch.models.TargetInfo;
import pw.palmpatch.models.TargetInfoDuplicatesRemoverModel;
import pw.palmpatch.models.TargetListInfo;
import pw.palmpatch.parser.PWCPPContentHandler;
import pw.palmpatch.parser.PWErrorHandler;
import pw.palmpatch.ui.widgets.ProgressIndicator;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.Hex;
import pw.palmpatch.util.InfoMessage;
import pw.palmpatch.util.Log;

public class PatcherMainModel
extends Model {
    protected List targetInfos = new LinkedList();
    protected TargetListInfo targeListInfo = new TargetListInfo();
    static /* synthetic */ Class class$pw$palmpatch$models$PatcherMainModel;

    public void addTargetInfo(TargetInfo targetInfo) {
        this.targetInfos.add((Object)targetInfo);
        this.fireModelEvent(new ModelEvent(this));
    }

    public void addTargetInfos(List list) {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TargetInfo targetInfo = (TargetInfo)iterator.next();
            this.addTargetInfo(targetInfo);
            this.targeListInfo.addEntryForNewTargetInfo(targetInfo);
        }
    }

    public void addTargetInfos(TargetInfoDuplicatesRemoverModel targetInfoDuplicatesRemoverModel, List list) {
        list.removeAll((Collection)targetInfoDuplicatesRemoverModel.getNewTargetInfosToDelete());
        this.targetInfos.removeAll((Collection)targetInfoDuplicatesRemoverModel.getExistingTargetInfosToDelete());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TargetInfo targetInfo = (TargetInfo)iterator.next();
            this.addTargetInfo(targetInfo);
            this.targeListInfo.addEntryForNewTargetInfo(targetInfo);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public List findAlike(TargetInfo targetInfo) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.targetInfos.size()) {
            TargetInfo targetInfo2 = (TargetInfo)this.targetInfos.get(n);
            if (targetInfo2.isAlike(targetInfo)) {
                arrayList.add((Object)targetInfo2);
            }
            ++n;
        }
        return arrayList;
    }

    public TargetInfoDuplicatesRemoverModel findDuplicates(List list, ProgressIndicator progressIndicator) {
        Iterator iterator = list.iterator();
        TargetInfo targetInfo = null;
        TargetInfo targetInfo2 = null;
        TargetInfoDuplicatesRemoverModel targetInfoDuplicatesRemoverModel = new TargetInfoDuplicatesRemoverModel();
        int n = 0;
        progressIndicator.use("Looking for duplicates", 0, list.size());
        while (iterator.hasNext()) {
            progressIndicator.setProgress(++n);
            if (n % 200 == 0) {
                System.gc();
            }
            targetInfo = (TargetInfo)iterator.next();
            ArrayList arrayList = new ArrayList();
            Iterator iterator2 = this.targetInfos.iterator();
            while (iterator2.hasNext()) {
                targetInfo2 = (TargetInfo)iterator2.next();
                if (!targetInfo.isAlike(targetInfo2)) continue;
                arrayList.add((Object)targetInfo2);
            }
            if (arrayList.isEmpty()) continue;
            targetInfoDuplicatesRemoverModel.addDuplicates(targetInfo, (List)arrayList);
        }
        progressIndicator.cancel();
        progressIndicator.reset();
        System.gc();
        return targetInfoDuplicatesRemoverModel;
    }

    protected Comparator getSortingComparator(int n) {
        Object object = null;
        final Locale locale = new Locale("en", "US");
        switch (n) {
            case 1: {
                object = new Comparator(){

                    public int compare(Object object, Object object2) {
                        Collator collator = Collator.getInstance(locale);
                        return collator.compare(((TargetInfo)object).getLongName(), ((TargetInfo)object2).getLongName());
                    }
                };
                break;
            }
            case 2: {
                object = new Comparator(){

                    public int compare(Object object, Object object2) {
                        Collator collator = Collator.getInstance(locale);
                        return collator.compare(((TargetInfo)object2).getLongName(), ((TargetInfo)object).getLongName());
                    }
                };
                break;
            }
            case 3: {
                object = new Comparator(){

                    public int compare(Object object, Object object2) {
                        Collator collator = Collator.getInstance(locale);
                        return collator.compare(((TargetInfo)object).getCredits(), ((TargetInfo)object2).getCredits());
                    }
                };
                break;
            }
            case 4: {
                object = new Comparator(){

                    public int compare(Object object, Object object2) {
                        Collator collator = Collator.getInstance(locale);
                        return collator.compare(((TargetInfo)object2).getCredits(), ((TargetInfo)object).getCredits());
                    }
                };
                break;
            }
            case 5: {
                object = new Comparator(){

                    public int compare(Object object, Object object2) {
                        Collator collator = Collator.getInstance(locale);
                        return collator.compare(((TargetInfo)object).getUrl(), ((TargetInfo)object2).getUrl());
                    }
                };
                break;
            }
            case 6: {
                object = new Comparator(){

                    public int compare(Object object, Object object2) {
                        Collator collator = Collator.getInstance(locale);
                        return collator.compare(((TargetInfo)object2).getUrl(), ((TargetInfo)object).getUrl());
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal sort order");
            }
        }
        return object;
    }

    public List getTargetInfos() {
        return this.targetInfos;
    }

    public TargetListInfo getTargetListInfo() {
        return this.targeListInfo;
    }

    public void loadAndParse(File file, ProgressIndicator progressIndicator) throws InterruptedIOException {
        if (!file.exists()) {
            throw new IllegalArgumentException(String.valueOf(file.getAbsolutePath()) + " does not exist!");
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            File file2 = null;
            int n = 0;
            while (n < stringArray.length) {
                file2 = new File(String.valueOf(file.getAbsolutePath()) + System.getProperty("file.separator") + stringArray[n]);
                if (!file2.isDirectory()) {
                    this.loadAndParseFile(file2, progressIndicator);
                }
                ++n;
            }
        } else {
            this.loadAndParseFile(new File(file.getAbsolutePath()), progressIndicator);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List loadAndParse(String string) throws SAXException, SAXParseException, IOException, ParserConfigurationException {
        List list;
        StringBufferInputStream stringBufferInputStream = null;
        try {
            List list2;
            stringBufferInputStream = new StringBufferInputStream(string);
            InputSource inputSource = new InputSource(stringBufferInputStream);
            PWCPPContentHandler pWCPPContentHandler = new PWCPPContentHandler(inputSource);
            this.loadAndParse(inputSource, pWCPPContentHandler);
            list = list2 = pWCPPContentHandler.getParsedTargetInfos();
            Object var5_7 = null;
            if (stringBufferInputStream == null) return list;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (stringBufferInputStream == null) throw throwable;
            try {
                stringBufferInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stringBufferInputStream.close();
            return list;
        }
        catch (IOException iOException) {}
        return list;
    }

    protected void loadAndParse(InputSource inputSource, ContentHandler contentHandler) throws SAXException, IOException, ParserConfigurationException {
        System.gc();
        String string = Application.singleton().getPreferences().getString("SAXParserFactoryImpl");
        if (string != null && !string.equals("")) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", string);
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setFeature("http://xml.org/sax/features/validation", true);
        sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        Log.singleton().logNewMessage(new InfoMessage("Using Parser: " + sAXParser.getClass().getName()));
        sAXParser.getXMLReader().setContentHandler(contentHandler);
        sAXParser.getXMLReader().setErrorHandler(new PWErrorHandler(inputSource));
        URL uRL = (class$pw$palmpatch$models$PatcherMainModel != null ? class$pw$palmpatch$models$PatcherMainModel : (class$pw$palmpatch$models$PatcherMainModel = PatcherMainModel.class$("pw.palmpatch.models.PatcherMainModel"))).getResource("palmpass.dtd");
        if (uRL != null) {
            inputSource.setSystemId(uRL.toString());
            Log.singleton().logNewMessage(new InfoMessage("Using DTD : " + uRL.toString()));
        }
        long l = System.currentTimeMillis();
        sAXParser.getXMLReader().parse(inputSource);
        Log.singleton().logNewMessage(new InfoMessage("Parsing of XML took " + (System.currentTimeMillis() - l) + " ms"));
    }

    protected void loadAndParseFile(File file, ProgressIndicator progressIndicator) throws InterruptedIOException {
        ProgressIndicatorInputStream progressIndicatorInputStream = null;
        String string = System.getProperty("line.separator");
        try {
            try {
                if (file.isFile() && file.getCanonicalPath().toUpperCase().endsWith("XML")) {
                    Log.singleton().logNewMessage(new InfoMessage("Opening target list file " + file));
                    progressIndicator.use("Parsing " + file.getName(), 0, (int)file.length());
                    progressIndicatorInputStream = new ProgressIndicatorInputStream(new BufferedInputStream(new FileInputStream(file)), progressIndicator);
                    InputSource inputSource = new InputSource(progressIndicatorInputStream);
                    PWCPPContentHandler pWCPPContentHandler = new PWCPPContentHandler(inputSource);
                    this.loadAndParse(inputSource, pWCPPContentHandler);
                    this.setTargetListInfo(pWCPPContentHandler.getParsedTargetListInfo());
                    this.setTargetInfos(pWCPPContentHandler.getParsedTargetInfos());
                    Log.singleton().logNewMessage(new InfoMessage("Finished loading file: " + file.getAbsolutePath(), true));
                } else if (file.isFile() && file.getCanonicalPath().toUpperCase().endsWith("ZIP")) {
                    Log.singleton().logNewMessage(new InfoMessage("Opening zip file " + file));
                    this.parseZipFileContents(file, progressIndicator);
                } else {
                    Log.singleton().logNewMessage(new InfoMessage("File type of file: " + file + " not supported", true));
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("An IOException occurred while reading the file ");
                stringBuffer.append(file);
                stringBuffer.append(string);
                stringBuffer.append(iOException);
                stringBuffer.append(string);
                Log.singleton().logNewMessage(new ErrorMessage(stringBuffer.toString()));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("A ParserConfigurationException occurred while reading the file ");
                stringBuffer.append(file);
                stringBuffer.append(string);
                stringBuffer.append(parserConfigurationException);
                stringBuffer.append(string);
                Log.singleton().logNewMessage(new ErrorMessage(stringBuffer.toString()));
            }
            catch (SAXParseException sAXParseException) {
                if (sAXParseException.getException() instanceof InterruptedIOException) {
                    throw (InterruptedIOException)sAXParseException.getException();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("A SAXParseException occurred!");
                stringBuffer.append(string);
                stringBuffer.append("The error is located at ");
                stringBuffer.append("line: ");
                stringBuffer.append(sAXParseException.getLineNumber());
                int n = sAXParseException.getColumnNumber();
                if (n > 0) {
                    stringBuffer.append(" column: ");
                    stringBuffer.append(n);
                }
                stringBuffer.append(string);
                stringBuffer.append("The error message is: ");
                stringBuffer.append(sAXParseException.getMessage());
                stringBuffer.append(string);
                Log.singleton().logNewMessage(new ErrorMessage(stringBuffer.toString()));
            }
            catch (SAXException sAXException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("A SAXException occurred!");
                stringBuffer.append(string);
                stringBuffer.append(sAXException);
                stringBuffer.append(sAXException.getException());
                sAXException.printStackTrace();
                stringBuffer.append(string);
                Log.singleton().logNewMessage(new ErrorMessage(stringBuffer.toString()));
            }
            Object var6_17 = null;
        }
        catch (Throwable throwable) {
            Object var6_18 = null;
            try {
                if (progressIndicatorInputStream != null) {
                    progressIndicatorInputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (progressIndicatorInputStream != null) {
                progressIndicatorInputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseZipFileContents(File file, ProgressIndicator progressIndicator) throws SAXException, IOException, ParserConfigurationException {
        ZipInputStream zipInputStream = null;
        ProgressIndicatorInputStream progressIndicatorInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (!zipEntry.getName().endsWith("/")) {
                    if (!zipEntry.getName().toUpperCase().endsWith("XML")) {
                        Log.singleton().logNewMessage(new InfoMessage("Skipping zip entry " + zipEntry));
                    } else {
                        Log.singleton().logNewMessage(new InfoMessage("Processing zip entry " + zipEntry));
                        progressIndicator.use("Parsing " + zipEntry.getName(), 0, zipInputStream.available());
                        progressIndicatorInputStream = new ProgressIndicatorInputStream(zipInputStream, progressIndicator);
                        if (zipEntry.getSize() > 0L) {
                            progressIndicator.setMax((int)zipEntry.getSize());
                        }
                        InputSource inputSource = new InputSource(progressIndicatorInputStream);
                        PWCPPContentHandler pWCPPContentHandler = new PWCPPContentHandler(inputSource);
                        this.loadAndParse(inputSource, pWCPPContentHandler);
                        this.setTargetListInfo(pWCPPContentHandler.getParsedTargetListInfo());
                        this.setTargetInfos(pWCPPContentHandler.getParsedTargetInfos());
                    }
                }
                try {
                    zipEntry = zipInputStream.getNextEntry();
                }
                catch (IOException iOException) {
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (progressIndicatorInputStream != null) {
                    progressIndicatorInputStream.close();
                }
                if (zipInputStream == null) throw throwable;
                zipInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var6_8 = null;
        try {}
        catch (IOException iOException) {
            return;
        }
        if (progressIndicatorInputStream != null) {
            progressIndicatorInputStream.close();
        }
        if (zipInputStream == null) return;
        zipInputStream.close();
    }

    public void removeTargetInfos(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.targeListInfo.addEntryForRemovedTargetInfo((TargetInfo)this.targetInfos.get(nArray[n] - n));
            this.targetInfos.remove(nArray[n] - n);
            ++n;
        }
        System.gc();
        this.fireModelEvent(new ModelEvent(this));
    }

    public void saveTo(OutputStream outputStream, String string, boolean bl) throws IOException, SAXException {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream must not be null");
        }
        int[] nArray = new int[this.targetInfos.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = n;
            ++n;
        }
        this.saveTo(outputStream, string, nArray, bl);
    }

    public void saveTo(OutputStream outputStream, String string, int[] nArray, boolean bl) throws IOException, SAXException {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream must not be null");
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            Object object;
            bufferedOutputStream = new BufferedOutputStream(outputStream);
            OutputFormat outputFormat = new OutputFormat("xml", string, true);
            outputFormat.setLineWidth(50);
            outputFormat.setIndent(1);
            XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)bufferedOutputStream, outputFormat);
            AttributesImpl attributesImpl = new AttributesImpl();
            xMLSerializer.startDocument();
            xMLSerializer.startDTD(null, null, "palmpass.dtd");
            if (this.targeListInfo == null) {
                this.targeListInfo = new TargetListInfo();
            }
            attributesImpl.addAttribute("", "", "VERSION", "", "2");
            attributesImpl.addAttribute("", "", "DATE", "", this.targeListInfo.getDate());
            attributesImpl.addAttribute("", "", "CREDITS", "", this.targeListInfo.getCredits());
            xMLSerializer.startElement(null, null, "PW_DATA", (Attributes)attributesImpl);
            xMLSerializer.startPreserving();
            xMLSerializer.startElement("INFOTEXT", null);
            if (bl) {
                object = this.targeListInfo.getInfoText().toCharArray();
                xMLSerializer.characters((char[])object, 0, ((char[])object).length);
            }
            xMLSerializer.endElement("INFOTEXT");
            xMLSerializer.endPreserving();
            xMLSerializer.startPreserving();
            xMLSerializer.startElement("UPDATES", null);
            if (bl) {
                object = this.targeListInfo.getUpdatesText().toCharArray();
                xMLSerializer.characters((char[])object, 0, ((char[])object).length);
            }
            xMLSerializer.endElement("UPDATES");
            xMLSerializer.endPreserving();
            object = null;
            FileInfo fileInfo = null;
            Attachment attachment = null;
            ChangeInfo changeInfo = null;
            List list = null;
            List list2 = null;
            List list3 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int[] nArray2 = null;
            int[] nArray3 = null;
            int n4 = 0;
            int n5 = 0;
            while (n5 < nArray.length) {
                Object object2;
                int n6;
                n4 = nArray[n5];
                object = (TargetInfo)this.targetInfos.get(n4);
                attributesImpl.clear();
                attributesImpl.addAttribute("", "", "URL", "", ((TargetInfo)object).getUrl());
                attributesImpl.addAttribute("", "", "LONGNAME", "", ((TargetInfo)object).getLongName());
                attributesImpl.addAttribute("", "", "CREDITS", "", ((TargetInfo)object).getCredits());
                attributesImpl.addAttribute("", "", "TEXT", "", ((TargetInfo)object).getText());
                xMLSerializer.startElement("", "", "TARGET", (Attributes)attributesImpl);
                list = ((TargetInfo)object).getFilesInfos();
                n = 0;
                if (list != null) {
                    n = list.size();
                }
                int n7 = 0;
                while (n7 < n) {
                    fileInfo = (FileInfo)list.get(n7);
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "", "LONGNAME", "", fileInfo.getLongName());
                    attributesImpl.addAttribute("", "", "NAME", "", fileInfo.getName());
                    attributesImpl.addAttribute("", "", "SIZE", "", fileInfo.getSize());
                    attributesImpl.addAttribute("", "", "ID", "", fileInfo.getId());
                    attributesImpl.addAttribute("", "", "VER", "", fileInfo.getVersion());
                    attributesImpl.addAttribute("", "", "CRC16", "", fileInfo.getCRC16());
                    attributesImpl.addAttribute("", "", "TEXT", "", fileInfo.getInfoText());
                    xMLSerializer.startElement("", "", "FILE", (Attributes)attributesImpl);
                    list3 = fileInfo.getChanges();
                    n3 = 0;
                    if (list3 != null) {
                        n3 = list3.size();
                    }
                    n6 = 0;
                    while (n6 < n3) {
                        changeInfo = (ChangeInfo)list3.get(n6);
                        attributesImpl.clear();
                        object2 = Integer.toString(changeInfo.getCrc());
                        String string2 = Integer.toString(changeInfo.getCrcCount());
                        String string3 = Integer.toString(changeInfo.getStartOfCrc());
                        if (((String)object2).equals("-1")) {
                            object2 = "";
                        }
                        if (string2.equals("-1")) {
                            string2 = "";
                        }
                        attributesImpl.addAttribute("", "", "PRECRC", "", (String)object2);
                        attributesImpl.addAttribute("", "", "UCNT", "", string2);
                        attributesImpl.addAttribute("", "", "START", "", string3);
                        xMLSerializer.startPreserving();
                        xMLSerializer.startElement("", "", "CHANGE", (Attributes)attributesImpl);
                        if (!changeInfo.hasError) {
                            int n8 = changeInfo.getOldValues().length;
                            StringBuffer stringBuffer = new StringBuffer();
                            StringBuffer stringBuffer2 = new StringBuffer();
                            nArray2 = changeInfo.getOldValues();
                            nArray3 = changeInfo.getNewValues();
                            int n9 = 0;
                            while (n9 < n8) {
                                stringBuffer.append(Hex.toHexString(nArray2[n9]));
                                stringBuffer2.append(Hex.toHexString(nArray3[n9]));
                                ++n9;
                            }
                            char[] cArray = new String(String.valueOf(Hex.toHexString(changeInfo.getOffsetInFile())) + " " + stringBuffer.toString() + " " + stringBuffer2.toString()).toUpperCase().toCharArray();
                            xMLSerializer.characters(cArray, 0, cArray.length);
                        } else {
                            char[] cArray = changeInfo.getChangeInfoAsReadFromFile().toCharArray();
                            xMLSerializer.characters(cArray, 0, cArray.length);
                        }
                        xMLSerializer.endElement("CHANGE");
                        xMLSerializer.endPreserving();
                        ++n6;
                    }
                    xMLSerializer.endElement("FILE");
                    ++n7;
                }
                list2 = ((TargetInfo)object).getAttachments();
                n2 = 0;
                if (list2 != null) {
                    n2 = list2.size();
                }
                n6 = 0;
                while (n6 < n2) {
                    attachment = (Attachment)list2.get(n6);
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "", "LONGNAME", "", attachment.getLongName());
                    attributesImpl.addAttribute("", "", "NAME", "", attachment.getName());
                    attributesImpl.addAttribute("", "", "SIZE", "", attachment.getSizeAsString());
                    attributesImpl.addAttribute("", "", "CRC16", "", attachment.getCRC16());
                    attributesImpl.addAttribute("", "", "TEXT", "", attachment.getInfoText());
                    xMLSerializer.startPreserving();
                    xMLSerializer.startElement("", "", "ATTACH", (Attributes)attributesImpl);
                    object2 = attachment.getEncodedBytesAsString().toCharArray();
                    xMLSerializer.characters((char[])object2, 0, ((char[])object2).length);
                    xMLSerializer.endElement("ATTACH");
                    xMLSerializer.endPreserving();
                    ++n6;
                }
                xMLSerializer.endElement("TARGET");
                ++n5;
            }
            xMLSerializer.endElement("PW_DATA");
            xMLSerializer.endDocument();
        }
        finally {
            Object var7_34 = null;
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
        }
    }

    public void saveToFile(File file, String string) throws IOException, SAXException {
        String string2 = file.getName();
        if (string2.toUpperCase().endsWith(".ZIP")) {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            zipOutputStream.putNextEntry(new ZipEntry(String.valueOf(string2.substring(0, string2.length() - 3)) + "xml"));
            this.saveTo(zipOutputStream, string, true);
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.saveTo(fileOutputStream, string, true);
        }
    }

    public void setTargetInfos(List list) {
        this.targetInfos.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.targetInfos.add(iterator.next());
        }
    }

    public void setTargetListInfo(TargetListInfo targetListInfo) {
        this.targeListInfo = targetListInfo;
    }

    public void sort(int n) {
        Collections.sort((List)this.targetInfos, (Comparator)this.getSortingComparator(n));
        this.fireModelEvent(new ModelEvent(this));
    }

    public static interface SortingConstants {
        public static final int SORT_BY_LONG_NAME_ASCENDING = 1;
        public static final int SORT_BY_LONG_NAME_DESCENDING = 2;
        public static final int SORT_BY_CREDITS_ASCENDING = 3;
        public static final int SORT_BY_CREDITS_DESCENDING = 4;
        public static final int SORT_BY_URL_ASCENDING = 5;
        public static final int SORT_BY_URL_DESCENDING = 6;
    }
}

