/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.models;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import pw.palmpatch.PreferenceNode;
import pw.palmpatch.Preferences;
import pw.palmpatch.events.PreferenceNodesChangedEvent;
import pw.palmpatch.models.Model;

public class PreferencesControllerModel
extends Model {
    private PreferenceNode[] rootPreferenceNodes;
    private Preferences preferences;
    private DefaultTreeModel modelForPreferenceNodeTree;

    private void buildModelForPreferenceNodeTree() throws IllegalStateException {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        int n = this.rootPreferenceNodes.length - 1;
        while (n >= 0) {
            this.descendIntoChildPreferenceNode(this.rootPreferenceNodes[n], defaultMutableTreeNode, defaultTreeModel);
            --n;
        }
        this.modelForPreferenceNodeTree = defaultTreeModel;
    }

    private void descendIntoChildPreferenceNode(PreferenceNode preferenceNode, DefaultMutableTreeNode defaultMutableTreeNode, DefaultTreeModel defaultTreeModel) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
        defaultMutableTreeNode2.setUserObject(preferenceNode);
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, 0);
        if (preferenceNode.hasChildren()) {
            List list = preferenceNode.getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.descendIntoChildPreferenceNode((PreferenceNode)iterator.next(), defaultMutableTreeNode2, defaultTreeModel);
            }
        }
    }

    public List getAllPreferenceNodes() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.modelForPreferenceNodeTree.getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        ArrayList arrayList = new ArrayList();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            arrayList.add(defaultMutableTreeNode2.getUserObject());
        }
        arrayList.remove(arrayList.size() - 1);
        return arrayList;
    }

    public DefaultTreeModel getModelForPreferenceNodeTree() {
        return this.modelForPreferenceNodeTree;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public PreferenceNode[] getRootPreferenceNodes() {
        return this.rootPreferenceNodes;
    }

    public void setModelForPreferenceNodeTree(DefaultTreeModel defaultTreeModel) {
        this.modelForPreferenceNodeTree = defaultTreeModel;
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public void setRootPreferenceNodes(PreferenceNode[] preferenceNodeArray) {
        this.rootPreferenceNodes = preferenceNodeArray;
        this.buildModelForPreferenceNodeTree();
        PreferenceNodesChangedEvent preferenceNodesChangedEvent = new PreferenceNodesChangedEvent(this);
        this.fireModelEvent(preferenceNodesChangedEvent);
    }
}

