/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.models;

import com.sun.java.util.collections.List;
import javax.swing.table.AbstractTableModel;
import pw.palmpatch.models.Attachment;
import pw.palmpatch.models.TargetInfo;

public class TargetInfoToAttachmentsTableModelAdapter
extends AbstractTableModel {
    private TargetInfo myTargetInfo;
    private List cachedAttachments;
    private String[] columnNames = new String[]{"Long Name", "Name", "Size", "CRC16", "Text"};

    TargetInfoToAttachmentsTableModelAdapter() {
    }

    public TargetInfoToAttachmentsTableModelAdapter(TargetInfo targetInfo) {
        this.setTargetInfo(targetInfo);
    }

    public Attachment getAttachmentAt(int n) {
        if (this.myTargetInfo != null) {
            return this.myTargetInfo.getAttachmentAt(n);
        }
        return null;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (n < 0 && n > this.columnNames.length) {
            throw new IllegalArgumentException("column: " + n + " is out of range");
        }
        return this.columnNames[n];
    }

    public int getRowCount() {
        if (this.cachedAttachments != null) {
            return this.cachedAttachments.size();
        }
        return 0;
    }

    public TargetInfo getTargetInfo() {
        return this.myTargetInfo;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 < 0 && n2 > this.columnNames.length) {
            throw new IllegalArgumentException("columnIndex: " + n2 + " is out of range");
        }
        if (n < 0 && n > this.getRowCount()) {
            throw new IllegalArgumentException("rowIndex: " + n + " is out of range");
        }
        Attachment attachment = (Attachment)this.cachedAttachments.get(n);
        switch (n2) {
            case 0: {
                return attachment.getLongName();
            }
            case 1: {
                return attachment.getName();
            }
            case 2: {
                return attachment.getSizeAsString();
            }
            case 3: {
                return attachment.getCRC16();
            }
            case 4: {
                return attachment.getInfoText();
            }
        }
        return new RuntimeException("Execution should never reach this point in getValueAt in: " + this.getClass());
    }

    public void setTargetInfo(TargetInfo targetInfo) {
        this.myTargetInfo = targetInfo;
        this.cachedAttachments = this.myTargetInfo != null ? targetInfo.getAttachments() : null;
        this.fireTableDataChanged();
    }
}

