/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.patchengine;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class CRC16Support {
    protected int[] table;
    private int currentByte;

    public CRC16Support() {
        int[] nArray = new int[16];
        nArray[1] = 52225;
        nArray[2] = 55297;
        nArray[3] = 5120;
        nArray[4] = 61441;
        nArray[5] = 15360;
        nArray[6] = 10240;
        nArray[7] = 58369;
        nArray[8] = 40961;
        nArray[9] = 27648;
        nArray[10] = 30720;
        nArray[11] = 46081;
        nArray[12] = 20480;
        nArray[13] = 39937;
        nArray[14] = 34817;
        nArray[15] = 17408;
        this.table = nArray;
        this.currentByte = 0;
    }

    public int calculateCRC16For(File file) throws FileNotFoundException, IOException {
        return this.calculateCRC16For(new FileInputStream(file));
    }

    private int calculateCRC16For(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            while ((n3 = bufferedInputStream.read()) != -1) {
                n = this.table[n2 & 0xF];
                n2 = n2 / 16 & 0xFFF;
                n2 = n2 ^ n ^ this.table[n3 & 0xF];
                n = this.table[n2 & 0xF];
                n2 = n2 / 16 & 0xFFF;
                n2 = n2 ^ n ^ this.table[n3 / 16 & 0xF];
            }
        }
        finally {
            Object var7_6 = null;
            bufferedInputStream.close();
        }
        return n2;
    }

    public int calculateCRC16For(byte[] byArray) throws IOException {
        return this.calculateCRC16For(new ByteArrayInputStream(byArray));
    }
}

