/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.io.File;

public class FileFilter
extends javax.swing.filechooser.FileFilter {
    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";
    private Map filters = new HashMap();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public FileFilter() {
    }

    public FileFilter(String string) {
        this(string, null);
    }

    public FileFilter(String string, String string2) {
        this();
        if (string != null) {
            this.addExtension(string);
        }
        if (string2 != null) {
            this.setDescription(string2);
        }
    }

    public FileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public FileFilter(String[] stringArray, String string) {
        this();
        int n = 0;
        while (n < stringArray.length) {
            this.addExtension(stringArray[n]);
            ++n;
        }
        if (string != null) {
            this.setDescription(string);
        }
    }

    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this.filters.get((Object)this.getExtension(file)) != null) {
                return true;
            }
        }
        return false;
    }

    public void addExtension(String string) {
        if (this.filters == null) {
            this.filters = new HashMap();
        }
        this.filters.put((Object)string.toLowerCase(), (Object)this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : String.valueOf(this.description) + " (";
                Iterator iterator = this.filters.keySet().iterator();
                if (iterator != null) {
                    this.fullDescription = String.valueOf(this.fullDescription) + (String)iterator.next();
                    while (iterator.hasNext()) {
                        this.fullDescription = String.valueOf(this.fullDescription) + ", " + (String)iterator.next();
                    }
                }
                this.fullDescription = String.valueOf(this.fullDescription) + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public String getExtension(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.useExtensionsInDescription = bl;
        this.fullDescription = null;
    }
}

