/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import pw.palmpatch.ui.ISearchStringConsumer;
import pw.palmpatch.ui.ISearchStringProvider;

public class SearchStringProvider
extends KeyAdapter
implements ISearchStringProvider,
MouseListener {
    protected String searchString;
    protected ISearchStringConsumer aSearchStringConsumer;

    public SearchStringProvider(ISearchStringConsumer iSearchStringConsumer) {
        this.aSearchStringConsumer = iSearchStringConsumer;
        this.searchString = "";
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.aSearchStringConsumer.searchNext(this.searchString);
        } else if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 33 || keyEvent.getKeyCode() == 34) {
            this.searchString = "";
            this.aSearchStringConsumer.searchFor(this.searchString);
        } else if (keyEvent.getKeyCode() == 8 && this.searchString.length() > 0) {
            this.searchString = this.searchString.substring(0, this.searchString.length() - 1);
            this.aSearchStringConsumer.searchFor(this.searchString);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (Character.isLetterOrDigit(c) || Character.isSpaceChar(c) || Character.getType(c) == 26 || Character.getType(c) == 20 || Character.getType(c) == 7 || Character.getType(c) == 22 || Character.getType(c) == 25 || Character.getType(c) == 21 || Character.getType(c) == 24) {
            this.searchString = String.valueOf(this.searchString) + keyEvent.getKeyChar();
            this.aSearchStringConsumer.searchFor(this.searchString);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.searchString = "";
        this.aSearchStringConsumer.searchFor(this.searchString);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

