/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import com.sun.java.util.collections.List;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import pw.palmpatch.ui.views.AbstractTableView;
import pw.palmpatch.ui.views.View;
import pw.palmpatch.ui.widgets.Table;

public class AbstractTableView
extends View {
    protected Table myTable;
    protected JPopupMenu popupMenu;
    protected JScrollPane tableScrollPane;

    public AbstractTableView() {
        this.initialize();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.myTable.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void addMouseListenerToTable(MouseListener mouseListener) {
        this.myTable.addMouseListener(mouseListener);
    }

    public int getSelectedIndex() {
        return this.myTable.getSelectedRow();
    }

    public int[] getSelectedIndices() {
        return this.myTable.getSelectedRows();
    }

    public void initialize() {
        this.setLayout(new BorderLayout());
        this.myTable = new Table();
        this.myTable.setAutoResizeMode(0);
        this.myTable.sizeColumnsToContents();
        this.tableScrollPane = new JScrollPane();
        this.myTable.setToolTipText("Click on the right mouse button to bring up a menu");
        this.tableScrollPane.setToolTipText("Click on the right mouse button to bring up a menu");
        this.tableScrollPane.setViewportView(this.myTable);
        this.add("Center", this.tableScrollPane);
    }

    public void setActions(List list) {
        this.popupMenu = new JPopupMenu();
        try {
            this.tableScrollPane.add(this.popupMenu);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("NullPointerException while adding JPopupMenu to JScrollPane" + System.getProperty("line.separator") + nullPointerException);
        }
        this.myTable.add(this.popupMenu);
        class MyMouseAdapter
        extends MouseAdapter {
            private final /* synthetic */ AbstractTableView this$0;

            MyMouseAdapter(AbstractTableView abstractTableView) {
                this.this$0 = abstractTableView;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.this$0.popupMenu.show(this.this$0.tableScrollPane, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.this$0.popupMenu.show(this.this$0.tableScrollPane, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                }
            }
        }
        MyMouseAdapter myMouseAdapter = new MyMouseAdapter(this);
        this.tableScrollPane.addMouseListener(myMouseAdapter);
        this.myTable.addMouseListener(myMouseAdapter);
        int n = 0;
        while (n < list.size()) {
            if (list.get(n) instanceof Action) {
                this.popupMenu.add((Action)list.get(n));
            }
            ++n;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.myTable.setEnabled(bl);
    }

    public void sizeColumnsToContents() {
        this.myTable.sizeColumnsToContents();
    }

    public void updateUI() {
        super.updateUI();
        if (this.popupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.popupMenu);
        }
    }
}

