/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;
import pw.palmpatch.controller.Controller;
import pw.palmpatch.controller.TargetViewAndEditController;
import pw.palmpatch.models.FileInfo;
import pw.palmpatch.models.TargetInfo;
import pw.palmpatch.models.TargetInfoToFileInfosTableModelAdapter;
import pw.palmpatch.ui.views.AbstractTableView;
import pw.palmpatch.ui.widgets.FileInfosTableCellRenderer;

public class FileInfosTableView
extends AbstractTableView {
    protected TargetInfoToFileInfosTableModelAdapter myTargetInfoToFileInfosTableModelAdapter;
    protected JLabel patchableLabel;
    protected static Color green = new Color(25, 150, 60);
    protected static Color orange = new Color(255, 140, 60);
    static /* synthetic */ Class class$java$lang$Object;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public FileInfo getSelectedFileInfo() {
        int n = this.myTable.getSelectedRow();
        if (n != -1 && !this.myTable.getSelectionModel().isSelectionEmpty()) {
            return this.myTargetInfoToFileInfosTableModelAdapter.getFileInfoAt(n);
        }
        return null;
    }

    public void initialize() {
        super.initialize();
        this.myTable.setDefaultRenderer(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = FileInfosTableView.class$("java.lang.Object")), new FileInfosTableCellRenderer());
        this.myTable.setSelectionMode(0);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("File Infos");
        titledBorder.setTitleFont(new Font("Dialog", 0, 10));
        this.setBorder(titledBorder);
        Box box = new Box(0);
        JLabel jLabel = new JLabel("Match");
        jLabel.setForeground(Color.blue);
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(5));
        JLabel jLabel2 = new JLabel("Patched");
        jLabel2.setForeground(green);
        box.add(jLabel2);
        box.add(Box.createHorizontalStrut(25));
        this.patchableLabel = new JLabel("");
        box.add(this.patchableLabel);
        box.add(Box.createHorizontalStrut(5));
        this.add("South", box);
    }

    public void setController(Controller controller) {
        super.setController(controller);
        this.myTargetInfoToFileInfosTableModelAdapter = ((TargetViewAndEditController)this.getController()).getTargetInfoToFileInfosTableModelAdapter();
        this.myTable.setModel(this.myTargetInfoToFileInfosTableModelAdapter);
    }

    public void setModel(TargetInfo targetInfo) {
        this.myTargetInfoToFileInfosTableModelAdapter.setTargetInfo(targetInfo);
        this.myTable.clearSelection();
    }

    public void setSelectedFileInfo(int n) {
        FileInfo fileInfo = ((TargetInfoToFileInfosTableModelAdapter)this.myTable.getModel()).getFileInfoAt(this.myTable.getSelectedRow());
        this.updatePatchableStatus(fileInfo);
        if (this.myTable.getSelectedRow() == n) {
            return;
        }
        if (n < 0) {
            this.myTable.clearSelection();
        } else {
            this.myTable.setRowSelectionInterval(n, n);
            this.myTable.scrollToRow(n);
        }
    }

    public void updatePatchableStatus(FileInfo fileInfo) {
        if (fileInfo == null) {
            this.patchableLabel.setText("");
        } else if (fileInfo.getAssociatedTargetFile() == null) {
            this.patchableLabel.setText("");
        } else if (fileInfo.getPossibleWayToPatch() == TargetViewAndEditController.SMARTPATCH_POSSIBLE) {
            this.patchableLabel.setText("Target smart-patchable");
            this.patchableLabel.setForeground(orange);
        } else if (fileInfo.getPossibleWayToPatch() == TargetViewAndEditController.NORMAL_PATCHING_POSSIBLE) {
            this.patchableLabel.setText("Target patchable");
            this.patchableLabel.setForeground(green);
        } else {
            this.patchableLabel.setText("Target not patchable");
            this.patchableLabel.setForeground(Color.red);
        }
    }
}

