/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;
import pw.palmpatch.io.palmfiles.PRCDatabase;
import pw.palmpatch.io.palmfiles.PalmDatabase;
import pw.palmpatch.ui.views.FileView;

public class PalmPilotFileView
extends FileView {
    private JLabel idLabel;
    private JLabel fileNameLabel;
    private JLabel sizeLabel;
    private JLabel versionLabel;
    private JLabel crc16Label;
    private JLabel idValueLabel;
    private JLabel fileNameValueLabel;
    private JLabel fileSizeValueLabel;
    private JLabel versionValueLabel;
    private JLabel crc16ValueLabel;

    public void initialize() {
        super.initialize();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Selected Target File Infos");
        titledBorder.setTitleFont(new Font("Dialog", 0, 10));
        this.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.idLabel = new JLabel("ID:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.idLabel, gridBagConstraints);
        this.add(this.idLabel);
        this.idValueLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.idValueLabel, gridBagConstraints);
        this.add(this.idValueLabel);
        this.fileNameLabel = new JLabel("Filename:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.fileNameLabel, gridBagConstraints);
        this.add(this.fileNameLabel);
        this.fileNameValueLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.fileNameValueLabel, gridBagConstraints);
        this.add(this.fileNameValueLabel);
        this.versionLabel = new JLabel("Version:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.versionLabel, gridBagConstraints);
        this.add(this.versionLabel);
        this.versionValueLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.versionValueLabel, gridBagConstraints);
        this.add(this.versionValueLabel);
        this.sizeLabel = new JLabel("Size:");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.sizeLabel, gridBagConstraints);
        this.add(this.sizeLabel);
        this.fileSizeValueLabel = new JLabel();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.fileSizeValueLabel, gridBagConstraints);
        this.add(this.fileSizeValueLabel);
        this.crc16Label = new JLabel("CRC16:");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.crc16Label, gridBagConstraints);
        this.add(this.crc16Label);
        this.crc16ValueLabel = new JLabel();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.crc16ValueLabel, gridBagConstraints);
        this.add(this.crc16ValueLabel);
    }

    public void setFile(File file) {
        if (!(file instanceof PalmDatabase)) {
            throw new IllegalArgumentException("This view (" + this.getClass() + ") only supports PalmDatabase. For other files please use a different view");
        }
        super.setFile(file);
        this.idValueLabel.setText(((PalmDatabase)this.file).getDatabaseName());
        this.fileNameValueLabel.setText(this.file.getName());
        if (file instanceof PRCDatabase) {
            this.versionValueLabel.setText(((PRCDatabase)this.file).getVersion());
        }
        this.fileSizeValueLabel.setText(Long.toString(this.file.length()));
        this.crc16ValueLabel.setText(((PalmDatabase)this.file).getCRC16());
    }
}

