/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pw.palmpatch.ui.views.MessagesView;
import pw.palmpatch.ui.views.PreferenceNodeBasedPreferencesView;
import pw.palmpatch.ui.views.StatisticsView;
import pw.palmpatch.ui.views.StatusBar;
import pw.palmpatch.ui.views.TargetViewAndEditView;
import pw.palmpatch.ui.views.View;
import pw.palmpatch.ui.widgets.ProgressIndicator;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.IMessage;
import pw.palmpatch.util.InfoMessage;
import pw.palmpatch.util.LogListener;
import pw.palmpatch.util.WarningMessage;

public class PatcherMainView
extends View
implements LogListener {
    private JTabbedPane tabbedPane;
    private TargetViewAndEditView targetViewAndEditView;
    private MessagesView aMessagesView;
    private StatisticsView aStatisticsView;
    private PreferenceNodeBasedPreferencesView aPreferenceNodeBasedPreferencesView;
    private StatusBar aStatusBar;
    private boolean infoLogged;
    private boolean warningLogged;
    private boolean errorLogged;

    public PatcherMainView() {
        this.initialize();
    }

    static /* synthetic */ boolean access$1(PatcherMainView patcherMainView) {
        return patcherMainView.infoLogged;
    }

    static /* synthetic */ boolean access$3(PatcherMainView patcherMainView) {
        return patcherMainView.warningLogged;
    }

    static /* synthetic */ boolean access$5(PatcherMainView patcherMainView) {
        return patcherMainView.errorLogged;
    }

    public void clearLog() {
        this.aMessagesView.clearLog();
        this.infoLogged = false;
        this.warningLogged = false;
        this.errorLogged = false;
    }

    public MessagesView getMessagesView() {
        return this.aMessagesView;
    }

    public PreferenceNodeBasedPreferencesView getPreferenceNodeBasedPreferencesView() {
        return this.aPreferenceNodeBasedPreferencesView;
    }

    public ProgressIndicator getProgressIndicator() {
        return this.aStatusBar.getProgressIndicator();
    }

    public View getStatisticsView() {
        return this.aStatisticsView;
    }

    public TargetViewAndEditView getTargetViewAndEditView() {
        return this.targetViewAndEditView;
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.targetViewAndEditView = new TargetViewAndEditView();
        this.aMessagesView = new MessagesView();
        this.aStatisticsView = new StatisticsView();
        this.aStatusBar = new StatusBar();
        this.tabbedPane.add("Targets", this.targetViewAndEditView);
        this.tabbedPane.add("Statistics", this.aStatisticsView);
        this.tabbedPane.add("Messages", this.aMessagesView);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (PatcherMainView.this.tabbedPane.getSelectedIndex() == 2) {
                    PatcherMainView.this.tabbedPane.setForegroundAt(2, UIManager.getColor("TabbedPane.foreground"));
                    PatcherMainView.this.infoLogged = false;
                    PatcherMainView.this.warningLogged = false;
                    PatcherMainView.this.errorLogged = false;
                }
            }
        });
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.aStatusBar, "South");
    }

    public void logNewMessage(IMessage iMessage) {
        this.aMessagesView.logNewMessage(iMessage);
        if (this.tabbedPane.getSelectedIndex() != 2) {
            if (iMessage instanceof InfoMessage && !this.warningLogged && !this.errorLogged) {
                this.tabbedPane.setForegroundAt(2, Color.blue);
                this.infoLogged = true;
            } else if (iMessage instanceof WarningMessage && !this.errorLogged) {
                this.tabbedPane.setForegroundAt(2, Color.orange);
                this.warningLogged = true;
            } else if (iMessage instanceof ErrorMessage) {
                this.tabbedPane.setForegroundAt(2, Color.red);
                this.errorLogged = true;
            }
        }
    }

    public void setStatusMessage(String string) {
        this.aStatusBar.setMessage(string);
    }
}

