/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JPanel;
import pw.palmpatch.Application;
import pw.palmpatch.PreferenceNode;
import pw.palmpatch.Preferences;
import pw.palmpatch.controller.PWAction;
import pw.palmpatch.controller.PreferenceNodeBasedPreferencesController;
import pw.palmpatch.controller.preferences.ConfirmationsPreferenceNode;
import pw.palmpatch.controller.preferences.DownloadPreferenceNode;
import pw.palmpatch.controller.preferences.PatcherControllerPreferenceNode;
import pw.palmpatch.controller.preferences.TargetInfoEditorPreferenceNode;
import pw.palmpatch.controller.preferences.UIPreferenceNode;
import pw.palmpatch.models.PreferencesControllerModel;
import pw.palmpatch.ui.views.PWDialog;
import pw.palmpatch.ui.views.PreferenceNodeBasedPreferencesView;
import pw.palmpatch.ui.widgets.PWButton;

public class PreferencesDialog
extends PWDialog {
    protected PWButton applyButton;
    protected PWButton applyAllButton;
    protected PWButton resetButton;
    protected PWButton closeButton;
    protected PWButton okButton;
    protected PWAction closeAction;
    protected PreferenceNodeBasedPreferencesView view;
    protected PreferenceNodeBasedPreferencesController preferencesController;
    protected PreferencesControllerModel preferencesControllerModel;
    protected Preferences preferences;

    public PreferencesDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.getContentPane().setLayout(new BorderLayout());
        this.applyButton = new PWButton("Apply");
        this.applyButton.addActionListener(new ApplyAction());
        this.applyAllButton = new PWButton("Apply All");
        this.applyAllButton.addActionListener(new ApplyAllAction());
        this.resetButton = new PWButton("Reset");
        this.resetButton.addActionListener(new ResetAction());
        this.closeButton = new PWButton();
        this.closeAction = new CloseAction();
        this.closeButton.addActionListener(this.closeAction);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(this.closeButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.applyButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.applyAllButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.resetButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.preferencesControllerModel = new PreferencesControllerModel();
        PreferenceNode[] preferenceNodeArray = new PreferenceNode[]{new UIPreferenceNode(), new PatcherControllerPreferenceNode(), new TargetInfoEditorPreferenceNode(), new ConfirmationsPreferenceNode(), new DownloadPreferenceNode()};
        this.preferencesControllerModel.setRootPreferenceNodes(preferenceNodeArray);
        this.preferences = Application.singleton().getPreferences();
        this.preferencesControllerModel.setPreferences(this.preferences);
        this.view = new PreferenceNodeBasedPreferencesView(this.preferencesControllerModel);
        this.preferencesControllerModel.addModelListener(this.view);
        this.preferencesController = new PreferenceNodeBasedPreferencesController();
        this.preferencesController.setModel(this.preferencesControllerModel);
        this.preferencesController.setView(this.view);
        this.view.setController(this.preferencesController);
        this.getContentPane().add((Component)this.view, "Center");
        this.setTitle("Preferences");
        this.setDefaultCloseOperation(0);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    PreferencesDialog.this.closeAction.invokeFromCode();
                }
            }
        });
    }

    public void performApplyAction() {
        this.view.getSelectedPreferenceNode().save(this.preferences);
    }

    public void performApplyAllAction() {
        List list = this.preferencesControllerModel.getAllPreferenceNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((PreferenceNode)iterator.next()).save(this.preferences);
        }
    }

    public void performCloseAction() {
        this.dispose();
    }

    public void performResetAction() {
        this.view.getSelectedPreferenceNode().display(this.preferences);
    }

    class CloseAction
    extends PWAction {
        CloseAction() {
            super(3, "");
            this.putValue("Name", "Close");
            this.putValue("ShortDescription", "Close");
            this.putValue("LongDescription", "Close");
        }

        public void perform(ActionEvent actionEvent) {
            PreferencesDialog.this.performCloseAction();
        }
    }

    private class ApplyAction
    extends PWAction {
        ApplyAction() {
            super(3, "");
            this.putValue("Name", "Apply");
            this.putValue("ShortDescription", "Apply");
            this.putValue("LongDescription", "Apply");
        }

        public void perform(ActionEvent actionEvent) {
            PreferencesDialog.this.performApplyAction();
        }
    }

    private class ApplyAllAction
    extends PWAction {
        ApplyAllAction() {
            super(3, "");
            this.putValue("Name", "Apply All");
            this.putValue("ShortDescription", "Apply All");
            this.putValue("LongDescription", "Apply All");
        }

        public void perform(ActionEvent actionEvent) {
            PreferencesDialog.this.performApplyAllAction();
        }
    }

    private class ResetAction
    extends PWAction {
        ResetAction() {
            super(3, "");
            this.putValue("Name", "Reset");
            this.putValue("ShortDescription", "Reset");
            this.putValue("LongDescription", "Reset");
        }

        public void perform(ActionEvent actionEvent) {
            PreferencesDialog.this.performResetAction();
        }
    }
}

