/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pw.palmpatch.events.ExceptionListener;
import pw.palmpatch.models.TargetInfo;
import pw.palmpatch.ui.views.View;
import pw.palmpatch.ui.widgets.ReadOnlySupportedTextArea;
import pw.palmpatch.ui.widgets.ReadOnlySupportedTextField;
import pw.palmpatch.ui.widgets.URLLaunchingReadOnlySupportedTextField;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.Log;

public class TargetInfoView
extends View {
    private JLabel longNameLabel;
    private JLabel urlLabel;
    private JLabel creditsLabel;
    private JLabel infoTextLabel;
    private ReadOnlySupportedTextField longNameTextField;
    private URLLaunchingReadOnlySupportedTextField urlTextField;
    private ReadOnlySupportedTextField creditsTextField;
    private ReadOnlySupportedTextArea infoTextTextArea;
    private JScrollPane infoTextTextAreaScrollPane;
    private Border defaultScrollPaneBorder;
    private Border emptyScrollPaneBorder;
    private TargetInfo model;

    public TargetInfoView() {
        this.initialize();
    }

    public void fillTargetInfo(TargetInfo targetInfo) {
        targetInfo.setLongName(this.longNameTextField.getText());
        targetInfo.setUrl(this.urlTextField.getText());
        targetInfo.setCredits(this.creditsTextField.getText());
        targetInfo.setText(this.infoTextTextArea.getText());
    }

    public TargetInfo getModel() {
        return this.model;
    }

    public void initialize() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Target Infos");
        titledBorder.setTitleFont(new Font("Dialog", 0, 10));
        this.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(0, 3, 3, 3)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 1, 2, 2);
        gridBagConstraints.anchor = 17;
        this.longNameLabel = new JLabel("Name:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.longNameLabel, gridBagConstraints);
        this.add(this.longNameLabel);
        this.longNameTextField = new ReadOnlySupportedTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.longNameTextField, gridBagConstraints);
        this.add(this.longNameTextField);
        this.urlLabel = new JLabel("URL:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.urlLabel, gridBagConstraints);
        this.add(this.urlLabel);
        this.urlTextField = new URLLaunchingReadOnlySupportedTextField();
        this.urlTextField.addExceptionListener(new ExceptionListener(){

            public void exceptionOccurred(Throwable throwable) {
                Log.singleton().logNewMessage(new ErrorMessage("Could not launch ULR: " + TargetInfoView.this.urlTextField.getText().trim() + " because of: " + throwable));
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.urlTextField, gridBagConstraints);
        this.add(this.urlTextField);
        this.creditsLabel = new JLabel("Credits:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.creditsLabel, gridBagConstraints);
        this.add(this.creditsLabel);
        this.creditsTextField = new ReadOnlySupportedTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.creditsTextField, gridBagConstraints);
        this.add(this.creditsTextField);
        this.infoTextLabel = new JLabel("Info:");
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.infoTextLabel, gridBagConstraints);
        this.add(this.infoTextLabel);
        this.infoTextTextArea = new ReadOnlySupportedTextArea(3, 35);
        this.infoTextTextArea.setLineWrap(true);
        this.infoTextTextArea.setWrapStyleWord(true);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.infoTextTextAreaScrollPane = new JScrollPane(this.infoTextTextArea);
        this.defaultScrollPaneBorder = this.infoTextTextAreaScrollPane.getBorder();
        this.emptyScrollPaneBorder = BorderFactory.createEmptyBorder();
        this.infoTextTextAreaScrollPane.setBorder(this.emptyScrollPaneBorder);
        this.infoTextTextAreaScrollPane.setHorizontalScrollBarPolicy(30);
        this.infoTextTextAreaScrollPane.setVerticalScrollBarPolicy(20);
        gridBagLayout.setConstraints(this.infoTextTextAreaScrollPane, gridBagConstraints);
        this.add(this.infoTextTextAreaScrollPane);
    }

    protected void modelChanged() {
        if (this.model != null) {
            this.longNameTextField.setText(this.model.getLongName());
            this.urlTextField.setText(this.model.getUrl());
            this.creditsTextField.setText(this.model.getCredits());
            this.infoTextTextArea.setText(this.model.getText());
            this.infoTextTextArea.repaint();
            this.longNameTextField.select(0, 0);
            this.urlTextField.select(0, 0);
            this.creditsTextField.select(0, 0);
        } else {
            this.longNameTextField.setText("");
            this.urlTextField.setText("");
            this.creditsTextField.setText("");
            this.infoTextTextArea.setText("");
            this.infoTextTextArea.repaint();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.longNameTextField.setEnabled(bl);
        this.urlTextField.setEnabled(bl);
        this.creditsTextField.setEnabled(bl);
        this.infoTextTextArea.setEnabled(bl);
        if (bl) {
            this.infoTextTextAreaScrollPane.setBorder((Border)UIManager.get("TextField.border"));
            this.longNameTextField.requestFocus();
        } else {
            this.infoTextTextAreaScrollPane.setBorder(this.emptyScrollPaneBorder);
        }
    }

    public void setModel(TargetInfo targetInfo) {
        this.model = targetInfo;
        this.modelChanged();
    }
}

